/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.file.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashSet;
import java.util.Set;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.file.AsyncFile;
import org.vertx.java.core.file.FileSystemException;
import org.vertx.java.core.impl.BlockingAction;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public class DefaultAsyncFile
implements AsyncFile {
    private static final Logger log = LoggerFactory.getLogger(AsyncFile.class);
    public static final int BUFFER_SIZE = 8192;
    private final VertxInternal vertx;
    private final AsynchronousFileChannel ch;
    private final DefaultContext context;
    private boolean closed;
    private Runnable closedDeferred;
    private long writesOutstanding;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> drainHandler;
    private int writePos;
    private int maxWrites = 131072;
    private int lwm = this.maxWrites / 2;
    private boolean paused;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private int readPos;
    private boolean readInProgress;

    DefaultAsyncFile(VertxInternal vertx, String path, String perms, boolean read, boolean write, boolean createNew, boolean flush, DefaultContext context) {
        if (!read && !write) {
            throw new FileSystemException("Cannot open file for neither reading nor writing");
        }
        this.vertx = vertx;
        Path file = Paths.get(path, new String[0]);
        HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
        if (read) {
            options.add(StandardOpenOption.READ);
        }
        if (write) {
            options.add(StandardOpenOption.WRITE);
        }
        if (createNew) {
            options.add(StandardOpenOption.CREATE);
        }
        if (flush) {
            options.add(StandardOpenOption.DSYNC);
        }
        try {
            if (perms != null) {
                FileAttribute<Set<PosixFilePermission>> attrs = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
                this.ch = AsynchronousFileChannel.open(file, options, vertx.getBackgroundPool(), attrs);
            } else {
                this.ch = AsynchronousFileChannel.open(file, options, vertx.getBackgroundPool(), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
        this.context = context;
    }

    @Override
    public void close() {
        this.closeInternal(null);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.closeInternal(handler);
    }

    @Override
    public AsyncFile write(Buffer buffer, int position, Handler<AsyncResult<Void>> handler) {
        this.check();
        ByteBuffer bb = buffer.getByteBuf().nioBuffer();
        this.doWrite(bb, position, handler);
        return this;
    }

    @Override
    public AsyncFile read(Buffer buffer, int offset, int position, int length, Handler<AsyncResult<Buffer>> handler) {
        this.check();
        ByteBuffer bb = ByteBuffer.allocate(length);
        this.doRead(buffer, offset, bb, position, handler);
        return this;
    }

    @Override
    public AsyncFile write(Buffer buffer) {
        this.check();
        int length = buffer.length();
        ByteBuffer bb = buffer.getByteBuf().nioBuffer();
        this.doWrite(bb, this.writePos, new Handler<AsyncResult<Void>>(){

            @Override
            public void handle(AsyncResult<Void> deferred) {
                if (deferred.succeeded()) {
                    DefaultAsyncFile.this.checkContext();
                    DefaultAsyncFile.this.checkDrained();
                    if (DefaultAsyncFile.this.writesOutstanding == 0L && DefaultAsyncFile.this.closedDeferred != null) {
                        DefaultAsyncFile.this.closedDeferred.run();
                    }
                } else {
                    DefaultAsyncFile.this.handleException(deferred.cause());
                }
            }
        });
        this.writePos += length;
        return this;
    }

    private void checkDrained() {
        if (this.drainHandler != null && this.writesOutstanding <= (long)this.lwm) {
            Handler<Void> handler = this.drainHandler;
            this.drainHandler = null;
            handler.handle(null);
        }
    }

    @Override
    public AsyncFile setWriteQueueMaxSize(int maxSize) {
        this.check();
        this.maxWrites = maxSize;
        this.lwm = this.maxWrites / 2;
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        this.check();
        return this.writesOutstanding >= (long)this.maxWrites;
    }

    @Override
    public AsyncFile drainHandler(Handler<Void> handler) {
        this.check();
        this.drainHandler = handler;
        this.checkDrained();
        return this;
    }

    @Override
    public AsyncFile exceptionHandler(Handler<Throwable> handler) {
        this.check();
        this.exceptionHandler = handler;
        return this;
    }

    private void handleException(Throwable t) {
        if (this.exceptionHandler != null && t instanceof Exception) {
            this.exceptionHandler.handle(t);
        } else {
            log.error("Unhandled exception", t);
        }
    }

    private void doRead() {
        if (!this.readInProgress) {
            this.readInProgress = true;
            Buffer buff = new Buffer(8192);
            this.read(buff, 0, this.readPos, 8192, new Handler<AsyncResult<Buffer>>(){

                @Override
                public void handle(AsyncResult<Buffer> ar) {
                    if (ar.succeeded()) {
                        DefaultAsyncFile.this.readInProgress = false;
                        Buffer buffer = ar.result();
                        if (buffer.length() == 0) {
                            DefaultAsyncFile.this.handleEnd();
                        } else {
                            DefaultAsyncFile.this.readPos += buffer.length();
                            DefaultAsyncFile.this.handleData(buffer);
                            if (!DefaultAsyncFile.this.paused && DefaultAsyncFile.this.dataHandler != null) {
                                DefaultAsyncFile.this.doRead();
                            }
                        }
                    } else {
                        DefaultAsyncFile.this.handleException(ar.cause());
                    }
                }
            });
        }
    }

    @Override
    public AsyncFile dataHandler(Handler<Buffer> handler) {
        this.check();
        this.dataHandler = handler;
        if (this.dataHandler != null && !this.paused && !this.closed) {
            this.doRead();
        }
        return this;
    }

    @Override
    public AsyncFile endHandler(Handler<Void> handler) {
        this.check();
        this.endHandler = handler;
        return this;
    }

    @Override
    public AsyncFile pause() {
        this.check();
        this.paused = true;
        return this;
    }

    @Override
    public AsyncFile resume() {
        this.check();
        if (this.paused && !this.closed) {
            this.paused = false;
            if (this.dataHandler != null) {
                this.doRead();
            }
        }
        return this;
    }

    private void handleData(Buffer buffer) {
        if (this.dataHandler != null) {
            this.checkContext();
            this.dataHandler.handle(buffer);
        }
    }

    private void handleEnd() {
        if (this.endHandler != null) {
            this.checkContext();
            this.endHandler.handle(null);
        }
    }

    @Override
    public AsyncFile flush() {
        this.doFlush(null);
        return this;
    }

    @Override
    public AsyncFile flush(Handler<AsyncResult<Void>> handler) {
        this.doFlush(handler);
        return this;
    }

    private void doFlush(Handler<AsyncResult<Void>> handler) {
        this.checkClosed();
        this.checkContext();
        new BlockingAction<Void>(this.vertx, handler){

            @Override
            public Void action() {
                try {
                    DefaultAsyncFile.this.ch.force(false);
                    return null;
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
        }.run();
    }

    private void doWrite(ByteBuffer buff, int position, Handler<AsyncResult<Void>> handler) {
        this.writesOutstanding += (long)buff.limit();
        this.writeInternal(buff, position, handler);
    }

    private void writeInternal(final ByteBuffer buff, final int position, final Handler<AsyncResult<Void>> handler) {
        this.ch.write(buff, position, null, new CompletionHandler<Integer, Object>(){

            @Override
            public void completed(Integer bytesWritten, Object attachment) {
                int pos = position;
                if (buff.hasRemaining()) {
                    DefaultAsyncFile.this.writeInternal(buff, pos += bytesWritten.intValue(), handler);
                } else {
                    DefaultAsyncFile.this.context.execute(new Runnable(){

                        @Override
                        public void run() {
                            DefaultAsyncFile.this.writesOutstanding -= buff.limit();
                            handler.handle(new DefaultFutureResult().setResult((Object)null));
                        }
                    });
                }
            }

            @Override
            public void failed(Throwable exc, Object attachment) {
                if (exc instanceof Exception) {
                    Exception e = (Exception)exc;
                    DefaultAsyncFile.this.context.execute(new Runnable(){

                        @Override
                        public void run() {
                            handler.handle(new DefaultFutureResult().setResult((Object)null));
                        }
                    });
                } else {
                    log.error("Error occurred", exc);
                }
            }
        });
    }

    private void doRead(final Buffer writeBuff, final int offset, final ByteBuffer buff, final int position, final Handler<AsyncResult<Buffer>> handler) {
        this.ch.read(buff, position, null, new CompletionHandler<Integer, Object>(){
            int pos;
            final DefaultFutureResult<Buffer> result;
            {
                this.pos = position;
                this.result = new DefaultFutureResult();
            }

            private void done() {
                DefaultAsyncFile.this.context.execute(new Runnable(){

                    @Override
                    public void run() {
                        buff.flip();
                        writeBuff.setBytes(offset, buff);
                        ((DefaultFutureResult)result.setResult((Object)writeBuff)).setHandler(handler);
                    }
                });
            }

            @Override
            public void completed(Integer bytesRead, Object attachment) {
                if (bytesRead == -1) {
                    this.done();
                } else if (buff.hasRemaining()) {
                    this.pos += bytesRead.intValue();
                    DefaultAsyncFile.this.doRead(writeBuff, offset, buff, this.pos, handler);
                } else {
                    this.done();
                }
            }

            @Override
            public void failed(final Throwable t, Object attachment) {
                DefaultAsyncFile.this.context.execute(new Runnable(){

                    @Override
                    public void run() {
                        ((DefaultFutureResult)result.setFailure(t)).setHandler(handler);
                    }
                });
            }
        });
    }

    private void check() {
        this.checkClosed();
        this.checkContext();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("File handle is closed");
        }
    }

    private void checkContext() {
        if (!this.vertx.getContext().equals(this.context)) {
            throw new IllegalStateException("AsyncFile must only be used in the context that created it, expected: " + this.context + " actual " + this.vertx.getContext());
        }
    }

    private void doClose(Handler<AsyncResult<Void>> handler) {
        DefaultFutureResult res = new DefaultFutureResult();
        try {
            this.ch.close();
            res.setResult((Object)null);
        }
        catch (IOException e) {
            res.setFailure(e);
        }
        if (handler != null) {
            handler.handle(res);
        }
    }

    private void closeInternal(final Handler<AsyncResult<Void>> handler) {
        this.check();
        this.closed = true;
        if (this.writesOutstanding == 0L) {
            this.doClose(handler);
        } else {
            this.closedDeferred = new Runnable(){

                @Override
                public void run() {
                    DefaultAsyncFile.this.doClose(handler);
                }
            };
        }
    }
}

