/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.streams;

import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.streams.ReadStream;
import org.vertx.java.core.streams.WriteStream;

public class Pump {
    private final ReadStream readStream;
    private final WriteStream writeStream;
    private int pumped;
    private final Handler<Void> drainHandler = new Handler<Void>(){

        @Override
        public void handle(Void v) {
            Pump.this.readStream.resume();
        }
    };
    private final Handler<Buffer> dataHandler = new Handler<Buffer>(){

        @Override
        public void handle(Buffer buffer) {
            Pump.this.writeStream.write(buffer);
            Pump.this.pumped += buffer.length();
            if (Pump.this.writeStream.writeQueueFull()) {
                Pump.this.readStream.pause();
                Pump.this.writeStream.drainHandler(Pump.this.drainHandler);
            }
        }
    };

    public static Pump createPump(ReadStream rs, WriteStream ws) {
        return new Pump(rs, ws);
    }

    public static Pump createPump(ReadStream rs, WriteStream ws, int writeQueueMaxSize) {
        return new Pump(rs, ws, writeQueueMaxSize);
    }

    public Pump setWriteQueueMaxSize(int maxSize) {
        this.writeStream.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public Pump start() {
        this.readStream.dataHandler(this.dataHandler);
        return this;
    }

    public Pump stop() {
        this.writeStream.drainHandler(null);
        this.readStream.dataHandler(null);
        return this;
    }

    public int getBytesPumped() {
        return this.pumped;
    }

    private Pump(ReadStream rs, WriteStream ws, int maxWriteQueueSize) {
        this(rs, ws);
        this.writeStream.setWriteQueueMaxSize(maxWriteQueueSize);
    }

    private Pump(ReadStream rs, WriteStream ws) {
        this.readStream = rs;
        this.writeStream = ws;
    }
}

