/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.Map;
import org.vertx.java.core.http.impl.AbstractConnection;
import org.vertx.java.core.http.impl.ws.DefaultWebSocketFrame;
import org.vertx.java.core.http.impl.ws.WebSocketFrame;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.net.impl.VertxHandler;

public abstract class VertxHttpHandler<C extends AbstractConnection>
extends VertxHandler<C> {
    private final VertxInternal vertx;

    protected VertxHttpHandler(VertxInternal vertx, Map<Channel, C> connectionMap) {
        super(vertx, connectionMap);
        this.vertx = vertx;
    }

    private static ByteBuf safeBuffer(ByteBufHolder holder) {
        return VertxHttpHandler.safeBuffer(holder.content());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(final ChannelHandlerContext chctx, Object msg) throws Exception {
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            ByteBuf buf = content.content();
            if (buf != Unpooled.EMPTY_BUFFER && buf.isDirect()) {
                ByteBuf newBuf = VertxHttpHandler.safeBuffer((ByteBufHolder)content);
                if (msg instanceof LastHttpContent) {
                    LastHttpContent last = (LastHttpContent)msg;
                    msg = new DefaultLastHttpContent(newBuf);
                    ((LastHttpContent)msg).trailingHeaders().set(last.trailingHeaders());
                } else {
                    msg = new DefaultHttpContent(newBuf);
                }
            }
        } else if (msg instanceof io.netty.handler.codec.http.websocketx.WebSocketFrame) {
            ByteBuf payload = VertxHttpHandler.safeBuffer((ByteBufHolder)((io.netty.handler.codec.http.websocketx.WebSocketFrame)msg));
            if (msg instanceof BinaryWebSocketFrame) {
                msg = new DefaultWebSocketFrame(WebSocketFrame.FrameType.BINARY, payload);
            } else if (msg instanceof CloseWebSocketFrame) {
                msg = new DefaultWebSocketFrame(WebSocketFrame.FrameType.CLOSE, payload);
            } else if (msg instanceof PingWebSocketFrame) {
                msg = new DefaultWebSocketFrame(WebSocketFrame.FrameType.PING, payload);
            } else if (msg instanceof PongWebSocketFrame) {
                msg = new DefaultWebSocketFrame(WebSocketFrame.FrameType.PONG, payload);
            } else if (msg instanceof TextWebSocketFrame) {
                msg = new DefaultWebSocketFrame(WebSocketFrame.FrameType.TEXT, payload);
            } else if (msg instanceof ContinuationWebSocketFrame) {
                msg = new DefaultWebSocketFrame(WebSocketFrame.FrameType.CONTINUATION, payload);
            } else {
                throw new IllegalStateException("Unsupported websocket msg " + msg);
            }
        }
        final Object message = msg;
        Channel ch = chctx.channel();
        final AbstractConnection connection = (AbstractConnection)this.connectionMap.get(ch);
        if (connection != null) {
            connection.startRead();
            final DefaultContext context = this.getContext(connection);
            if (context.isOnCorrectWorker(ch.eventLoop())) {
                try {
                    this.vertx.setContext(context);
                    context.startExecute();
                    this.doMessageReceived(connection, chctx, message);
                }
                catch (Throwable t) {
                    context.reportException(t);
                }
                finally {
                    context.endExecute();
                }
            } else {
                context.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VertxHttpHandler.this.doMessageReceived(connection, chctx, message);
                        }
                        catch (Throwable t) {
                            context.reportException(t);
                        }
                    }
                });
            }
        } else {
            try {
                this.doMessageReceived(connection, chctx, message);
            }
            catch (Throwable t) {
                chctx.pipeline().fireExceptionCaught(t);
            }
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            ByteBuf buf = ((WebSocketFrame)msg).getBinaryData();
            if (buf != Unpooled.EMPTY_BUFFER) {
                buf = VertxHttpHandler.safeBuffer(buf);
            }
            switch (frame.getType()) {
                case BINARY: {
                    msg = new BinaryWebSocketFrame(buf);
                    break;
                }
                case TEXT: {
                    msg = new TextWebSocketFrame(buf);
                    break;
                }
                case CLOSE: {
                    msg = new CloseWebSocketFrame(true, 0, buf);
                    break;
                }
                case CONTINUATION: {
                    msg = new ContinuationWebSocketFrame(buf);
                    break;
                }
                case PONG: {
                    msg = new PongWebSocketFrame(buf);
                    break;
                }
                case PING: {
                    msg = new PingWebSocketFrame(buf);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported websocket msg " + msg);
                }
            }
        }
        ctx.write(msg, promise);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        AbstractConnection conn = (AbstractConnection)this.connectionMap.get(ctx.channel());
        if (conn != null) {
            conn.endReadAndFlush();
        }
    }

    protected abstract void doMessageReceived(C var1, ChannelHandlerContext var2, Object var3) throws Exception;
}

