/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.logging.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.JULLogDelegateFactory;
import org.vertx.java.core.logging.impl.LogDelegate;
import org.vertx.java.core.logging.impl.LogDelegateFactory;

public class LoggerFactory {
    public static final String LOGGER_DELEGATE_FACTORY_CLASS_NAME = "org.vertx.logger-delegate-factory-class-name";
    private static volatile LogDelegateFactory delegateFactory;
    private static final ConcurrentMap<String, Logger> loggers;

    public static synchronized void initialise() {
        LogDelegateFactory delegateFactory;
        String className = JULLogDelegateFactory.class.getName();
        try {
            className = System.getProperty(LOGGER_DELEGATE_FACTORY_CLASS_NAME);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (className != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clz = loader.loadClass(className);
                delegateFactory = (LogDelegateFactory)clz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error instantiating transformer class \"" + className + "\"", e);
            }
        } else {
            delegateFactory = new JULLogDelegateFactory();
        }
        LoggerFactory.delegateFactory = delegateFactory;
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getCanonicalName());
    }

    public static Logger getLogger(String name) {
        LogDelegate delegate;
        Logger oldLogger;
        Logger logger = (Logger)loggers.get(name);
        if (logger == null && (oldLogger = loggers.putIfAbsent(name, logger = new Logger(delegate = delegateFactory.createDelegate(name)))) != null) {
            logger = oldLogger;
        }
        return logger;
    }

    public static void removeLogger(String name) {
        loggers.remove(name);
    }

    static {
        loggers = new ConcurrentHashMap<String, Logger>();
        LoggerFactory.initialise();
    }
}

