/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.net.impl.DefaultNetSocket;
import org.vertx.java.core.net.impl.VertxHandler;

public class VertxNetHandler
extends VertxHandler<DefaultNetSocket> {
    public VertxNetHandler(VertxInternal vertx, Map<Channel, DefaultNetSocket> connectionMap) {
        super(vertx, connectionMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext chctx, Object msg) {
        if (msg instanceof ByteBuf) {
            msg = VertxNetHandler.safeBuffer((ByteBuf)msg);
        }
        final ByteBuf message = (ByteBuf)msg;
        final DefaultNetSocket sock = (DefaultNetSocket)this.connectionMap.get(chctx.channel());
        if (sock != null) {
            Channel ch = chctx.channel();
            final DefaultContext context = this.getContext(sock);
            if (context.isOnCorrectWorker(ch.eventLoop())) {
                try {
                    this.vertx.setContext(context);
                    context.startExecute();
                    try {
                        sock.handleDataReceived(new Buffer(message));
                    }
                    catch (Throwable t) {
                        context.reportException(t);
                    }
                }
                catch (Throwable t) {
                    context.reportException(t);
                }
                finally {
                    context.endExecute();
                }
            } else {
                context.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            sock.handleDataReceived(new Buffer(message));
                        }
                        catch (Throwable t) {
                            context.reportException(t);
                        }
                    }
                });
            }
        }
    }
}

