/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import io.netty.channel.EventLoop;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.vertx.java.core.Handler;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.net.impl.HandlerHolder;
import org.vertx.java.core.net.impl.VertxEventLoopGroup;

public class HandlerManager<T> {
    private static final Logger log = LoggerFactory.getLogger(HandlerManager.class);
    private final VertxEventLoopGroup availableWorkers;
    private final Map<EventLoop, Handlers<T>> handlerMap = new HashMap<EventLoop, Handlers<T>>();

    public HandlerManager(VertxEventLoopGroup availableWorkers) {
        this.availableWorkers = availableWorkers;
    }

    public synchronized boolean hasHandlers() {
        return !this.handlerMap.isEmpty();
    }

    public synchronized HandlerHolder<T> chooseHandler(EventLoop worker) {
        Handlers<T> handlers = this.handlerMap.get(worker);
        if (handlers == null) {
            return null;
        }
        return handlers.chooseHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(Handler<T> handler, DefaultContext context) {
        EventLoop worker = context.getEventLoop();
        this.availableWorkers.addWorker(worker);
        HandlerManager handlerManager = this;
        synchronized (handlerManager) {
            Handlers<T> handlers = this.handlerMap.get(worker);
            if (handlers == null) {
                handlers = new Handlers();
                this.handlerMap.put(worker, handlers);
            }
            handlers.addHandler(new HandlerHolder<T>(context, handler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(Handler<T> handler, DefaultContext context) {
        EventLoop worker = context.getEventLoop();
        HandlerManager handlerManager = this;
        synchronized (handlerManager) {
            Handlers<T> handlers = this.handlerMap.get(worker);
            if (!handlers.removeHandler(new HandlerHolder<T>(context, handler))) {
                throw new IllegalStateException("Can't find handler");
            }
            if (handlers.isEmpty()) {
                this.handlerMap.remove(worker);
            }
        }
        this.availableWorkers.removeWorker(worker);
    }

    private static class Handlers<T> {
        private int pos;
        private final List<HandlerHolder<T>> list = new ArrayList<HandlerHolder<T>>();

        private Handlers() {
        }

        HandlerHolder<T> chooseHandler() {
            HandlerHolder<T> handler = this.list.get(this.pos);
            ++this.pos;
            this.checkPos();
            return handler;
        }

        void addHandler(HandlerHolder<T> handler) {
            this.list.add(handler);
        }

        boolean removeHandler(HandlerHolder<T> handler) {
            if (this.list.remove(handler)) {
                this.checkPos();
                return true;
            }
            return false;
        }

        boolean isEmpty() {
            return this.list.isEmpty();
        }

        void checkPos() {
            if (this.pos == this.list.size()) {
                this.pos = 0;
            }
        }
    }
}

