/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketStream;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.http.impl.ClientConnection;
import io.vertx.core.http.impl.ConnectionLifeCycleListener;
import io.vertx.core.http.impl.ConnectionManager;
import io.vertx.core.http.impl.FrameType;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.http.impl.VertxHttpHandler;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.Closeable;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.core.metrics.spi.HttpClientMetrics;
import io.vertx.core.net.impl.KeyStoreHelper;
import io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import io.vertx.core.net.impl.SSLHelper;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.net.ssl.SSLHandshakeException;

public class HttpClientImpl
implements HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClientImpl.class);
    private final VertxInternal vertx;
    private final HttpClientOptions options;
    private final Map<Channel, ClientConnection> connectionMap = new ConcurrentHashMap<Channel, ClientConnection>();
    private final ContextImpl creatingContext;
    private final ConnectionManager pool;
    private final Closeable closeHook;
    private final SSLHelper sslHelper;
    private final HttpClientMetrics metrics;
    private volatile boolean closed;

    public HttpClientImpl(VertxInternal vertx, HttpClientOptions options) {
        this.vertx = vertx;
        this.options = new HttpClientOptions(options);
        this.sslHelper = new SSLHelper(options, KeyStoreHelper.create(vertx, options.getKeyStoreOptions()), KeyStoreHelper.create(vertx, options.getTrustStoreOptions()));
        this.creatingContext = vertx.getContext();
        this.closeHook = completionHandler -> {
            this.close();
            completionHandler.handle(Future.succeededFuture());
        };
        if (this.creatingContext != null) {
            if (this.creatingContext.isWorker()) {
                throw new IllegalStateException("Cannot use HttpClient in a worker verticle");
            }
            this.creatingContext.addCloseHook(this.closeHook);
        }
        this.pool = new ConnectionManager(options.getMaxPoolSize(), options.isKeepAlive(), options.isPipelining()){

            @Override
            protected void connect(String host, int port, Handler<ClientConnection> connectHandler, Handler<Throwable> connectErrorHandler, ContextImpl context, ConnectionLifeCycleListener listener) {
                HttpClientImpl.this.internalConnect(context, port, host, connectHandler, connectErrorHandler, listener);
            }
        };
        this.metrics = vertx.metricsSPI().createMetrics(this, options);
    }

    @Override
    public HttpClient connectWebsocket(int port, String host, String requestURI, Handler<WebSocket> wsConnect) {
        this.websocket(port, host, requestURI, null, null).handler((Handler)wsConnect);
        return this;
    }

    @Override
    public HttpClient connectWebsocket(int port, String host, String requestURI, MultiMap headers, Handler<WebSocket> wsConnect) {
        this.websocket(port, host, requestURI, headers, null).handler((Handler)wsConnect);
        return this;
    }

    @Override
    public HttpClient connectWebsocket(int port, String host, String requestURI, MultiMap headers, WebsocketVersion version, Handler<WebSocket> wsConnect) {
        this.websocket(port, host, requestURI, headers, version, null).handler((Handler)wsConnect);
        return this;
    }

    @Override
    public HttpClient connectWebsocket(int port, String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols, Handler<WebSocket> wsConnect) {
        this.websocket(port, host, requestURI, headers, version, subProtocols).handler((Handler)wsConnect);
        return this;
    }

    @Override
    public WebSocketStream websocket(int port, String host, String requestURI) {
        return this.websocket(port, host, requestURI, null, null);
    }

    @Override
    public WebSocketStream websocket(int port, String host, String requestURI, MultiMap headers) {
        return this.websocket(port, host, requestURI, headers, null);
    }

    @Override
    public WebSocketStream websocket(int port, String host, String requestURI, MultiMap headers, WebsocketVersion version) {
        return this.websocket(port, host, requestURI, headers, version, null);
    }

    @Override
    public WebSocketStream websocket(int port, String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols) {
        return new WebSocketStreamImpl(port, host, requestURI, headers, version, subProtocols);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, String absoluteURI, Handler<HttpClientResponse> responseHandler) {
        Objects.requireNonNull(responseHandler, "no null responseHandler accepted");
        return this.request(method, absoluteURI).handler((Handler)responseHandler);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, int port, String host, String requestURI, Handler<HttpClientResponse> responseHandler) {
        Objects.requireNonNull(responseHandler, "no null responseHandler accepted");
        return this.request(method, port, host, requestURI).handler((Handler)responseHandler);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, String absoluteURI) {
        URL url = this.parseUrl(absoluteURI);
        return this.doRequest(method, url.getHost(), url.getPort(), url.getPath(), null);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, int port, String host, String requestURI) {
        return this.doRequest(method, host, port, requestURI, null);
    }

    @Override
    public synchronized void close() {
        this.checkClosed();
        this.pool.close();
        for (ClientConnection conn : this.connectionMap.values()) {
            conn.close();
        }
        if (this.creatingContext != null) {
            this.creatingContext.removeCloseHook(this.closeHook);
        }
        this.closed = true;
        this.metrics.close();
    }

    @Override
    public String metricBaseName() {
        return this.metrics.baseName();
    }

    @Override
    public Map<String, JsonObject> metrics() {
        String name = this.metricBaseName();
        return this.vertx.metrics().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(name)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(name.length() + 1), Map.Entry::getValue));
    }

    HttpClientOptions getOptions() {
        return this.options;
    }

    void getConnection(int port, String host, Handler<ClientConnection> handler, Handler<Throwable> connectionExceptionHandler, ContextImpl context) {
        this.pool.getConnection(port, host, handler, connectionExceptionHandler, context);
    }

    VertxInternal getVertx() {
        return this.vertx;
    }

    SSLHelper getSslHelper() {
        return this.sslHelper;
    }

    void removeChannel(Channel channel) {
        this.connectionMap.remove(channel);
    }

    HttpClientMetrics httpClientMetrics() {
        return this.metrics;
    }

    private void applyConnectionOptions(Bootstrap bootstrap) {
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)this.options.isTcpNoDelay());
        if (this.options.getSendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.options.getSendBufferSize());
        }
        if (this.options.getReceiveBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.options.getReceiveBufferSize());
            bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(this.options.getReceiveBufferSize()));
        }
        bootstrap.option(ChannelOption.SO_LINGER, (Object)this.options.getSoLinger());
        if (this.options.getTrafficClass() != -1) {
            bootstrap.option(ChannelOption.IP_TOS, (Object)this.options.getTrafficClass());
        }
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.options.getConnectTimeout());
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)PartialPooledByteBufAllocator.INSTANCE);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)this.options.isTcpKeepAlive());
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)this.options.isReuseAddress());
    }

    private void internalConnect(final ContextImpl context, final int port, final String host, Handler<ClientConnection> connectHandler, Handler<Throwable> connectErrorHandler, ConnectionLifeCycleListener listener) {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)context.getEventLoop());
        bootstrap.channel(NioSocketChannel.class);
        this.sslHelper.validate(this.vertx);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                if (HttpClientImpl.this.options.isSsl()) {
                    pipeline.addLast("ssl", (ChannelHandler)HttpClientImpl.this.sslHelper.createSslHandler(HttpClientImpl.this.vertx, true, host, port));
                }
                pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec(4096, 8192, 8192, false, false));
                if (HttpClientImpl.this.options.isTryUseCompression()) {
                    pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor(true));
                }
                if (HttpClientImpl.this.options.getIdleTimeout() > 0) {
                    pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, HttpClientImpl.this.options.getIdleTimeout()));
                }
                pipeline.addLast("handler", (ChannelHandler)new ClientHandler(context));
            }
        });
        this.applyConnectionOptions(bootstrap);
        ChannelFuture future = bootstrap.connect((SocketAddress)new InetSocketAddress(host, port));
        future.addListener(channelFuture -> {
            Channel ch = channelFuture.channel();
            if (channelFuture.isSuccess()) {
                if (this.options.isSsl()) {
                    SslHandler sslHandler = (SslHandler)ch.pipeline().get(SslHandler.class);
                    io.netty.util.concurrent.Future fut = sslHandler.handshakeFuture();
                    fut.addListener(fut2 -> {
                        if (fut2.isSuccess()) {
                            this.connected(context, port, host, ch, connectHandler, connectErrorHandler, listener);
                        } else {
                            this.connectionFailed(context, ch, connectErrorHandler, new SSLHandshakeException("Failed to create SSL connection"), listener);
                        }
                    });
                } else {
                    this.connected(context, port, host, ch, connectHandler, connectErrorHandler, listener);
                }
            } else {
                this.connectionFailed(context, ch, connectErrorHandler, channelFuture.cause(), listener);
            }
        });
    }

    private URL parseUrl(String surl) {
        try {
            return new URL(surl);
        }
        catch (MalformedURLException e) {
            throw new VertxException("Invalid url: " + surl);
        }
    }

    private HttpClientRequest doRequest(HttpMethod method, String host, int port, String relativeURI, MultiMap headers) {
        Objects.requireNonNull(method, "no null method accepted");
        Objects.requireNonNull(host, "no null host accepted");
        Objects.requireNonNull(relativeURI, "no null relativeURI accepted");
        this.checkClosed();
        HttpClientRequestImpl req = new HttpClientRequestImpl(this, method, host, port, relativeURI, this.vertx);
        if (headers != null) {
            req.headers().setAll(headers);
        }
        return req;
    }

    private synchronized void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Client is closed");
        }
    }

    private void connected(ContextImpl context, int port, String host, Channel ch, Handler<ClientConnection> connectHandler, Handler<Throwable> exceptionHandler, ConnectionLifeCycleListener listener) {
        context.executeSync(() -> this.createConn(context, port, host, ch, connectHandler, exceptionHandler, listener));
    }

    private void createConn(ContextImpl context, int port, String host, Channel ch, Handler<ClientConnection> connectHandler, Handler<Throwable> exceptionHandler, ConnectionLifeCycleListener listener) {
        ClientConnection conn = new ClientConnection(this.vertx, this, exceptionHandler, ch, this.options.isSsl(), host, port, context, listener, this.metrics);
        conn.closeHandler(v -> listener.connectionClosed(conn));
        this.connectionMap.put(ch, conn);
        connectHandler.handle(conn);
    }

    private void connectionFailed(ContextImpl context, Channel ch, Handler<Throwable> connectionExceptionHandler, Throwable t, ConnectionLifeCycleListener listener) {
        Handler<Throwable> exHandler = connectionExceptionHandler == null ? log::error : connectionExceptionHandler;
        context.executeSync(() -> {
            listener.connectionClosed(null);
            try {
                ch.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (exHandler != null) {
                exHandler.handle(t);
            } else {
                log.error(t);
            }
        });
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private class ClientHandler
    extends VertxHttpHandler<ClientConnection> {
        private boolean closeFrameSent;
        private ContextImpl context;

        public ClientHandler(ContextImpl context) {
            super(HttpClientImpl.this.vertx, HttpClientImpl.this.connectionMap);
            this.context = context;
        }

        @Override
        protected ContextImpl getContext(ClientConnection connection) {
            return this.context;
        }

        @Override
        protected void doMessageReceived(ClientConnection conn, ChannelHandlerContext ctx, Object msg) {
            if (conn == null) {
                return;
            }
            boolean valid = false;
            if (msg instanceof HttpResponse) {
                HttpResponse response = (HttpResponse)msg;
                conn.handleResponse(response);
                valid = true;
            }
            if (msg instanceof HttpContent) {
                HttpContent chunk = (HttpContent)msg;
                if (chunk.content().isReadable()) {
                    Buffer buff = Buffer.buffer(chunk.content().slice());
                    conn.handleResponseChunk(buff);
                }
                if (chunk instanceof LastHttpContent) {
                    conn.handleResponseEnd((LastHttpContent)chunk);
                }
                valid = true;
            } else if (msg instanceof WebSocketFrameInternal) {
                WebSocketFrameInternal frame = (WebSocketFrameInternal)msg;
                switch (frame.type()) {
                    case BINARY: 
                    case CONTINUATION: 
                    case TEXT: {
                        conn.handleWsFrame(frame);
                        break;
                    }
                    case PING: {
                        ctx.writeAndFlush((Object)new WebSocketFrameImpl(FrameType.PONG, frame.getBinaryData()));
                        break;
                    }
                    case CLOSE: {
                        if (this.closeFrameSent) break;
                        ctx.writeAndFlush((Object)frame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        this.closeFrameSent = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid type: " + (Object)((Object)frame.type()));
                    }
                }
                valid = true;
            }
            if (!valid) {
                throw new IllegalStateException("Invalid object " + msg);
            }
        }
    }

    private class WebSocketStreamImpl
    implements WebSocketStream {
        final int port;
        final String host;
        final String requestURI;
        final MultiMap headers;
        final WebsocketVersion version;
        final String subProtocols;
        private Handler<WebSocket> handler;
        private Handler<Throwable> exceptionHandler;
        private Handler<Void> endHandler;

        public WebSocketStreamImpl(int port, String host, String requestURI, MultiMap headers, WebsocketVersion version, String subProtocols) {
            this.port = port;
            this.host = host;
            this.requestURI = requestURI;
            this.headers = headers;
            this.version = version;
            this.subProtocols = subProtocols;
        }

        @Override
        public synchronized WebSocketStream exceptionHandler(Handler<Throwable> handler) {
            this.exceptionHandler = handler;
            return this;
        }

        @Override
        public synchronized WebSocketStream handler(Handler<WebSocket> handler) {
            if (this.handler == null && handler != null) {
                Handler<WebSocket> wsConnect;
                this.handler = handler;
                HttpClientImpl.this.checkClosed();
                ContextImpl context = HttpClientImpl.this.vertx.getOrCreateContext();
                Handler<Throwable> connectionExceptionHandler = this.exceptionHandler;
                if (connectionExceptionHandler == null) {
                    connectionExceptionHandler = log::error;
                }
                if (this.endHandler != null) {
                    Handler<Void> endCallback = this.endHandler;
                    wsConnect = ws -> {
                        handler.handle((WebSocket)ws);
                        endCallback.handle(null);
                    };
                } else {
                    wsConnect = handler;
                }
                HttpClientImpl.this.getConnection(this.port, this.host, conn -> {
                    if (!conn.isClosed()) {
                        conn.toWebSocket(this.requestURI, this.headers, this.version, this.subProtocols, HttpClientImpl.this.options.getMaxWebsocketFrameSize(), wsConnect);
                    } else {
                        HttpClientImpl.this.connectWebsocket(this.port, this.host, this.requestURI, this.headers, this.version, this.subProtocols, wsConnect);
                    }
                }, connectionExceptionHandler, context);
            }
            return this;
        }

        @Override
        public synchronized WebSocketStream endHandler(Handler<Void> endHandler) {
            this.endHandler = endHandler;
            return this;
        }

        @Override
        public WebSocketStream pause() {
            return this;
        }

        @Override
        public WebSocketStream resume() {
            return this;
        }
    }
}

