/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.ResourceLeakDetector;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.TimeoutStream;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.datagram.impl.DatagramSocketImpl;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.dns.impl.DnsClientImpl;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.impl.FileSystemImpl;
import io.vertx.core.file.impl.WindowsFileSystem;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.impl.BlockedThreadChecker;
import io.vertx.core.impl.Closeable;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.DeploymentManager;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.FileResolver;
import io.vertx.core.impl.HAManager;
import io.vertx.core.impl.MultiThreadedWorkerContext;
import io.vertx.core.impl.OrderedExecutorFactory;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.VertxThreadFactory;
import io.vertx.core.impl.Windows;
import io.vertx.core.impl.WorkerContext;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.core.metrics.impl.DummyVertxMetrics;
import io.vertx.core.metrics.spi.VertxMetrics;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.impl.NetClientImpl;
import io.vertx.core.net.impl.NetServerImpl;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.shareddata.SharedData;
import io.vertx.core.shareddata.impl.SharedDataImpl;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.cluster.Action;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.ClusterManager;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class VertxImpl
implements VertxInternal {
    private static final Logger log = LoggerFactory.getLogger(VertxImpl.class);
    private final FileSystem fileSystem = this.getFileSystem();
    private final SharedData sharedData;
    private final VertxMetrics metrics;
    private final ConcurrentMap<Long, InternalTimerHandler> timeouts = new ConcurrentHashMap<Long, InternalTimerHandler>();
    private final AtomicLong timeoutCounter = new AtomicLong(0L);
    private final ClusterManager clusterManager;
    private final DeploymentManager deploymentManager;
    private final FileResolver fileResolver;
    private final Map<ServerID, HttpServerImpl> sharedHttpServers = new HashMap<ServerID, HttpServerImpl>();
    private final Map<ServerID, NetServerImpl> sharedNetServers = new HashMap<ServerID, NetServerImpl>();
    private final ExecutorService workerPool;
    private final ExecutorService internalBlockingPool;
    private final OrderedExecutorFactory workerOrderedFact;
    private final OrderedExecutorFactory internalOrderedFact;
    private final EventLoopGroup eventLoopGroup;
    private final BlockedThreadChecker checker;
    private final boolean haEnabled;
    private EventBusImpl eventBus;
    private HAManager haManager;
    private boolean closed;

    VertxImpl() {
        this(new VertxOptions());
    }

    VertxImpl(VertxOptions options) {
        this(options, null);
    }

    VertxImpl(VertxOptions options, Handler<AsyncResult<Vertx>> resultHandler) {
        this.checker = new BlockedThreadChecker(options.getBlockedThreadCheckPeriod(), options.getMaxEventLoopExecuteTime(), options.getMaxWorkerExecuteTime());
        this.eventLoopGroup = new NioEventLoopGroup(options.getEventLoopPoolSize(), (ThreadFactory)new VertxThreadFactory("vert.x-eventloop-thread-", this.checker, false));
        this.workerPool = Executors.newFixedThreadPool(options.getWorkerPoolSize(), new VertxThreadFactory("vert.x-worker-thread-", this.checker, true));
        this.internalBlockingPool = Executors.newFixedThreadPool(options.getInternalBlockingPoolSize(), new VertxThreadFactory("vert.x-internal-blocking-", this.checker, true));
        this.workerOrderedFact = new OrderedExecutorFactory(this.workerPool);
        this.internalOrderedFact = new OrderedExecutorFactory(this.internalBlockingPool);
        this.fileResolver = new FileResolver(this);
        this.deploymentManager = new DeploymentManager(this);
        this.metrics = this.initialiseMetrics(options);
        boolean bl = this.haEnabled = options.isClustered() && options.isHAEnabled();
        if (options.isClustered()) {
            this.clusterManager = this.getClusterManager(options);
            this.clusterManager.setVertx(this);
            this.clusterManager.join(ar -> {
                if (ar.failed()) {
                    log.error("Failed to join cluster", ar.cause());
                }
                if (options.isHAEnabled()) {
                    VertxImpl vertxImpl = this;
                    synchronized (vertxImpl) {
                        this.haManager = new HAManager(this, this.deploymentManager, this.clusterManager, options.getQuorumSize(), options.getHAGroup());
                    }
                }
                this.clusterManager.getAsyncMultiMap("subs", ar2 -> {
                    if (ar2.succeeded()) {
                        AsyncMultiMap subs = (AsyncMultiMap)ar2.result();
                        NetServer server = this.createNetServer(new NetServerOptions().setPort(options.getClusterPort()).setHost(options.getClusterHost()));
                        EventBusImpl.EventBusNetServer ebServer = new EventBusImpl.EventBusNetServer(server);
                        server.listen(asyncResult2 -> {
                            if (asyncResult2.succeeded()) {
                                int publicPort = Integer.getInteger("vertx.cluster.public.port", -1);
                                String publicHost = System.getProperty("vertx.cluster.public.host", null);
                                int serverPort = publicPort == -1 ? server.actualPort() : publicPort;
                                String serverHost = publicHost == null ? options.getClusterHost() : publicHost;
                                ServerID serverID = new ServerID(serverPort, serverHost);
                                VertxImpl vertxImpl = this;
                                synchronized (vertxImpl) {
                                    this.eventBus = new EventBusImpl(this, options.getClusterPingInterval(), options.getClusterPingReplyInterval(), this.clusterManager, subs, serverID, ebServer);
                                }
                                if (resultHandler != null) {
                                    resultHandler.handle(Future.succeededFuture(this));
                                }
                            } else if (resultHandler != null) {
                                resultHandler.handle(Future.failedFuture(ar.cause()));
                            } else {
                                log.error(ar.cause());
                            }
                        });
                    } else if (resultHandler != null) {
                        resultHandler.handle(Future.failedFuture(ar.cause()));
                    } else {
                        log.error(ar.cause());
                    }
                });
            });
            this.sharedData = new SharedDataImpl(this, this.clusterManager);
        } else {
            this.clusterManager = null;
            this.sharedData = new SharedDataImpl(this, null);
            this.eventBus = new EventBusImpl(this);
            if (resultHandler != null) {
                resultHandler.handle(Future.succeededFuture(this));
            }
        }
    }

    protected FileSystem getFileSystem() {
        return Windows.isWindows() ? new WindowsFileSystem(this) : new FileSystemImpl(this);
    }

    @Override
    public DatagramSocket createDatagramSocket(DatagramSocketOptions options) {
        return new DatagramSocketImpl(this, options);
    }

    @Override
    public NetServer createNetServer(NetServerOptions options) {
        return new NetServerImpl(this, options);
    }

    @Override
    public NetClient createNetClient(NetClientOptions options) {
        return new NetClientImpl(this, options);
    }

    @Override
    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    @Override
    public SharedData sharedData() {
        return this.sharedData;
    }

    @Override
    public HttpServer createHttpServer(HttpServerOptions serverOptions) {
        return new HttpServerImpl(this, serverOptions);
    }

    @Override
    public HttpClient createHttpClient(HttpClientOptions options) {
        return new HttpClientImpl(this, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventBus eventBus() {
        if (this.eventBus == null) {
            VertxImpl vertxImpl = this;
            synchronized (vertxImpl) {
                return this.eventBus;
            }
        }
        return this.eventBus;
    }

    @Override
    public long setPeriodic(long delay, Handler<Long> handler) {
        return this.scheduleTimeout(this.getOrCreateContext(), handler, delay, true);
    }

    @Override
    public TimeoutStream periodicStream(long delay) {
        return new TimeoutStreamImpl(delay, true);
    }

    @Override
    public long setTimer(long delay, Handler<Long> handler) {
        return this.scheduleTimeout(this.getOrCreateContext(), handler, delay, false);
    }

    @Override
    public TimeoutStream timerStream(long delay) {
        return new TimeoutStreamImpl(delay, false);
    }

    @Override
    public void runOnContext(Handler<Void> task) {
        ContextImpl context = this.getOrCreateContext();
        context.runOnContext(task);
    }

    @Override
    public ExecutorService getWorkerPool() {
        return this.workerPool;
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public ContextImpl getOrCreateContext() {
        ContextImpl ctx = this.getContext();
        if (ctx == null) {
            ctx = this.createEventLoopContext(null, new JsonObject(), Thread.currentThread().getContextClassLoader());
        }
        return ctx;
    }

    @Override
    public Map<ServerID, HttpServerImpl> sharedHttpServers() {
        return this.sharedHttpServers;
    }

    @Override
    public Map<ServerID, NetServerImpl> sharedNetServers() {
        return this.sharedNetServers;
    }

    @Override
    public String metricBaseName() {
        return this.metrics.baseName();
    }

    @Override
    public Map<String, JsonObject> metrics() {
        String name = this.metricBaseName();
        return this.metrics.metrics().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(name)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public boolean cancelTimer(long id) {
        InternalTimerHandler handler = (InternalTimerHandler)this.timeouts.remove(id);
        if (handler != null) {
            handler.context.removeCloseHook(handler);
            return handler.cancel();
        }
        return false;
    }

    @Override
    public EventLoopContext createEventLoopContext(String deploymentID, JsonObject config, ClassLoader tccl) {
        return new EventLoopContext(this, this.workerOrderedFact.getExecutor(), deploymentID, config, tccl);
    }

    @Override
    public DnsClient createDnsClient(int port, String host) {
        return new DnsClientImpl(this, port, host);
    }

    private VertxMetrics initialiseMetrics(VertxOptions options) {
        if (options.isMetricsEnabled()) {
            ServiceLoader<VertxMetricsFactory> factories = ServiceLoader.load(VertxMetricsFactory.class);
            if (factories.iterator().hasNext()) {
                VertxMetricsFactory factory = factories.iterator().next();
                return factory.metrics(this, options);
            }
            log.warn("Metrics has been set to enabled but no VertxMetricsFactory found on classpath");
            return new DummyVertxMetrics();
        }
        return new DummyVertxMetrics();
    }

    private ClusterManager getClusterManager(VertxOptions options) {
        if (options.isClustered()) {
            ClusterManager mgr;
            if (options.getClusterManager() != null) {
                return options.getClusterManager();
            }
            String clusterManagerClassName = System.getProperty("vertx.cluster.managerClass");
            if (clusterManagerClassName != null) {
                try {
                    Class<?> clazz = Class.forName(clusterManagerClassName);
                    mgr = (ClusterManager)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to instantiate " + clusterManagerClassName, e);
                }
            } else {
                ServiceLoader<ClusterManager> mgrs = ServiceLoader.load(ClusterManager.class);
                if (!mgrs.iterator().hasNext()) {
                    throw new IllegalStateException("No ClusterManagerFactory instances found on classpath");
                }
                mgr = mgrs.iterator().next();
            }
            return mgr;
        }
        return null;
    }

    private long scheduleTimeout(ContextImpl context, Handler<Long> handler, long delay, boolean periodic) {
        if (delay < 1L) {
            throw new IllegalArgumentException("Cannot schedule a timer with delay < 1 ms");
        }
        long timerId = this.timeoutCounter.getAndIncrement();
        InternalTimerHandler task = new InternalTimerHandler(timerId, handler, periodic, delay, context);
        this.timeouts.put(timerId, task);
        context.addCloseHook(task);
        return timerId;
    }

    @Override
    public ContextImpl createWorkerContext(boolean multiThreaded, String deploymentID, JsonObject config, ClassLoader tccl) {
        if (multiThreaded) {
            return new MultiThreadedWorkerContext(this, this.internalOrderedFact.getExecutor(), this.workerPool, deploymentID, config, tccl);
        }
        return new WorkerContext(this, this.internalOrderedFact.getExecutor(), this.workerOrderedFact.getExecutor(), deploymentID, config, tccl);
    }

    public static Context context() {
        Thread current = Thread.currentThread();
        if (current instanceof VertxThread) {
            return ((VertxThread)current).getContext();
        }
        return null;
    }

    @Override
    public ContextImpl getContext() {
        return (ContextImpl)VertxImpl.context();
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public synchronized void close(Handler<AsyncResult<Void>> completionHandler) {
        if (this.closed || this.eventBus == null) {
            this.runOnContext(v -> completionHandler.handle(Future.succeededFuture()));
        }
        this.closed = true;
        this.deploymentManager.undeployAll(ar -> {
            if (this.haManager() != null) {
                this.haManager().stop();
            }
            this.eventBus.close(ar2 -> {
                for (HttpServer httpServer : new HashSet<HttpServerImpl>(this.sharedHttpServers.values())) {
                    httpServer.close();
                }
                this.sharedHttpServers.clear();
                for (NetServer netServer : new HashSet<NetServerImpl>(this.sharedNetServers.values())) {
                    netServer.close();
                }
                this.sharedNetServers.clear();
                this.fileResolver.deleteCacheDir(res -> {
                    this.workerPool.shutdownNow();
                    this.internalBlockingPool.shutdownNow();
                    this.eventLoopGroup.shutdownNow();
                    if (this.metrics != null) {
                        this.metrics.close();
                    }
                    this.checker.close();
                    ContextImpl.setContext(null);
                    if (completionHandler != null) {
                        completionHandler.handle(Future.succeededFuture());
                    }
                });
            });
        });
    }

    @Override
    public void deployVerticle(Verticle verticle) {
        this.deployVerticle(verticle, new DeploymentOptions(), null);
    }

    @Override
    public void deployVerticle(Verticle verticle, Handler<AsyncResult<String>> completionHandler) {
        this.deployVerticle(verticle, new DeploymentOptions(), completionHandler);
    }

    @Override
    public void deployVerticle(String identifier, Handler<AsyncResult<String>> completionHandler) {
        this.deployVerticle(identifier, new DeploymentOptions(), completionHandler);
    }

    @Override
    public void deployVerticle(Verticle verticle, DeploymentOptions options) {
        this.deployVerticle(verticle, options, null);
    }

    @Override
    public void deployVerticle(Verticle verticle, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        this.deploymentManager.deployVerticle(verticle, options, completionHandler);
    }

    @Override
    public void deployVerticle(String identifier) {
        this.deployVerticle(identifier, new DeploymentOptions(), null);
    }

    @Override
    public void deployVerticle(String identifier, DeploymentOptions options) {
        this.deployVerticle(identifier, options, null);
    }

    @Override
    public void deployVerticle(String identifier, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        if (options.isHa() && this.haManager() != null) {
            this.haManager().deployVerticle(identifier, options, completionHandler);
        } else {
            this.deploymentManager.deployVerticle(identifier, options, completionHandler);
        }
    }

    @Override
    public String getNodeID() {
        return this.clusterManager.getNodeID();
    }

    @Override
    public void undeployVerticle(String deploymentID) {
        this.undeployVerticle(deploymentID, res -> {});
    }

    @Override
    public void undeployVerticle(String deploymentID, Handler<AsyncResult<Void>> completionHandler) {
        if (this.haManager() != null) {
            this.haManager().removeFromHA(deploymentID);
        }
        this.deploymentManager.undeployVerticle(deploymentID, completionHandler);
    }

    @Override
    public Set<String> deployments() {
        return this.deploymentManager.deployments();
    }

    @Override
    public void registerVerticleFactory(VerticleFactory factory) {
        this.deploymentManager.registerVerticleFactory(factory);
    }

    @Override
    public void unregisterVerticleFactory(VerticleFactory factory) {
        this.deploymentManager.unregisterVerticleFactory(factory);
    }

    @Override
    public Set<VerticleFactory> verticleFactories() {
        return this.deploymentManager.verticleFactories();
    }

    @Override
    public <T> void executeBlocking(Action<T> action, Handler<AsyncResult<T>> resultHandler) {
        ContextImpl context = this.getOrCreateContext();
        context.executeBlocking(action, resultHandler);
    }

    @Override
    public <T> void executeBlocking(Handler<Future<T>> blockingCodeHandler, Handler<AsyncResult<T>> asyncResultHandler) {
        ContextImpl context = this.getOrCreateContext();
        context.executeBlocking(blockingCodeHandler, asyncResultHandler);
    }

    @Override
    public void simulateKill() {
        if (this.haManager() != null) {
            this.haManager().simulateKill();
        }
    }

    @Override
    public void simulateEventBusUnresponsive() {
        this.eventBus.simulateUnresponsive();
    }

    @Override
    public Deployment getDeployment(String deploymentID) {
        return this.deploymentManager.getDeployment(deploymentID);
    }

    @Override
    public void failoverCompleteHandler(Handler<Boolean> failoverCompleteHandler) {
        if (this.haManager() != null) {
            this.haManager().failoverCompleteHandler(failoverCompleteHandler);
        }
    }

    @Override
    public boolean isKilled() {
        return this.haManager().isKilled();
    }

    @Override
    public void failDuringFailover(boolean fail) {
        if (this.haManager() != null) {
            this.haManager().failDuringFailover(fail);
        }
    }

    @Override
    public VertxMetrics metricsSPI() {
        return this.metrics;
    }

    @Override
    public File resolveFile(String fileName) {
        return this.fileResolver.resolveFile(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HAManager haManager() {
        if (this.haManager == null && this.haEnabled) {
            VertxImpl vertxImpl = this;
            synchronized (vertxImpl) {
                return this.haManager;
            }
        }
        return this.haManager;
    }

    static {
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        System.setProperty("io.netty.noJdkZlibDecoder", "false");
    }

    private class TimeoutStreamImpl
    implements TimeoutStream,
    Handler<Long> {
        private final long delay;
        private final boolean periodic;
        private boolean paused;
        private Long id;
        private Handler<Long> handler;
        private Handler<Void> endHandler;

        public TimeoutStreamImpl(long delay, boolean periodic) {
            this.delay = delay;
            this.periodic = periodic;
        }

        @Override
        public synchronized void handle(Long event) {
            try {
                if (!this.paused) {
                    this.handler.handle(event);
                }
            }
            finally {
                if (!this.periodic && this.endHandler != null) {
                    this.endHandler.handle(null);
                }
            }
        }

        @Override
        public TimeoutStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }

        @Override
        public void cancel() {
            this.handler((Handler)null);
        }

        @Override
        public synchronized TimeoutStream handler(Handler<Long> handler) {
            if (handler != null) {
                if (this.id != null) {
                    throw new IllegalStateException();
                }
                this.handler = handler;
                this.id = VertxImpl.this.scheduleTimeout(VertxImpl.this.getOrCreateContext(), this, this.delay, this.periodic);
            } else if (this.id != null) {
                VertxImpl.this.cancelTimer(this.id);
                if (this.endHandler != null) {
                    VertxImpl.this.runOnContext(this.endHandler);
                }
            }
            return this;
        }

        @Override
        public synchronized TimeoutStream pause() {
            this.paused = true;
            return this;
        }

        @Override
        public synchronized TimeoutStream resume() {
            this.paused = false;
            return null;
        }

        @Override
        public synchronized TimeoutStream endHandler(Handler<Void> endHandler) {
            this.endHandler = endHandler;
            return this;
        }
    }

    private class InternalTimerHandler
    implements Handler<Void>,
    Closeable {
        final Handler<Long> handler;
        final boolean periodic;
        final long timerID;
        final ContextImpl context;
        final java.util.concurrent.Future<?> future;

        boolean cancel() {
            VertxImpl.this.metrics.timerEnded(this.timerID, true);
            return this.future.cancel(false);
        }

        InternalTimerHandler(long timerID, Handler<Long> runnable, boolean periodic, long delay, ContextImpl context) {
            this.context = context;
            this.timerID = timerID;
            this.handler = runnable;
            this.periodic = periodic;
            EventLoop el = context.getEventLoop();
            Runnable toRun = () -> context.runOnContext(this);
            this.future = periodic ? el.scheduleAtFixedRate(toRun, delay, delay, TimeUnit.MILLISECONDS) : el.schedule(toRun, delay, TimeUnit.MILLISECONDS);
            VertxImpl.this.metrics.timerCreated(timerID);
        }

        @Override
        public void handle(Void v) {
            try {
                this.handler.handle(this.timerID);
            }
            finally {
                if (!this.periodic) {
                    this.cleanupNonPeriodic();
                }
            }
        }

        private void cleanupNonPeriodic() {
            VertxImpl.this.timeouts.remove(this.timerID);
            VertxImpl.this.metrics.timerEnded(this.timerID, false);
            ContextImpl context = VertxImpl.this.getContext();
            context.removeCloseHook(this);
        }

        @Override
        public void close(Handler<AsyncResult<Void>> completionHandler) {
            VertxImpl.this.timeouts.remove(this.timerID);
            this.cancel();
            completionHandler.handle(Future.succeededFuture());
        }
    }
}

