/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.impl.BlockedThreadChecker;
import io.vertx.core.impl.VertxThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class VertxThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final BlockedThreadChecker checker;
    private final boolean worker;

    VertxThreadFactory(String prefix, BlockedThreadChecker checker, boolean worker) {
        this.prefix = prefix;
        this.checker = checker;
        this.worker = worker;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        VertxThread t = new VertxThread(runnable, this.prefix + this.threadCount.getAndIncrement(), this.worker);
        if (this.checker != null) {
            this.checker.registerThread(t);
        }
        return t;
    }
}

