/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.Options;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyStoreOptions;

@Options
public class KeyCertOptions
implements KeyStoreOptions,
Cloneable {
    private String keyPath;
    private Buffer keyValue;
    private String certPath;
    private Buffer certValue;

    public KeyCertOptions() {
    }

    public KeyCertOptions(KeyCertOptions other) {
        this.keyPath = other.getKeyPath();
        this.keyValue = other.getKeyValue();
        this.certPath = other.getCertPath();
        this.certValue = other.getCertValue();
    }

    public KeyCertOptions(JsonObject json) {
        this.keyPath = json.getString("keyPath");
        byte[] keyValue = json.getBinary("keyValue");
        this.keyValue = keyValue != null ? Buffer.buffer(keyValue) : null;
        this.certPath = json.getString("certPath");
        byte[] certValue = json.getBinary("certValue");
        this.certValue = certValue != null ? Buffer.buffer(certValue) : null;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    public KeyCertOptions setKeyPath(String keyPath) {
        this.keyPath = keyPath;
        return this;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public Buffer getKeyValue() {
        return this.keyValue;
    }

    public KeyCertOptions setKeyValue(Buffer keyValue) {
        this.keyValue = keyValue;
        return this;
    }

    public KeyCertOptions setCertPath(String certPath) {
        this.certPath = certPath;
        return this;
    }

    public Buffer getCertValue() {
        return this.certValue;
    }

    public KeyCertOptions setCertValue(Buffer certValue) {
        this.certValue = certValue;
        return this;
    }

    @Override
    public KeyCertOptions clone() {
        return new KeyCertOptions(this);
    }
}

