/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.Options;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.KeyStoreOptions;
import io.vertx.core.net.TrustStoreOptions;

@Options
public class NetClientOptions
extends ClientOptionsBase {
    public static final int DEFAULT_RECONNECT_ATTEMPTS = 0;
    public static final long DEFAULT_RECONNECT_INTERVAL = 1000L;
    private int reconnectAttempts;
    private long reconnectInterval;

    public NetClientOptions(NetClientOptions other) {
        super(other);
        this.reconnectAttempts = other.getReconnectAttempts();
        this.reconnectInterval = other.getReconnectInterval();
    }

    public NetClientOptions(JsonObject json) {
        super(json);
        this.reconnectAttempts = json.getInteger("reconnectAttempts", 0);
        this.reconnectInterval = json.getLong("reconnectInterval", 1000L);
    }

    public NetClientOptions() {
        this.reconnectAttempts = 0;
        this.reconnectInterval = 1000L;
    }

    @Override
    public NetClientOptions setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    @Override
    public NetClientOptions setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    @Override
    public NetClientOptions setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    @Override
    public NetClientOptions setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public NetClientOptions setTcpNoDelay(boolean tcpNoDelay) {
        super.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public NetClientOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        super.setTcpKeepAlive(tcpKeepAlive);
        return this;
    }

    @Override
    public NetClientOptions setSoLinger(int soLinger) {
        super.setSoLinger(soLinger);
        return this;
    }

    @Override
    public NetClientOptions setUsePooledBuffers(boolean usePooledBuffers) {
        super.setUsePooledBuffers(usePooledBuffers);
        return this;
    }

    @Override
    public NetClientOptions setIdleTimeout(int idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        return this;
    }

    @Override
    public NetClientOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    @Override
    public NetClientOptions setKeyStoreOptions(KeyStoreOptions keyStore) {
        super.setKeyStoreOptions(keyStore);
        return this;
    }

    @Override
    public NetClientOptions setTrustStoreOptions(TrustStoreOptions trustStore) {
        super.setTrustStoreOptions(trustStore);
        return this;
    }

    @Override
    public NetClientOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    @Override
    public NetClientOptions setTrustAll(boolean trustAll) {
        super.setTrustAll(trustAll);
        return this;
    }

    @Override
    public NetClientOptions setConnectTimeout(int connectTimeout) {
        super.setConnectTimeout(connectTimeout);
        return this;
    }

    public NetClientOptions setReconnectAttempts(int attempts) {
        if (attempts < -1) {
            throw new IllegalArgumentException("reconnect attempts must be >= -1");
        }
        this.reconnectAttempts = attempts;
        return this;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public NetClientOptions setReconnectInterval(long interval) {
        if (interval < 1L) {
            throw new IllegalArgumentException("reconnect interval nust be >= 1");
        }
        this.reconnectInterval = interval;
        return this;
    }

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetClientOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetClientOptions that = (NetClientOptions)o;
        if (this.reconnectAttempts != that.reconnectAttempts) {
            return false;
        }
        return this.reconnectInterval == that.reconnectInterval;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.reconnectAttempts;
        result = 31 * result + (int)(this.reconnectInterval ^ this.reconnectInterval >>> 32);
        return result;
    }
}

