/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.dns.DnsException;
import io.vertx.core.dns.DnsResponseCode;
import io.vertx.core.dns.MxRecord;
import io.vertx.core.dns.SrvRecord;
import io.vertx.core.dns.impl.MxRecordComparator;
import io.vertx.core.dns.impl.MxRecordImpl;
import io.vertx.core.dns.impl.SrcRecordImpl;
import io.vertx.core.dns.impl.SrvRecordComparator;
import io.vertx.core.dns.impl.netty.DnsQuery;
import io.vertx.core.dns.impl.netty.DnsQueryEncoder;
import io.vertx.core.dns.impl.netty.DnsQuestion;
import io.vertx.core.dns.impl.netty.DnsResource;
import io.vertx.core.dns.impl.netty.DnsResponse;
import io.vertx.core.dns.impl.netty.DnsResponseDecoder;
import io.vertx.core.dns.impl.netty.DnsResponseHeader;
import io.vertx.core.dns.impl.netty.decoder.RecordDecoderFactory;
import io.vertx.core.dns.impl.netty.decoder.record.MailExchangerRecord;
import io.vertx.core.dns.impl.netty.decoder.record.ServiceRecord;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

public final class DnsClientImpl
implements DnsClient {
    private static final char[] HEX_TABLE = "0123456789abcdef".toCharArray();
    private final Bootstrap bootstrap;
    private final InetSocketAddress dnsServer;
    private final ContextImpl actualCtx;

    public DnsClientImpl(VertxInternal vertx, int port, String host) {
        ContextImpl creatingContext = vertx.getContext();
        if (creatingContext != null && creatingContext.isMultiThreaded()) {
            throw new IllegalStateException("Cannot use DnsClient in a multi-threaded worker verticle");
        }
        this.dnsServer = new InetSocketAddress(host, port);
        this.actualCtx = vertx.getOrCreateContext();
        this.bootstrap = new Bootstrap();
        this.bootstrap.group((EventLoopGroup)this.actualCtx.getEventLoop());
        this.bootstrap.channel(NioDatagramChannel.class);
        this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)PartialPooledByteBufAllocator.INSTANCE);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

            protected void initChannel(DatagramChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new DnsQueryEncoder()});
                pipeline.addLast(new ChannelHandler[]{new DnsResponseDecoder()});
            }
        });
    }

    @Override
    public DnsClient lookup4(String name, Handler<AsyncResult<String>> handler) {
        this.lookup(name, new HandlerAdapter(handler), 1);
        return this;
    }

    @Override
    public DnsClient lookup6(String name, Handler<AsyncResult<String>> handler) {
        this.lookup(name, new HandlerAdapter(handler), 28);
        return this;
    }

    @Override
    public DnsClient lookup(String name, Handler<AsyncResult<String>> handler) {
        this.lookup(name, new HandlerAdapter(handler), 1, 28);
        return this;
    }

    @Override
    public DnsClient resolveA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.lookup(name, handler, 1);
        return this;
    }

    @Override
    public DnsClient resolveCNAME(String name, Handler<AsyncResult<List<String>>> handler) {
        this.lookup(name, handler, 5);
        return this;
    }

    @Override
    public DnsClient resolveMX(String name, Handler<AsyncResult<List<MxRecord>>> handler) {
        this.lookup(name, new ConvertingHandler<MailExchangerRecord, MxRecord>(handler, MxRecordComparator.INSTANCE){

            @Override
            protected MxRecord convert(MailExchangerRecord entry) {
                return new MxRecordImpl(entry);
            }
        }, 15);
        return this;
    }

    @Override
    public DnsClient resolveTXT(String name, final Handler<AsyncResult<List<String>>> handler) {
        this.lookup(name, new Handler<AsyncResult>(){

            @Override
            public void handle(AsyncResult event) {
                if (event.failed()) {
                    handler.handle(event);
                } else {
                    ArrayList txts = new ArrayList();
                    List records = (List)event.result();
                    for (List txt : records) {
                        txts.addAll(txt);
                    }
                    handler.handle(Future.succeededFuture(txts));
                }
            }
        }, 16);
        return this;
    }

    @Override
    public DnsClient resolvePTR(String name, Handler<AsyncResult<String>> handler) {
        this.lookup(name, new HandlerAdapter(handler), 12);
        return this;
    }

    @Override
    public DnsClient resolveAAAA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.lookup(name, handler, 28);
        return this;
    }

    @Override
    public DnsClient resolveNS(String name, Handler<AsyncResult<List<String>>> handler) {
        this.lookup(name, handler, 2);
        return this;
    }

    @Override
    public DnsClient resolveSRV(String name, Handler<AsyncResult<List<SrvRecord>>> handler) {
        this.lookup(name, new ConvertingHandler<ServiceRecord, SrvRecord>(handler, SrvRecordComparator.INSTANCE){

            @Override
            protected SrvRecord convert(ServiceRecord entry) {
                return new SrcRecordImpl(entry);
            }
        }, 33);
        return this;
    }

    @Override
    public DnsClient reverseLookup(String address, Handler<AsyncResult<String>> handler) {
        try {
            InetAddress inetAddress = InetAddress.getByName(address);
            byte[] addr = inetAddress.getAddress();
            StringBuilder reverseName = new StringBuilder(64);
            if (inetAddress instanceof Inet4Address) {
                reverseName.append(addr[3] & 0xFF).append(".").append(addr[2] & 0xFF).append(".").append(addr[1] & 0xFF).append(".").append(addr[0] & 0xFF);
            } else {
                for (int i = 0; i < 16; ++i) {
                    reverseName.append(HEX_TABLE[addr[15 - i] & 0xF]);
                    reverseName.append(".");
                    reverseName.append(HEX_TABLE[addr[15 - i] >> 4 & 0xF]);
                    if (i == 15) continue;
                    reverseName.append(".");
                }
            }
            reverseName.append(".in-addr.arpa");
            return this.resolvePTR(reverseName.toString(), ar -> {
                if (ar.failed()) {
                    handler.handle(Future.failedFuture(ar.cause()));
                } else {
                    String result = (String)ar.result();
                    handler.handle(Future.succeededFuture(result));
                }
            });
        }
        catch (UnknownHostException e) {
            this.actualCtx.runOnContext(v -> handler.handle(Future.failedFuture(e)));
            return this;
        }
    }

    private void lookup(String name, Handler handler, int ... types) {
        Future result = Future.future();
        result.setHandler(handler);
        this.lookup(name, result, types);
    }

    private void lookup(final String name, final Future result, final int ... types) {
        Objects.requireNonNull(name, "no null name accepted");
        this.bootstrap.connect((SocketAddress)this.dnsServer).addListener((GenericFutureListener)new RetryChannelFutureListener(result){

            @Override
            public void onSuccess(ChannelFuture future) throws Exception {
                DnsQuery query = new DnsQuery(ThreadLocalRandom.current().nextInt());
                for (int type : types) {
                    query.addQuestion(new DnsQuestion(name, type));
                }
                future.channel().writeAndFlush((Object)query).addListener((GenericFutureListener)new RetryChannelFutureListener(result){

                    @Override
                    public void onSuccess(ChannelFuture future) throws Exception {
                        future.channel().pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<DnsResponse>(){

                            protected void channelRead0(ChannelHandlerContext ctx, DnsResponse msg) throws Exception {
                                DnsResponseCode code = DnsResponseCode.valueOf(((DnsResponseHeader)msg.getHeader()).getResponseCode());
                                if (code == DnsResponseCode.NOERROR) {
                                    List<DnsResource> resources = msg.getAnswers();
                                    ArrayList records = new ArrayList(resources.size());
                                    for (DnsResource resource : msg.getAnswers()) {
                                        Object record = RecordDecoderFactory.getFactory().decode(resource.type(), msg, resource);
                                        if (record instanceof InetAddress) {
                                            record = ((InetAddress)record).getHostAddress();
                                        }
                                        records.add(record);
                                    }
                                    DnsClientImpl.this.setResult(result, records);
                                } else {
                                    DnsClientImpl.this.setResult(result, new DnsException(code));
                                }
                                ctx.close();
                            }

                            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                                DnsClientImpl.this.setResult(result, cause);
                                ctx.close();
                            }
                        }});
                    }
                });
            }
        });
    }

    private void setResult(Future r, Object result) {
        if (r.isComplete()) {
            return;
        }
        this.actualCtx.executeSync(() -> {
            if (result instanceof Throwable) {
                r.fail((Throwable)result);
            } else {
                r.complete(result);
            }
        });
    }

    private abstract class RetryChannelFutureListener
    implements ChannelFutureListener {
        private final Future result;

        RetryChannelFutureListener(Future result) {
            this.result = result;
        }

        public final void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                if (!this.result.isComplete()) {
                    this.result.fail(future.cause());
                }
            } else {
                this.onSuccess(future);
            }
        }

        protected abstract void onSuccess(ChannelFuture var1) throws Exception;
    }

    protected abstract class ConvertingHandler<F, T>
    implements Handler<AsyncResult<List<F>>> {
        private final Handler handler;
        private final Comparator comparator;

        ConvertingHandler(Handler<AsyncResult<List<T>>> handler, Comparator comparator) {
            this.handler = handler;
            this.comparator = comparator;
        }

        @Override
        public void handle(AsyncResult<List<F>> event) {
            if (event.failed()) {
                this.handler.handle(event);
            } else {
                List<F> records = event.result();
                for (int i = 0; i < records.size(); ++i) {
                    F record = records.get(i);
                    records.set(i, this.convert(record));
                }
                Collections.sort(records, this.comparator);
                this.handler.handle(Future.succeededFuture(records));
            }
        }

        protected abstract T convert(F var1);
    }

    private static class HandlerAdapter<T>
    implements Handler<AsyncResult<List<T>>> {
        private final Handler handler;

        HandlerAdapter(Handler handler) {
            this.handler = handler;
        }

        @Override
        public void handle(AsyncResult<List<T>> event) {
            if (event.failed()) {
                this.handler.handle(event);
            } else {
                List<T> result = event.result();
                if (result.isEmpty()) {
                    this.handler.handle(Future.succeededFuture());
                } else {
                    this.handler.handle(Future.succeededFuture(result.get(0)));
                }
            }
        }
    }
}

