/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Starter;
import io.vertx.core.Vertx;
import io.vertx.core.impl.Action;
import io.vertx.core.impl.Closeable;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.ContextTask;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ContextImpl
implements Context {
    private static final Logger log = LoggerFactory.getLogger(ContextImpl.class);
    public final VertxInternal owner;
    protected final String deploymentID;
    protected final JsonObject config;
    private Deployment deployment;
    private Set<Closeable> closeHooks;
    private final ClassLoader tccl;
    private final EventLoop eventLoop;
    protected final Executor orderedInternalPoolExec;
    protected final Executor workerExec;
    protected VertxThread contextThread;
    private volatile boolean closeHooksRun;

    protected ContextImpl(VertxInternal vertx, Executor orderedInternalPoolExec, Executor workerExec, String deploymentID, JsonObject config, ClassLoader tccl) {
        this.orderedInternalPoolExec = orderedInternalPoolExec;
        this.workerExec = workerExec;
        this.deploymentID = deploymentID;
        this.config = config;
        EventLoopGroup group = vertx.getEventLoopGroup();
        this.eventLoop = group != null ? group.next() : null;
        this.tccl = tccl;
        this.owner = vertx;
    }

    public static void setContext(ContextImpl context) {
        Thread current = Thread.currentThread();
        if (current instanceof VertxThread) {
            ((VertxThread)current).setContext(context);
            if (context != null) {
                context.setTCCL();
            } else {
                Thread.currentThread().setContextClassLoader(null);
            }
        } else {
            throw new IllegalStateException("Attempt to setContext on non Vert.x thread " + Thread.currentThread());
        }
    }

    public void setDeployment(Deployment deployment) {
        this.deployment = deployment;
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public void addCloseHook(Closeable hook) {
        if (this.closeHooks == null) {
            this.closeHooks = new ConcurrentHashSet<Closeable>();
        }
        this.closeHooks.add(hook);
    }

    public void removeCloseHook(Closeable hook) {
        if (this.closeHooks != null) {
            this.closeHooks.remove(hook);
        }
    }

    public void runCloseHooks(Handler<AsyncResult<Void>> completionHandler) {
        if (this.closeHooksRun) {
            throw new IllegalStateException("Close hooks already run");
        }
        this.closeHooksRun = true;
        if (this.closeHooks != null && !this.closeHooks.isEmpty()) {
            HashSet<Closeable> copy = new HashSet<Closeable>(this.closeHooks);
            int num = copy.size();
            if (num != 0) {
                AtomicInteger count = new AtomicInteger();
                AtomicBoolean failed = new AtomicBoolean();
                for (Closeable hook : copy) {
                    try {
                        hook.close(ar -> {
                            if (ar.failed()) {
                                if (failed.compareAndSet(false, true)) {
                                    completionHandler.handle(Future.failedFuture(ar.cause()));
                                }
                            } else if (count.incrementAndGet() == num) {
                                completionHandler.handle(Future.succeededFuture());
                            }
                        });
                    }
                    catch (Throwable t) {
                        log.warn("Failed to run close hooks", t);
                    }
                }
            } else {
                completionHandler.handle(Future.succeededFuture());
            }
        } else {
            completionHandler.handle(Future.succeededFuture());
        }
    }

    protected abstract void executeAsync(Handler<Void> var1);

    @Override
    public abstract boolean isEventLoopContext();

    @Override
    public abstract boolean isMultiThreaded();

    public abstract Map<String, Object> contextData();

    @Override
    public <T> T get(String key) {
        return (T)this.contextData().get(key);
    }

    @Override
    public void put(String key, Object value) {
        this.contextData().put(key, value);
    }

    @Override
    public boolean remove(String key) {
        return this.contextData().remove(key) != null;
    }

    @Override
    public boolean isWorker() {
        return !this.isEventLoopContext();
    }

    public void executeSync(ContextTask task) {
        this.checkCorrectThread();
        this.wrapTask(task, null, true).run();
    }

    protected abstract void checkCorrectThread();

    @Override
    public void runOnContext(Handler<Void> task) {
        try {
            this.executeAsync(task);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public String deploymentID() {
        return this.deploymentID;
    }

    @Override
    public JsonObject config() {
        return this.config;
    }

    @Override
    public List<String> processArgs() {
        return Starter.PROCESS_ARGS;
    }

    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    @Override
    public Vertx owner() {
        return this.owner;
    }

    public <T> void executeBlocking(Action<T> action, boolean internal, Handler<AsyncResult<T>> resultHandler) {
        this.executeBlocking(action, null, internal, resultHandler);
    }

    public <T> void executeBlocking(Handler<Future<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) {
        this.executeBlocking(null, blockingCodeHandler, false, resultHandler);
    }

    private <T> void executeBlocking(Action<T> action, Handler<Future<T>> blockingCodeHandler, boolean internal, Handler<AsyncResult<T>> resultHandler) {
        try {
            Executor exec = internal ? this.orderedInternalPoolExec : this.workerExec;
            exec.execute(() -> {
                Future res = Future.future();
                try {
                    if (blockingCodeHandler != null) {
                        ContextImpl.setContext(this);
                        blockingCodeHandler.handle(res);
                    } else {
                        Object result = action.perform();
                        res.complete(result);
                    }
                }
                catch (Throwable e) {
                    res.fail(e);
                }
                if (resultHandler != null) {
                    this.runOnContext(v -> res.setHandler(resultHandler));
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeStart() {
        Thread thread = Thread.currentThread();
        if (this.contextThread == null) {
            if (!(thread instanceof VertxThread)) throw new IllegalStateException("Not a vert.x thread!");
            this.contextThread = (VertxThread)thread;
        } else if (this.contextThread != thread && !this.contextThread.isWorker()) {
            throw new IllegalStateException("Uh oh! Event loop context executing with wrong thread! Expected " + this.contextThread + " got " + thread);
        }
        this.contextThread.executeStart();
    }

    protected void executeEnd() {
        this.contextThread.executeEnd();
    }

    protected Runnable wrapTask(ContextTask cTask, Handler<Void> hTask, boolean checkThread) {
        return () -> {
            if (checkThread) {
                this.executeStart();
            }
            try {
                ContextImpl.setContext(this);
                if (cTask != null) {
                    cTask.run();
                } else {
                    hTask.handle(null);
                }
            }
            catch (Throwable t) {
                log.error("Unhandled exception", t);
            }
            finally {
                if (checkThread) {
                    this.executeEnd();
                }
            }
        };
    }

    private void setTCCL() {
        Thread.currentThread().setContextClassLoader(this.tccl);
    }
}

