/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.AssembledFullHttpResponse;
import io.vertx.core.http.impl.AssembledHttpResponse;
import io.vertx.core.http.impl.AssembledLastHttpContent;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.core.http.impl.ServerConnection;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class HttpServerResponseImpl
implements HttpServerResponse {
    private static final Logger log = LoggerFactory.getLogger(HttpServerResponseImpl.class);
    private final VertxInternal vertx;
    private final ServerConnection conn;
    private final HttpResponse response;
    private final HttpVersion version;
    private final boolean keepAlive;
    private boolean headWritten;
    private boolean written;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private Handler<Future> headersEndHandler;
    private Handler<Void> bodyEndHandler;
    private boolean chunked;
    private boolean closed;
    private ChannelFuture channelFuture;
    private MultiMap headers;
    private LastHttpContent trailing;
    private MultiMap trailers;
    private String statusMessage;

    HttpServerResponseImpl(VertxInternal vertx, ServerConnection conn, HttpRequest request) {
        this.vertx = vertx;
        this.conn = conn;
        this.version = request.getProtocolVersion();
        this.response = new DefaultHttpResponse(this.version, HttpResponseStatus.OK, false);
        this.keepAlive = this.version == HttpVersion.HTTP_1_1 || this.version == HttpVersion.HTTP_1_0 && request.headers().contains(HttpHeaders.CONNECTION, HttpHeaders.KEEP_ALIVE, true);
    }

    @Override
    public synchronized MultiMap headers() {
        if (this.headers == null) {
            this.headers = new HeadersAdaptor(this.response.headers());
        }
        return this.headers;
    }

    @Override
    public synchronized MultiMap trailers() {
        if (this.trailers == null) {
            if (this.trailing == null) {
                this.trailing = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, false);
            }
            this.trailers = new HeadersAdaptor(this.trailing.trailingHeaders());
        }
        return this.trailers;
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatus().code();
    }

    @Override
    public HttpServerResponse setStatusCode(int statusCode) {
        HttpResponseStatus status = this.statusMessage != null ? new HttpResponseStatus(statusCode, this.statusMessage) : HttpResponseStatus.valueOf((int)statusCode);
        this.response.setStatus(status);
        return this;
    }

    @Override
    public String getStatusMessage() {
        return this.response.getStatus().reasonPhrase();
    }

    @Override
    public synchronized HttpServerResponse setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        this.response.setStatus(new HttpResponseStatus(this.response.getStatus().code(), statusMessage));
        return this;
    }

    @Override
    public synchronized HttpServerResponseImpl setChunked(boolean chunked) {
        this.checkWritten();
        if (this.version != HttpVersion.HTTP_1_0) {
            this.chunked = chunked;
        }
        return this;
    }

    @Override
    public synchronized boolean isChunked() {
        return this.chunked;
    }

    @Override
    public synchronized HttpServerResponseImpl putHeader(String key, String value) {
        this.checkWritten();
        this.headers().set(key, value);
        return this;
    }

    @Override
    public synchronized HttpServerResponseImpl putHeader(String key, Iterable<String> values) {
        this.checkWritten();
        this.headers().set(key, values);
        return this;
    }

    @Override
    public synchronized HttpServerResponseImpl putTrailer(String key, String value) {
        this.checkWritten();
        this.trailers().set(key, value);
        return this;
    }

    @Override
    public synchronized HttpServerResponseImpl putTrailer(String key, Iterable<String> values) {
        this.checkWritten();
        this.trailers().set(key, values);
        return this;
    }

    @Override
    public synchronized HttpServerResponse putHeader(CharSequence name, CharSequence value) {
        this.checkWritten();
        this.headers().set(name, value);
        return this;
    }

    @Override
    public synchronized HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.checkWritten();
        this.headers().set(name, values);
        return this;
    }

    @Override
    public synchronized HttpServerResponse putTrailer(CharSequence name, CharSequence value) {
        this.checkWritten();
        this.trailers().set(name, value);
        return this;
    }

    @Override
    public synchronized HttpServerResponse putTrailer(CharSequence name, Iterable<CharSequence> value) {
        this.checkWritten();
        this.trailers().set(name, value);
        return this;
    }

    @Override
    public synchronized HttpServerResponse setWriteQueueMaxSize(int size) {
        this.checkWritten();
        this.conn.doSetWriteQueueMaxSize(size);
        return this;
    }

    @Override
    public synchronized boolean writeQueueFull() {
        this.checkWritten();
        return this.conn.isNotWritable();
    }

    @Override
    public synchronized HttpServerResponse drainHandler(Handler<Void> handler) {
        this.checkWritten();
        this.drainHandler = handler;
        this.conn.getContext().runOnContext(v -> this.conn.handleInterestedOpsChanged());
        return this;
    }

    @Override
    public synchronized HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        this.checkWritten();
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpServerResponse closeHandler(Handler<Void> handler) {
        this.checkWritten();
        this.closeHandler = handler;
        return this;
    }

    @Override
    public HttpServerResponseImpl write(Buffer chunk) {
        ByteBuf buf = chunk.getByteBuf();
        return this.write(buf, null);
    }

    @Override
    public HttpServerResponseImpl write(String chunk, String enc) {
        return this.write(Buffer.buffer(chunk, enc).getByteBuf(), null);
    }

    @Override
    public HttpServerResponseImpl write(String chunk) {
        return this.write(Buffer.buffer(chunk).getByteBuf(), null);
    }

    @Override
    public void end(String chunk) {
        this.end(Buffer.buffer(chunk));
    }

    @Override
    public void end(String chunk, String enc) {
        this.end(Buffer.buffer(chunk, enc));
    }

    @Override
    public synchronized void end(Buffer chunk) {
        if (!this.chunked && !this.contentLengthSet()) {
            this.headers().set(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(chunk.length()));
        }
        ByteBuf buf = chunk.getByteBuf();
        this.end0(buf);
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            if (this.headWritten) {
                this.closeConnAfterWrite();
            } else {
                this.conn.close();
            }
            this.closed = true;
        }
    }

    @Override
    public synchronized void end() {
        this.end0(Unpooled.EMPTY_BUFFER);
    }

    private void end0(ByteBuf data) {
        this.checkWritten();
        if (!this.headWritten) {
            this.prepareHeaders(() -> {
                AssembledFullHttpResponse resp = this.trailing != null ? new AssembledFullHttpResponse(this.response, data, this.trailing.trailingHeaders(), this.trailing.getDecoderResult()) : new AssembledFullHttpResponse(this.response, data);
                this.channelFuture = this.conn.writeToChannel(resp);
                this.headWritten = true;
            });
        } else if (!data.isReadable()) {
            this.channelFuture = this.trailing == null ? this.conn.writeToChannel(LastHttpContent.EMPTY_LAST_CONTENT) : this.conn.writeToChannel(this.trailing);
        } else {
            Object content = this.trailing != null ? new AssembledLastHttpContent(data, this.trailing.trailingHeaders(), this.trailing.getDecoderResult()) : new DefaultLastHttpContent(data, false);
            this.channelFuture = this.conn.writeToChannel(content);
        }
        if (!this.keepAlive) {
            this.closeConnAfterWrite();
        }
        this.written = true;
        this.conn.responseComplete();
        if (this.bodyEndHandler != null) {
            this.bodyEndHandler.handle(null);
        }
    }

    @Override
    public HttpServerResponseImpl sendFile(String filename) {
        this.doSendFile(filename, null);
        return this;
    }

    @Override
    public HttpServerResponse sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        this.doSendFile(filename, resultHandler);
        return this;
    }

    @Override
    public boolean ended() {
        return this.written;
    }

    @Override
    public boolean headWritten() {
        return this.headWritten;
    }

    @Override
    public synchronized HttpServerResponse headersEndHandler(Handler<Future> handler) {
        this.headersEndHandler = handler;
        return this;
    }

    @Override
    public synchronized HttpServerResponse bodyEndHandler(Handler<Void> handler) {
        this.bodyEndHandler = handler;
        return this;
    }

    private synchronized void doSendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        String ext;
        String contentType;
        int li;
        if (this.headWritten) {
            throw new IllegalStateException("Head already written");
        }
        this.checkWritten();
        File file = this.vertx.resolveFile(filename);
        long fileLength = file.length();
        if (!this.contentLengthSet()) {
            this.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(fileLength));
        }
        if (!this.contentTypeSet() && (li = filename.lastIndexOf(46)) != -1 && li != filename.length() - 1 && (contentType = MimeMapping.getMimeTypeForExtension(ext = filename.substring(li + 1, filename.length()))) != null) {
            this.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
        }
        this.prepareHeaders(() -> {
            try {
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                this.conn.queueForWrite(this.response);
                this.conn.sendFile(raf, fileLength);
            }
            catch (IOException e) {
                if (resultHandler != null) {
                    ContextImpl ctx = this.vertx.getOrCreateContext();
                    ctx.runOnContext(v -> resultHandler.handle(Future.failedFuture(e)));
                } else {
                    log.error("Failed to send file", e);
                }
                return;
            }
            this.channelFuture = this.conn.writeToChannel(LastHttpContent.EMPTY_LAST_CONTENT);
            this.written = true;
            this.headWritten = true;
            if (resultHandler != null) {
                ContextImpl ctx = this.vertx.getOrCreateContext();
                this.channelFuture.addListener(future -> {
                    Future res = future.isSuccess() ? Future.succeededFuture() : Future.failedFuture(future.cause());
                    ctx.runOnContext(v -> resultHandler.handle(res));
                });
            }
            if (!this.keepAlive) {
                this.closeConnAfterWrite();
            }
            this.conn.responseComplete();
            if (this.bodyEndHandler != null) {
                this.bodyEndHandler.handle(null);
            }
        });
    }

    private synchronized boolean contentLengthSet() {
        if (this.headers == null) {
            return false;
        }
        return this.response.headers().contains(HttpHeaders.CONTENT_LENGTH);
    }

    private synchronized boolean contentTypeSet() {
        if (this.headers == null) {
            return false;
        }
        return this.response.headers().contains(HttpHeaders.CONTENT_TYPE);
    }

    private void closeConnAfterWrite() {
        if (this.channelFuture != null) {
            this.channelFuture.addListener(fut -> this.conn.close());
        }
    }

    synchronized void handleDrained() {
        if (this.drainHandler != null) {
            this.drainHandler.handle(null);
        }
    }

    synchronized void handleException(Throwable t) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(t);
        }
    }

    synchronized void handleClosed() {
        if (this.closeHandler != null) {
            this.closeHandler.handle(null);
        }
    }

    private void checkWritten() {
        if (this.written) {
            throw new IllegalStateException("Response has already been written");
        }
    }

    private void prepareHeaders(Runnable after) {
        if (this.version == HttpVersion.HTTP_1_0 && this.keepAlive) {
            this.response.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.KEEP_ALIVE);
        }
        if (this.chunked) {
            this.response.headers().set(HttpHeaders.TRANSFER_ENCODING, (Object)HttpHeaders.CHUNKED);
        } else if (this.version != HttpVersion.HTTP_1_0 && !this.contentLengthSet()) {
            this.response.headers().set(HttpHeaders.CONTENT_LENGTH, (Object)"0");
        }
        if (this.headersEndHandler != null) {
            Future fut = Future.future();
            fut.setHandler(res -> {
                if (res.succeeded()) {
                    after.run();
                } else if (this.exceptionHandler != null) {
                    this.exceptionHandler.handle(res.cause());
                } else {
                    log.error("Failure in headers end handler", res.cause());
                }
            });
            this.headersEndHandler.handle(fut);
        } else {
            after.run();
        }
    }

    private synchronized HttpServerResponseImpl write(ByteBuf chunk, Handler<AsyncResult<Void>> completionHandler) {
        this.checkWritten();
        if (!(this.headWritten || this.version == HttpVersion.HTTP_1_0 || this.chunked || this.contentLengthSet())) {
            throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
        }
        if (!this.headWritten) {
            this.prepareHeaders(() -> {
                this.channelFuture = this.conn.writeToChannel(new AssembledHttpResponse(this.response, chunk));
                this.headWritten = true;
            });
        } else {
            this.channelFuture = this.conn.writeToChannel(new DefaultHttpContent(chunk));
        }
        this.conn.addFuture(completionHandler, this.channelFuture);
        return this;
    }
}

