/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.core.http.Http2Settings;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.json.JsonCodec;
import java.util.Map;

public class Http2SettingsConverter
implements JsonCodec<Http2Settings, JsonObject> {
    public static final Http2SettingsConverter INSTANCE = new Http2SettingsConverter();

    @Override
    public JsonObject encode(Http2Settings value) {
        return value != null ? value.toJson() : null;
    }

    @Override
    public Http2Settings decode(JsonObject value) {
        return value != null ? new Http2Settings(value) : null;
    }

    @Override
    public Class<Http2Settings> getTargetClass() {
        return Http2Settings.class;
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, Http2Settings obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "headerTableSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHeaderTableSize(((Number)member.getValue()).longValue());
                    break;
                }
                case "initialWindowSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setInitialWindowSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxConcurrentStreams": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxConcurrentStreams(((Number)member.getValue()).longValue());
                    break;
                }
                case "maxFrameSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxFrameSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxHeaderListSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxHeaderListSize(((Number)member.getValue()).longValue());
                    break;
                }
                case "pushEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setPushEnabled((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(Http2Settings obj, JsonObject json) {
        Http2SettingsConverter.toJson(obj, json.getMap());
    }

    static void toJson(Http2Settings obj, Map<String, Object> json) {
        json.put("headerTableSize", obj.getHeaderTableSize());
        json.put("initialWindowSize", obj.getInitialWindowSize());
        json.put("maxConcurrentStreams", obj.getMaxConcurrentStreams());
        json.put("maxFrameSize", obj.getMaxFrameSize());
        json.put("maxHeaderListSize", obj.getMaxHeaderListSize());
        json.put("pushEnabled", obj.isPushEnabled());
    }
}

