/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.spi.json.JsonCodec;
import java.util.Map;

public class NetClientOptionsConverter
implements JsonCodec<NetClientOptions, JsonObject> {
    public static final NetClientOptionsConverter INSTANCE = new NetClientOptionsConverter();

    @Override
    public JsonObject encode(NetClientOptions value) {
        return value != null ? value.toJson() : null;
    }

    @Override
    public NetClientOptions decode(JsonObject value) {
        return value != null ? new NetClientOptions(value) : null;
    }

    @Override
    public Class<NetClientOptions> getTargetClass() {
        return NetClientOptions.class;
    }

    static void fromJson(Iterable<Map.Entry<String, Object>> json, NetClientOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "hostnameVerificationAlgorithm": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHostnameVerificationAlgorithm((String)member.getValue());
                    break;
                }
                case "reconnectAttempts": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReconnectAttempts(((Number)member.getValue()).intValue());
                    break;
                }
                case "reconnectInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReconnectInterval(((Number)member.getValue()).longValue());
                }
            }
        }
    }

    static void toJson(NetClientOptions obj, JsonObject json) {
        NetClientOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(NetClientOptions obj, Map<String, Object> json) {
        if (obj.getHostnameVerificationAlgorithm() != null) {
            json.put("hostnameVerificationAlgorithm", obj.getHostnameVerificationAlgorithm());
        }
        json.put("reconnectAttempts", obj.getReconnectAttempts());
        json.put("reconnectInterval", obj.getReconnectInterval());
    }
}

