/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.http.impl.ConnectionManager;
import io.vertx.core.http.impl.Http1xClientConnection;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class HttpClientImpl
implements HttpClient,
MetricsProvider {
    private final Function<HttpClientResponse, Future<HttpClientRequest>> DEFAULT_HANDLER = resp -> {
        try {
            int statusCode = resp.statusCode();
            String location = resp.getHeader(HttpHeaders.LOCATION);
            if (location != null && (statusCode == 301 || statusCode == 302 || statusCode == 303 || statusCode == 307 || statusCode == 308)) {
                boolean ssl;
                HttpMethod m = resp.request().method();
                if (statusCode == 303) {
                    m = HttpMethod.GET;
                } else if (m != HttpMethod.GET && m != HttpMethod.HEAD) {
                    return null;
                }
                URI uri = HttpUtils.resolveURIReference(resp.request().absoluteURI(), location);
                int port = uri.getPort();
                String protocol = uri.getScheme();
                char chend = protocol.charAt(protocol.length() - 1);
                if (chend == 'p') {
                    ssl = false;
                    if (port == -1) {
                        port = 80;
                    }
                } else if (chend == 's') {
                    ssl = true;
                    if (port == -1) {
                        port = 443;
                    }
                } else {
                    return null;
                }
                String requestURI = uri.getPath();
                String query = uri.getQuery();
                if (query != null) {
                    requestURI = requestURI + "?" + query;
                }
                return Future.succeededFuture(this.createRequest(m, null, uri.getHost(), port, ssl, requestURI, null));
            }
            return null;
        }
        catch (Exception e) {
            return Future.failedFuture(e);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(HttpClientImpl.class);
    private final VertxInternal vertx;
    private final HttpClientOptions options;
    private final ContextInternal creatingContext;
    private final ConnectionManager websocketCM;
    private final ConnectionManager httpCM;
    private final Closeable closeHook;
    private final ProxyType proxyType;
    private final SSLHelper sslHelper;
    private final HttpClientMetrics metrics;
    private final boolean keepAlive;
    private final boolean pipelining;
    private volatile boolean closed;
    private volatile Handler<HttpConnection> connectionHandler;
    private volatile Function<HttpClientResponse, Future<HttpClientRequest>> redirectHandler = this.DEFAULT_HANDLER;

    public HttpClientImpl(VertxInternal vertx, HttpClientOptions options) {
        this.vertx = vertx;
        this.metrics = vertx.metricsSPI() != null ? vertx.metricsSPI().createHttpClientMetrics(options) : null;
        this.options = new HttpClientOptions(options);
        List<HttpVersion> alpnVersions = options.getAlpnVersions();
        if (alpnVersions == null || alpnVersions.isEmpty()) {
            switch (options.getProtocolVersion()) {
                case HTTP_2: {
                    alpnVersions = Arrays.asList(HttpVersion.HTTP_2, HttpVersion.HTTP_1_1);
                    break;
                }
                default: {
                    alpnVersions = Collections.singletonList(options.getProtocolVersion());
                }
            }
        }
        this.keepAlive = options.isKeepAlive();
        this.pipelining = options.isPipelining();
        this.sslHelper = new SSLHelper(options, options.getKeyCertOptions(), options.getTrustOptions()).setApplicationProtocols(alpnVersions);
        this.sslHelper.validate(vertx);
        this.creatingContext = vertx.getContext();
        this.closeHook = completionHandler -> {
            this.close();
            completionHandler.handle(Future.succeededFuture());
        };
        if (this.creatingContext != null) {
            if (options.getProtocolVersion() == HttpVersion.HTTP_2 && Context.isOnWorkerThread()) {
                throw new IllegalStateException("Cannot use HttpClient with HTTP_2 in a worker");
            }
            this.creatingContext.addCloseHook(this.closeHook);
        }
        if (!this.keepAlive && this.pipelining) {
            throw new IllegalStateException("Cannot have pipelining with no keep alive");
        }
        long maxWeight = options.getMaxPoolSize() * options.getHttp2MaxPoolSize();
        this.websocketCM = new ConnectionManager(this, this.metrics, HttpVersion.HTTP_1_1, maxWeight, options.getMaxWaitQueueSize());
        this.httpCM = new ConnectionManager(this, this.metrics, options.getProtocolVersion(), maxWeight, options.getMaxWaitQueueSize());
        this.proxyType = options.getProxyOptions() != null ? options.getProxyOptions().getType() : null;
        this.httpCM.start();
        this.websocketCM.start();
    }

    HttpClientMetrics metrics() {
        return this.metrics;
    }

    @Override
    public void webSocket(WebSocketConnectOptions connectOptions, Handler<AsyncResult<WebSocket>> handler) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        SocketAddress addr = SocketAddress.inetSocketAddress(connectOptions.getPort(), connectOptions.getHost());
        this.websocketCM.getConnection(ctx, addr, connectOptions.isSsl() != null ? connectOptions.isSsl().booleanValue() : this.options.isSsl(), addr, ar -> {
            if (ar.succeeded()) {
                Http1xClientConnection conn = (Http1xClientConnection)ar.result();
                conn.toWebSocket(connectOptions.getURI(), connectOptions.getHeaders(), connectOptions.getVersion(), connectOptions.getSubProtocols(), this.options.getMaxWebsocketFrameSize(), handler);
            } else {
                ctx.schedule(v -> handler.handle(Future.failedFuture(ar.cause())));
            }
        });
    }

    @Override
    public Future<WebSocket> webSocket(int port, String host, String requestURI) {
        Promise<WebSocket> promise = Promise.promise();
        this.webSocket(port, host, requestURI, promise);
        return promise.future();
    }

    @Override
    public Future<WebSocket> webSocket(String host, String requestURI) {
        Promise<WebSocket> promise = Promise.promise();
        this.webSocket(host, requestURI, promise);
        return promise.future();
    }

    @Override
    public Future<WebSocket> webSocket(String requestURI) {
        Promise<WebSocket> promise = Promise.promise();
        this.webSocket(requestURI, promise);
        return promise.future();
    }

    @Override
    public Future<WebSocket> webSocket(WebSocketConnectOptions options) {
        Promise<WebSocket> promise = Promise.promise();
        this.webSocket(options, promise);
        return promise.future();
    }

    @Override
    public Future<WebSocket> webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        Promise<WebSocket> promise = Promise.promise();
        this.webSocketAbs(url, headers, version, subProtocols, promise);
        return promise.future();
    }

    @Override
    public void webSocket(int port, String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.webSocket(new WebSocketConnectOptions().setURI(requestURI).setHost(host).setPort(port), handler);
    }

    @Override
    public void webSocket(String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.webSocket(this.options.getDefaultPort(), host, requestURI, handler);
    }

    @Override
    public void webSocket(String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.webSocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, handler);
    }

    @Override
    public void webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols, Handler<AsyncResult<WebSocket>> handler) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        String scheme = uri.getScheme();
        if (!"ws".equals(scheme) && !"wss".equals(scheme)) {
            throw new IllegalArgumentException("Scheme: " + scheme);
        }
        boolean ssl = scheme.length() == 3;
        int port = uri.getPort();
        if (port == -1) {
            port = ssl ? 443 : 80;
        }
        StringBuilder relativeUri = new StringBuilder();
        if (uri.getRawPath() != null) {
            relativeUri.append(uri.getRawPath());
        }
        if (uri.getRawQuery() != null) {
            relativeUri.append('?').append(uri.getRawQuery());
        }
        if (uri.getRawFragment() != null) {
            relativeUri.append('#').append(uri.getRawFragment());
        }
        WebSocketConnectOptions options = new WebSocketConnectOptions().setHost(uri.getHost()).setPort(port).setSsl(ssl).setURI(relativeUri.toString()).setHeaders(headers).setVersion(version).setSubProtocols(subProtocols);
        this.webSocket(options, handler);
    }

    @Override
    public HttpClientRequest requestAbs(HttpMethod method, String absoluteURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.requestAbs(method, null, absoluteURI, responseHandler);
    }

    @Override
    public HttpClientRequest requestAbs(HttpMethod method, SocketAddress serverAddress, String absoluteURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        Objects.requireNonNull(responseHandler, "no null responseHandler accepted");
        return this.requestAbs(method, serverAddress, absoluteURI).setHandler((Handler)responseHandler);
    }

    @Override
    public HttpClientRequest get(RequestOptions options) {
        return this.request(HttpMethod.GET, options);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        Objects.requireNonNull(responseHandler, "no null responseHandler accepted");
        return this.request(method, port, host, requestURI).setHandler((Handler)responseHandler);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, SocketAddress serverAddress, int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        Objects.requireNonNull(responseHandler, "no null responseHandler accepted");
        return this.request(method, serverAddress, port, host, requestURI).setHandler((Handler)responseHandler);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(method, this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, String requestURI) {
        return this.request(method, this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(method, this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest requestAbs(HttpMethod method, String absoluteURI) {
        return this.requestAbs(method, null, absoluteURI);
    }

    @Override
    public HttpClientRequest requestAbs(HttpMethod method, SocketAddress serverAddress, String absoluteURI) {
        URL url = this.parseUrl(absoluteURI);
        Boolean ssl = false;
        int port = url.getPort();
        String relativeUri = url.getPath().isEmpty() ? "/" + url.getFile() : url.getFile();
        String protocol = url.getProtocol();
        if ("ftp".equals(protocol)) {
            if (port == -1) {
                port = 21;
            }
        } else {
            char chend = protocol.charAt(protocol.length() - 1);
            if (chend == 'p') {
                if (port == -1) {
                    port = 80;
                }
            } else if (chend == 's') {
                ssl = true;
                if (port == -1) {
                    port = 443;
                }
            }
        }
        return this.createRequest(method, serverAddress, protocol, url.getHost(), port, ssl, relativeUri, null);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, int port, String host, String requestURI) {
        return this.createRequest(method, null, host, port, null, requestURI, null);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, SocketAddress serverAddress, int port, String host, String requestURI) {
        return this.createRequest(method, serverAddress, host, port, null, requestURI, null);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(method, options).setHandler((Handler)responseHandler);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, SocketAddress serverAddress, RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(method, serverAddress, options).setHandler((Handler)responseHandler);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, SocketAddress serverAddress, RequestOptions options) {
        return this.createRequest(method, serverAddress, options.getHost(), options.getPort(), options.isSsl(), options.getURI(), null);
    }

    @Override
    public HttpClientRequest request(HttpMethod method, RequestOptions options) {
        return this.createRequest(method, null, options.getHost(), options.getPort(), options.isSsl(), options.getURI(), options.getHeaders());
    }

    @Override
    public HttpClientRequest request(HttpMethod method, String host, String requestURI) {
        return this.request(method, this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest get(int port, String host, String requestURI) {
        return this.request(HttpMethod.GET, port, host, requestURI);
    }

    @Override
    public HttpClientRequest get(String host, String requestURI) {
        return this.get(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest get(RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.GET, options, responseHandler);
    }

    @Override
    public HttpClientRequest get(int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.GET, port, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest get(String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.get(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest get(String requestURI) {
        return this.request(HttpMethod.GET, requestURI);
    }

    @Override
    public HttpClientRequest get(String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.GET, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest getAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.GET, absoluteURI);
    }

    @Override
    public HttpClientRequest getAbs(String absoluteURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.requestAbs(HttpMethod.GET, absoluteURI, responseHandler);
    }

    @Override
    public HttpClient getNow(RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.requestNow(HttpMethod.GET, options, responseHandler);
    }

    @Override
    public HttpClient getNow(int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.get(port, host, requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClient getNow(String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.getNow(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClient getNow(String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.get(requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClientRequest post(RequestOptions options) {
        return this.request(HttpMethod.POST, options);
    }

    @Override
    public HttpClientRequest post(int port, String host, String requestURI) {
        return this.request(HttpMethod.POST, port, host, requestURI);
    }

    @Override
    public HttpClientRequest post(String host, String requestURI) {
        return this.post(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest post(RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.POST, options, responseHandler);
    }

    @Override
    public HttpClientRequest post(int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.POST, port, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest post(String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.post(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest post(String requestURI) {
        return this.request(HttpMethod.POST, requestURI);
    }

    @Override
    public HttpClientRequest post(String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.POST, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest postAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.POST, absoluteURI);
    }

    @Override
    public HttpClientRequest postAbs(String absoluteURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.requestAbs(HttpMethod.POST, absoluteURI, responseHandler);
    }

    @Override
    public HttpClientRequest head(RequestOptions options) {
        return this.request(HttpMethod.HEAD, options);
    }

    @Override
    public HttpClientRequest head(int port, String host, String requestURI) {
        return this.request(HttpMethod.HEAD, port, host, requestURI);
    }

    @Override
    public HttpClientRequest head(String host, String requestURI) {
        return this.head(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest head(RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.HEAD, options, responseHandler);
    }

    @Override
    public HttpClientRequest head(int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.HEAD, port, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest head(String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.head(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest head(String requestURI) {
        return this.request(HttpMethod.HEAD, requestURI);
    }

    @Override
    public HttpClientRequest head(String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.HEAD, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest headAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.HEAD, absoluteURI);
    }

    @Override
    public HttpClientRequest headAbs(String absoluteURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.requestAbs(HttpMethod.HEAD, absoluteURI, responseHandler);
    }

    @Override
    public HttpClient headNow(RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.requestNow(HttpMethod.HEAD, options, responseHandler);
    }

    @Override
    public HttpClient headNow(int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.head(port, host, requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClient headNow(String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.headNow(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClient headNow(String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.head(requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClientRequest options(RequestOptions options) {
        return this.request(HttpMethod.OPTIONS, options);
    }

    @Override
    public HttpClientRequest options(int port, String host, String requestURI) {
        return this.request(HttpMethod.OPTIONS, port, host, requestURI);
    }

    @Override
    public HttpClientRequest options(String host, String requestURI) {
        return this.options(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest options(RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.OPTIONS, options, responseHandler);
    }

    @Override
    public HttpClientRequest options(int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.OPTIONS, port, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest options(String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.options(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest options(String requestURI) {
        return this.request(HttpMethod.OPTIONS, requestURI);
    }

    @Override
    public HttpClientRequest options(String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.OPTIONS, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest optionsAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.OPTIONS, absoluteURI);
    }

    @Override
    public HttpClientRequest optionsAbs(String absoluteURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.requestAbs(HttpMethod.OPTIONS, absoluteURI, responseHandler);
    }

    @Override
    public HttpClient optionsNow(RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.requestNow(HttpMethod.OPTIONS, options, responseHandler);
    }

    @Override
    public HttpClient optionsNow(int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.options(port, host, requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClient optionsNow(String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.optionsNow(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClient optionsNow(String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.options(requestURI, responseHandler).end();
        return this;
    }

    @Override
    public HttpClientRequest put(RequestOptions options) {
        return this.request(HttpMethod.PUT, options);
    }

    @Override
    public HttpClientRequest put(int port, String host, String requestURI) {
        return this.request(HttpMethod.PUT, port, host, requestURI);
    }

    @Override
    public HttpClientRequest put(String host, String requestURI) {
        return this.put(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest put(RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.PUT, options, responseHandler);
    }

    @Override
    public HttpClientRequest put(int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.PUT, port, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest put(String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.put(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest put(String requestURI) {
        return this.request(HttpMethod.PUT, requestURI);
    }

    @Override
    public HttpClientRequest put(String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.PUT, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest putAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.PUT, absoluteURI);
    }

    @Override
    public HttpClientRequest putAbs(String absoluteURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.requestAbs(HttpMethod.PUT, absoluteURI, responseHandler);
    }

    @Override
    public HttpClientRequest delete(RequestOptions options) {
        return this.request(HttpMethod.DELETE, options);
    }

    @Override
    public HttpClientRequest delete(int port, String host, String requestURI) {
        return this.request(HttpMethod.DELETE, port, host, requestURI);
    }

    @Override
    public HttpClientRequest delete(String host, String requestURI) {
        return this.delete(this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public HttpClientRequest delete(RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.DELETE, options, responseHandler);
    }

    @Override
    public HttpClientRequest delete(int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.DELETE, port, host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest delete(String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.delete(this.options.getDefaultPort(), host, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest delete(String requestURI) {
        return this.request(HttpMethod.DELETE, requestURI);
    }

    @Override
    public HttpClientRequest delete(String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.request(HttpMethod.DELETE, requestURI, responseHandler);
    }

    @Override
    public HttpClientRequest deleteAbs(String absoluteURI) {
        return this.requestAbs(HttpMethod.DELETE, absoluteURI);
    }

    @Override
    public HttpClientRequest deleteAbs(String absoluteURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        return this.requestAbs(HttpMethod.DELETE, absoluteURI, responseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HttpClientImpl httpClientImpl = this;
        synchronized (httpClientImpl) {
            this.checkClosed();
            this.closed = true;
        }
        if (this.creatingContext != null) {
            this.creatingContext.removeCloseHook(this.closeHook);
        }
        this.websocketCM.close();
        this.httpCM.close();
        if (this.metrics != null) {
            this.metrics.close();
        }
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.getMetrics() != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public HttpClient connectionHandler(Handler<HttpConnection> handler) {
        this.connectionHandler = handler;
        return this;
    }

    Handler<HttpConnection> connectionHandler() {
        return this.connectionHandler;
    }

    @Override
    public HttpClient redirectHandler(Function<HttpClientResponse, Future<HttpClientRequest>> handler) {
        if (handler == null) {
            handler = this.DEFAULT_HANDLER;
        }
        this.redirectHandler = handler;
        return this;
    }

    @Override
    public Function<HttpClientResponse, Future<HttpClientRequest>> redirectHandler() {
        return this.redirectHandler;
    }

    public HttpClientOptions getOptions() {
        return this.options;
    }

    void getConnectionForRequest(ContextInternal ctx, SocketAddress peerAddress, boolean ssl, SocketAddress server, Handler<AsyncResult<HttpClientStream>> handler) {
        this.httpCM.getConnection(ctx, peerAddress, ssl, server, ar -> {
            if (ar.succeeded()) {
                ((HttpClientConnection)ar.result()).createStream(ctx, handler);
            } else {
                ctx.dispatch(Future.failedFuture(ar.cause()), handler);
            }
        });
    }

    public VertxInternal getVertx() {
        return this.vertx;
    }

    SSLHelper getSslHelper() {
        return this.sslHelper;
    }

    private URL parseUrl(String surl) {
        try {
            return new URL(surl);
        }
        catch (MalformedURLException e) {
            throw new VertxException("Invalid url: " + surl, e);
        }
    }

    private HttpClient requestNow(HttpMethod method, RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.createRequest(method, null, options.getHost(), options.getPort(), options.isSsl(), options.getURI(), null).setHandler((Handler)responseHandler).end();
        return this;
    }

    private HttpClientRequest createRequest(HttpMethod method, SocketAddress serverAddress, String host, int port, Boolean ssl, String relativeURI, MultiMap headers) {
        return this.createRequest(method, serverAddress, ssl == null || ssl == false ? "http" : "https", host, port, ssl, relativeURI, headers);
    }

    private HttpClientRequest createRequest(HttpMethod method, SocketAddress server, String protocol, String host, int port, Boolean ssl, String relativeURI, MultiMap headers) {
        HttpClientRequestImpl req;
        boolean useProxy;
        boolean useSSL;
        Objects.requireNonNull(method, "no null method accepted");
        Objects.requireNonNull(protocol, "no null protocol accepted");
        Objects.requireNonNull(host, "no null host accepted");
        Objects.requireNonNull(relativeURI, "no null relativeURI accepted");
        boolean useAlpn = this.options.isUseAlpn();
        boolean bl = useSSL = ssl != null ? ssl.booleanValue() : this.options.isSsl();
        if (!useAlpn && useSSL && this.options.getProtocolVersion() == HttpVersion.HTTP_2) {
            throw new IllegalArgumentException("Must enable ALPN when using H2");
        }
        this.checkClosed();
        boolean bl2 = useProxy = !useSSL && this.proxyType == ProxyType.HTTP;
        if (useProxy) {
            int defaultPort = protocol.equals("ftp") ? 21 : 80;
            String addPort = port != -1 && port != defaultPort ? ":" + port : "";
            relativeURI = protocol + "://" + host + addPort + relativeURI;
            ProxyOptions proxyOptions = this.options.getProxyOptions();
            if (proxyOptions.getUsername() != null && proxyOptions.getPassword() != null) {
                if (headers == null) {
                    headers = MultiMap.caseInsensitiveMultiMap();
                }
                headers.add("Proxy-Authorization", "Basic " + Base64.getEncoder().encodeToString((proxyOptions.getUsername() + ":" + proxyOptions.getPassword()).getBytes()));
            }
            req = new HttpClientRequestImpl(this, useSSL, method, SocketAddress.inetSocketAddress(proxyOptions.getPort(), proxyOptions.getHost()), host, port, relativeURI, this.vertx);
        } else {
            if (server == null) {
                server = SocketAddress.inetSocketAddress(port, host);
            }
            req = new HttpClientRequestImpl(this, useSSL, method, server, host, port, relativeURI, this.vertx);
        }
        if (headers != null) {
            req.headers().setAll(headers);
        }
        return req;
    }

    private synchronized void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Client is closed");
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

