/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TCPSSLOptions;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TCPSSLOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, TCPSSLOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "crlPaths": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addCrlPath((String)item);
                        }
                    });
                    break;
                }
                case "crlValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addCrlValue(Buffer.buffer(Base64.getDecoder().decode((String)item)));
                        }
                    });
                    break;
                }
                case "enabledCipherSuites": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addEnabledCipherSuite((String)item);
                        }
                    });
                    break;
                }
                case "enabledSecureTransportProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<String> list = new LinkedHashSet<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setEnabledSecureTransportProtocols(list);
                    break;
                }
                case "idleTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setIdleTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "idleTimeoutUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setIdleTimeoutUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "jdkSslEngineOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setJdkSslEngineOptions(new JdkSSLEngineOptions((JsonObject)member.getValue()));
                    break;
                }
                case "keyStoreOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setKeyStoreOptions(new JksOptions((JsonObject)member.getValue()));
                    break;
                }
                case "openSslEngineOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setOpenSslEngineOptions(new OpenSSLEngineOptions((JsonObject)member.getValue()));
                    break;
                }
                case "pemKeyCertOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setPemKeyCertOptions(new PemKeyCertOptions((JsonObject)member.getValue()));
                    break;
                }
                case "pemTrustOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setPemTrustOptions(new PemTrustOptions((JsonObject)member.getValue()));
                    break;
                }
                case "pfxKeyCertOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setPfxKeyCertOptions(new PfxOptions((JsonObject)member.getValue()));
                    break;
                }
                case "pfxTrustOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setPfxTrustOptions(new PfxOptions((JsonObject)member.getValue()));
                    break;
                }
                case "soLinger": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setSoLinger(((Number)member.getValue()).intValue());
                    break;
                }
                case "ssl": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setSsl((Boolean)member.getValue());
                    break;
                }
                case "sslHandshakeTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setSslHandshakeTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "sslHandshakeTimeoutUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSslHandshakeTimeoutUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "tcpCork": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTcpCork((Boolean)member.getValue());
                    break;
                }
                case "tcpFastOpen": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTcpFastOpen((Boolean)member.getValue());
                    break;
                }
                case "tcpKeepAlive": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTcpKeepAlive((Boolean)member.getValue());
                    break;
                }
                case "tcpNoDelay": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTcpNoDelay((Boolean)member.getValue());
                    break;
                }
                case "tcpQuickAck": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTcpQuickAck((Boolean)member.getValue());
                    break;
                }
                case "trustStoreOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setTrustStoreOptions(new JksOptions((JsonObject)member.getValue()));
                    break;
                }
                case "useAlpn": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setUseAlpn((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(TCPSSLOptions obj, JsonObject json) {
        TCPSSLOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(TCPSSLOptions obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getCrlPaths() != null) {
            array = new JsonArray();
            obj.getCrlPaths().forEach(item -> array.add((String)item));
            json.put("crlPaths", array);
        }
        if (obj.getCrlValues() != null) {
            array = new JsonArray();
            obj.getCrlValues().forEach(item -> array.add(Base64.getEncoder().encodeToString(item.getBytes())));
            json.put("crlValues", array);
        }
        if (obj.getEnabledCipherSuites() != null) {
            array = new JsonArray();
            obj.getEnabledCipherSuites().forEach(item -> array.add((String)item));
            json.put("enabledCipherSuites", array);
        }
        if (obj.getEnabledSecureTransportProtocols() != null) {
            array = new JsonArray();
            obj.getEnabledSecureTransportProtocols().forEach(item -> array.add((String)item));
            json.put("enabledSecureTransportProtocols", array);
        }
        json.put("idleTimeout", obj.getIdleTimeout());
        if (obj.getIdleTimeoutUnit() != null) {
            json.put("idleTimeoutUnit", obj.getIdleTimeoutUnit().name());
        }
        if (obj.getJdkSslEngineOptions() != null) {
            json.put("jdkSslEngineOptions", obj.getJdkSslEngineOptions().toJson());
        }
        if (obj.getKeyStoreOptions() != null) {
            json.put("keyStoreOptions", obj.getKeyStoreOptions().toJson());
        }
        if (obj.getOpenSslEngineOptions() != null) {
            json.put("openSslEngineOptions", obj.getOpenSslEngineOptions().toJson());
        }
        if (obj.getPemKeyCertOptions() != null) {
            json.put("pemKeyCertOptions", obj.getPemKeyCertOptions().toJson());
        }
        if (obj.getPemTrustOptions() != null) {
            json.put("pemTrustOptions", obj.getPemTrustOptions().toJson());
        }
        if (obj.getPfxKeyCertOptions() != null) {
            json.put("pfxKeyCertOptions", obj.getPfxKeyCertOptions().toJson());
        }
        if (obj.getPfxTrustOptions() != null) {
            json.put("pfxTrustOptions", obj.getPfxTrustOptions().toJson());
        }
        json.put("soLinger", obj.getSoLinger());
        json.put("ssl", obj.isSsl());
        json.put("sslHandshakeTimeout", obj.getSslHandshakeTimeout());
        if (obj.getSslHandshakeTimeoutUnit() != null) {
            json.put("sslHandshakeTimeoutUnit", obj.getSslHandshakeTimeoutUnit().name());
        }
        json.put("tcpCork", obj.isTcpCork());
        json.put("tcpFastOpen", obj.isTcpFastOpen());
        json.put("tcpKeepAlive", obj.isTcpKeepAlive());
        json.put("tcpNoDelay", obj.isTcpNoDelay());
        json.put("tcpQuickAck", obj.isTcpQuickAck());
        if (obj.getTrustStoreOptions() != null) {
            json.put("trustStoreOptions", obj.getTrustStoreOptions().toJson());
        }
        json.put("useAlpn", obj.isUseAlpn());
    }
}

