/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.metrics.Measured;
import io.vertx.core.net.SocketAddress;
import java.util.List;
import java.util.function.Function;

@VertxGen
public interface HttpClient
extends Measured {
    public HttpClientRequest request(HttpMethod var1, SocketAddress var2, RequestOptions var3);

    public HttpClientRequest request(HttpMethod var1, RequestOptions var2);

    public HttpClientRequest request(HttpMethod var1, int var2, String var3, String var4);

    public HttpClientRequest request(HttpMethod var1, SocketAddress var2, int var3, String var4, String var5);

    public HttpClientRequest request(HttpMethod var1, String var2, String var3);

    public HttpClientRequest request(HttpMethod var1, RequestOptions var2, Handler<AsyncResult<HttpClientResponse>> var3);

    public HttpClientRequest request(HttpMethod var1, SocketAddress var2, RequestOptions var3, Handler<AsyncResult<HttpClientResponse>> var4);

    public HttpClientRequest request(HttpMethod var1, int var2, String var3, String var4, Handler<AsyncResult<HttpClientResponse>> var5);

    public HttpClientRequest request(HttpMethod var1, SocketAddress var2, int var3, String var4, String var5, Handler<AsyncResult<HttpClientResponse>> var6);

    public HttpClientRequest request(HttpMethod var1, String var2, String var3, Handler<AsyncResult<HttpClientResponse>> var4);

    public HttpClientRequest request(HttpMethod var1, String var2);

    public HttpClientRequest request(HttpMethod var1, String var2, Handler<AsyncResult<HttpClientResponse>> var3);

    public HttpClientRequest requestAbs(HttpMethod var1, String var2);

    public HttpClientRequest requestAbs(HttpMethod var1, SocketAddress var2, String var3);

    public HttpClientRequest requestAbs(HttpMethod var1, String var2, Handler<AsyncResult<HttpClientResponse>> var3);

    public HttpClientRequest requestAbs(HttpMethod var1, SocketAddress var2, String var3, Handler<AsyncResult<HttpClientResponse>> var4);

    public HttpClientRequest get(RequestOptions var1);

    public HttpClientRequest get(int var1, String var2, String var3);

    public HttpClientRequest get(String var1, String var2);

    public HttpClientRequest get(RequestOptions var1, Handler<AsyncResult<HttpClientResponse>> var2);

    public HttpClientRequest get(int var1, String var2, String var3, Handler<AsyncResult<HttpClientResponse>> var4);

    public HttpClientRequest get(String var1, String var2, Handler<AsyncResult<HttpClientResponse>> var3);

    public HttpClientRequest get(String var1);

    public HttpClientRequest get(String var1, Handler<AsyncResult<HttpClientResponse>> var2);

    public HttpClientRequest getAbs(String var1);

    public HttpClientRequest getAbs(String var1, Handler<AsyncResult<HttpClientResponse>> var2);

    @Fluent
    default public HttpClient getNow(RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.get(options, responseHandler);
        return this;
    }

    default public Future<HttpClientResponse> getNow(RequestOptions options) {
        HttpClientRequest request = this.get(options);
        request.end();
        return request;
    }

    @Fluent
    default public HttpClient getNow(int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.get(port, host, requestURI, responseHandler).end();
        return this;
    }

    default public Future<HttpClientResponse> getNow(int port, String host, String requestURI) {
        HttpClientRequest request = this.get(port, host, requestURI);
        request.end();
        return request;
    }

    @Fluent
    default public HttpClient getNow(String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.get(host, requestURI, responseHandler).end();
        return this;
    }

    default public Future<HttpClientResponse> getNow(String host, String requestURI) {
        HttpClientRequest request = this.get(host, requestURI);
        request.end();
        return request;
    }

    @Fluent
    default public HttpClient getNow(String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.get(requestURI, responseHandler).end();
        return this;
    }

    default public Future<HttpClientResponse> getNow(String requestURI) {
        HttpClientRequest request = this.get(requestURI);
        request.end();
        return request;
    }

    public HttpClientRequest post(RequestOptions var1);

    public HttpClientRequest post(int var1, String var2, String var3);

    public HttpClientRequest post(String var1, String var2);

    public HttpClientRequest post(RequestOptions var1, Handler<AsyncResult<HttpClientResponse>> var2);

    public HttpClientRequest post(int var1, String var2, String var3, Handler<AsyncResult<HttpClientResponse>> var4);

    public HttpClientRequest post(String var1, String var2, Handler<AsyncResult<HttpClientResponse>> var3);

    public HttpClientRequest post(String var1);

    public HttpClientRequest post(String var1, Handler<AsyncResult<HttpClientResponse>> var2);

    public HttpClientRequest postAbs(String var1);

    public HttpClientRequest postAbs(String var1, Handler<AsyncResult<HttpClientResponse>> var2);

    public HttpClientRequest head(RequestOptions var1);

    public HttpClientRequest head(int var1, String var2, String var3);

    public HttpClientRequest head(String var1, String var2);

    public HttpClientRequest head(RequestOptions var1, Handler<AsyncResult<HttpClientResponse>> var2);

    public HttpClientRequest head(int var1, String var2, String var3, Handler<AsyncResult<HttpClientResponse>> var4);

    public HttpClientRequest head(String var1, String var2, Handler<AsyncResult<HttpClientResponse>> var3);

    public HttpClientRequest head(String var1);

    public HttpClientRequest head(String var1, Handler<AsyncResult<HttpClientResponse>> var2);

    public HttpClientRequest headAbs(String var1);

    public HttpClientRequest headAbs(String var1, Handler<AsyncResult<HttpClientResponse>> var2);

    @Fluent
    default public HttpClient headNow(RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.head(options, responseHandler).end();
        return this;
    }

    default public Future<HttpClientResponse> headNow(RequestOptions options) {
        HttpClientRequest request = this.head(options);
        request.end();
        return request;
    }

    @Fluent
    default public HttpClient headNow(int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.head(port, host, requestURI, responseHandler).end();
        return this;
    }

    default public Future<HttpClientResponse> headNow(int port, String host, String requestURI) {
        HttpClientRequest request = this.head(port, host, requestURI);
        request.end();
        return request;
    }

    @Fluent
    default public HttpClient headNow(String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.head(host, requestURI, responseHandler).end();
        return this;
    }

    default public Future<HttpClientResponse> headNow(String host, String requestURI) {
        HttpClientRequest request = this.head(host, requestURI);
        request.end();
        return request;
    }

    @Fluent
    default public HttpClient headNow(String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.head(requestURI, responseHandler).end();
        return this;
    }

    default public Future<HttpClientResponse> headNow(String requestURI) {
        HttpClientRequest request = this.head(requestURI);
        request.end();
        return request;
    }

    public HttpClientRequest options(RequestOptions var1);

    public HttpClientRequest options(int var1, String var2, String var3);

    public HttpClientRequest options(String var1, String var2);

    public HttpClientRequest options(RequestOptions var1, Handler<AsyncResult<HttpClientResponse>> var2);

    public HttpClientRequest options(int var1, String var2, String var3, Handler<AsyncResult<HttpClientResponse>> var4);

    public HttpClientRequest options(String var1, String var2, Handler<AsyncResult<HttpClientResponse>> var3);

    public HttpClientRequest options(String var1);

    public HttpClientRequest options(String var1, Handler<AsyncResult<HttpClientResponse>> var2);

    public HttpClientRequest optionsAbs(String var1);

    public HttpClientRequest optionsAbs(String var1, Handler<AsyncResult<HttpClientResponse>> var2);

    @Fluent
    default public HttpClient optionsNow(RequestOptions options, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.options(options, responseHandler).end();
        return this;
    }

    default public Future<HttpClientResponse> optionsNow(RequestOptions options) {
        HttpClientRequest request = this.options(options);
        request.end();
        return request;
    }

    @Fluent
    default public HttpClient optionsNow(int port, String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.options(port, host, requestURI, responseHandler).end();
        return this;
    }

    default public Future<HttpClientResponse> optionsNow(int port, String host, String requestURI) {
        HttpClientRequest request = this.options(port, host, requestURI);
        request.end();
        return request;
    }

    @Fluent
    default public HttpClient optionsNow(String host, String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.options(host, requestURI, responseHandler).end();
        return this;
    }

    default public Future<HttpClientResponse> optionsNow(String host, String requestURI) {
        HttpClientRequest request = this.options(host, requestURI);
        request.end();
        return request;
    }

    @Fluent
    default public HttpClient optionsNow(String requestURI, Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.options(requestURI, responseHandler).end();
        return this;
    }

    default public Future<HttpClientResponse> optionsNow(String requestURI) {
        HttpClientRequest request = this.options(requestURI);
        request.end();
        return request;
    }

    public HttpClientRequest put(RequestOptions var1);

    public HttpClientRequest put(int var1, String var2, String var3);

    public HttpClientRequest put(String var1, String var2);

    public HttpClientRequest put(RequestOptions var1, Handler<AsyncResult<HttpClientResponse>> var2);

    public HttpClientRequest put(int var1, String var2, String var3, Handler<AsyncResult<HttpClientResponse>> var4);

    public HttpClientRequest put(String var1, String var2, Handler<AsyncResult<HttpClientResponse>> var3);

    public HttpClientRequest put(String var1);

    public HttpClientRequest put(String var1, Handler<AsyncResult<HttpClientResponse>> var2);

    public HttpClientRequest putAbs(String var1);

    public HttpClientRequest putAbs(String var1, Handler<AsyncResult<HttpClientResponse>> var2);

    public HttpClientRequest delete(RequestOptions var1);

    public HttpClientRequest delete(int var1, String var2, String var3);

    public HttpClientRequest delete(String var1, String var2);

    public HttpClientRequest delete(RequestOptions var1, Handler<AsyncResult<HttpClientResponse>> var2);

    public HttpClientRequest delete(int var1, String var2, String var3, Handler<AsyncResult<HttpClientResponse>> var4);

    public HttpClientRequest delete(String var1, String var2, Handler<AsyncResult<HttpClientResponse>> var3);

    public HttpClientRequest delete(String var1);

    public HttpClientRequest delete(String var1, Handler<AsyncResult<HttpClientResponse>> var2);

    public HttpClientRequest deleteAbs(String var1);

    public HttpClientRequest deleteAbs(String var1, Handler<AsyncResult<HttpClientResponse>> var2);

    public void webSocket(int var1, String var2, String var3, Handler<AsyncResult<WebSocket>> var4);

    public Future<WebSocket> webSocket(int var1, String var2, String var3);

    public void webSocket(String var1, String var2, Handler<AsyncResult<WebSocket>> var3);

    public Future<WebSocket> webSocket(String var1, String var2);

    public void webSocket(String var1, Handler<AsyncResult<WebSocket>> var2);

    public Future<WebSocket> webSocket(String var1);

    public void webSocket(WebSocketConnectOptions var1, Handler<AsyncResult<WebSocket>> var2);

    public Future<WebSocket> webSocket(WebSocketConnectOptions var1);

    public void webSocketAbs(String var1, MultiMap var2, WebsocketVersion var3, List<String> var4, Handler<AsyncResult<WebSocket>> var5);

    public Future<WebSocket> webSocketAbs(String var1, MultiMap var2, WebsocketVersion var3, List<String> var4);

    @Fluent
    public HttpClient connectionHandler(Handler<HttpConnection> var1);

    @Fluent
    public HttpClient redirectHandler(Function<HttpClientResponse, Future<HttpClientRequest>> var1);

    @GenIgnore
    public Function<HttpClientResponse, Future<HttpClientRequest>> redirectHandler();

    public void close();
}

