/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.impl.FrameType;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.WebSocketImplBase;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.PromiseInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.VertxHandler;

abstract class Http1xConnectionBase<S extends WebSocketImplBase<S>>
extends ConnectionBase
implements HttpConnection {
    protected S webSocket;
    protected long bytesWritten;
    private boolean closeFrameSent;

    Http1xConnectionBase(VertxInternal vertx, ChannelHandlerContext chctx, ContextInternal context) {
        super(vertx, chctx, context);
    }

    WebSocketFrame encodeFrame(WebSocketFrameImpl frame) {
        ByteBuf buf = frame.getBinaryData();
        if (buf != Unpooled.EMPTY_BUFFER) {
            buf = VertxHandler.safeBuffer(buf, this.chctx.alloc());
        }
        switch (frame.type()) {
            case BINARY: {
                return new BinaryWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case TEXT: {
                return new TextWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case CLOSE: {
                return new CloseWebSocketFrame(true, 0, buf);
            }
            case CONTINUATION: {
                return new ContinuationWebSocketFrame(frame.isFinal(), 0, buf);
            }
            case PONG: {
                return new PongWebSocketFrame(buf);
            }
            case PING: {
                return new PingWebSocketFrame(buf);
            }
        }
        throw new IllegalStateException("Unsupported websocket msg " + frame);
    }

    private WebSocketFrameInternal decodeFrame(WebSocketFrame msg) {
        FrameType frameType;
        ByteBuf payload = VertxHandler.safeBuffer((ByteBufHolder)msg, this.chctx.alloc());
        boolean isFinal = msg.isFinalFragment();
        if (msg instanceof BinaryWebSocketFrame) {
            frameType = FrameType.BINARY;
        } else if (msg instanceof CloseWebSocketFrame) {
            frameType = FrameType.CLOSE;
        } else if (msg instanceof PingWebSocketFrame) {
            frameType = FrameType.PING;
        } else if (msg instanceof PongWebSocketFrame) {
            frameType = FrameType.PONG;
        } else if (msg instanceof TextWebSocketFrame) {
            frameType = FrameType.TEXT;
        } else if (msg instanceof ContinuationWebSocketFrame) {
            frameType = FrameType.CONTINUATION;
        } else {
            throw new IllegalStateException("Unsupported websocket msg " + msg);
        }
        return new WebSocketFrameImpl(frameType, payload, isFinal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleWsFrame(WebSocketFrame msg) {
        S w;
        WebSocketFrameInternal frame = this.decodeFrame(msg);
        Http1xConnectionBase http1xConnectionBase = this;
        synchronized (http1xConnectionBase) {
            switch (frame.type()) {
                case PING: {
                    this.chctx.writeAndFlush((Object)new PongWebSocketFrame(frame.getBinaryData().copy()));
                    break;
                }
                case CLOSE: {
                    Http1xConnectionBase http1xConnectionBase2 = this;
                    synchronized (http1xConnectionBase2) {
                        if (!this.closeFrameSent) {
                            CloseWebSocketFrame closeFrame = new CloseWebSocketFrame((int)frame.closeStatusCode(), frame.closeReason());
                            this.chctx.writeAndFlush((Object)closeFrame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            this.closeFrameSent = true;
                        }
                        break;
                    }
                }
            }
            w = this.webSocket;
        }
        if (w != null) {
            this.reportBytesRead(frame.length());
            ((WebSocketImplBase)w).context.dispatchFromIO(frame, arg_0 -> w.handleFrame(arg_0));
        }
    }

    @Override
    public Future<Void> close() {
        return this.closeWithPayload((short)1000, null);
    }

    Future<Void> closeWithPayload(short code, String reason) {
        if (this.webSocket == null) {
            return super.close();
        }
        PromiseInternal promise = this.context.promise();
        ByteBuf byteBuf = HttpUtils.generateWSCloseFrameByteBuf(code, reason);
        CloseWebSocketFrame frame = new CloseWebSocketFrame(true, 0, byteBuf);
        ChannelPromise channelPromise = this.chctx.newPromise();
        this.flush(channelPromise);
        channelPromise.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            ChannelFuture fut = this.chctx.writeAndFlush((Object)frame);
            boolean server = this instanceof Http1xServerConnection;
            if (server) {
                fut.addListener((GenericFutureListener)((ChannelFutureListener)f -> this.chctx.channel().close().addListener((GenericFutureListener)promise)));
            } else {
                fut.addListener((GenericFutureListener)promise);
            }
        }));
        return promise.future();
    }

    @Override
    public Http1xConnectionBase closeHandler(Handler<Void> handler) {
        return (Http1xConnectionBase)super.closeHandler(handler);
    }

    @Override
    public Http1xConnectionBase exceptionHandler(Handler<Throwable> handler) {
        return (Http1xConnectionBase)super.exceptionHandler(handler);
    }

    @Override
    public HttpConnection goAway(long errorCode, int lastStreamId, Buffer debugData) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public HttpConnection goAwayHandler(@Nullable Handler<GoAway> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public HttpConnection shutdownHandler(@Nullable Handler<Void> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public HttpConnection shutdown() {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public HttpConnection shutdown(long timeoutMs) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public Http2Settings settings() {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public Future<Void> updateSettings(Http2Settings settings) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection updateSettings(Http2Settings settings, Handler<AsyncResult<Void>> completionHandler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public Http2Settings remoteSettings() {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection remoteSettingsHandler(Handler<Http2Settings> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection ping(Buffer data, Handler<AsyncResult<Buffer>> pongHandler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support PING");
    }

    @Override
    public HttpConnection pingHandler(@Nullable Handler<Buffer> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support PING");
    }

    @Override
    public Future<Buffer> ping(Buffer data) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support PING");
    }

    @Override
    protected void reportsBytesWritten(Object msg) {
        if (msg instanceof HttpObject || msg instanceof FileRegion || msg instanceof ChunkedFile) {
            this.bytesWritten += Http1xConnectionBase.getBytes(msg);
        } else if (msg instanceof WebSocketFrame) {
            this.reportBytesWritten(Http1xConnectionBase.getBytes(msg));
        }
    }

    static long getBytes(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Buffer) {
            return ((Buffer)obj).length();
        }
        if (obj instanceof ByteBuf) {
            return ((ByteBuf)obj).readableBytes();
        }
        if (obj instanceof HttpContent) {
            return ((HttpContent)obj).content().readableBytes();
        }
        if (obj instanceof WebSocketFrame) {
            return ((WebSocketFrame)obj).content().readableBytes();
        }
        if (obj instanceof FileRegion) {
            return ((FileRegion)obj).count();
        }
        if (obj instanceof ChunkedFile) {
            ChunkedFile file = (ChunkedFile)obj;
            return file.endOffset() - file.startOffset();
        }
        return -1L;
    }
}

