/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.NoStackTraceThrowable;

public class FailedFuture<T>
implements Future<T> {
    private final ContextInternal context;
    private final Throwable cause;

    FailedFuture(ContextInternal context, Throwable t) {
        this.context = context;
        this.cause = t != null ? t : new NoStackTraceThrowable(null);
    }

    FailedFuture(ContextInternal context, String failureMessage) {
        this(context, new NoStackTraceThrowable(failureMessage));
    }

    @Override
    public ContextInternal context() {
        return this.context;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public Future<T> onComplete(Handler<AsyncResult<T>> handler) {
        handler.handle(this);
        return this;
    }

    @Override
    public Handler<AsyncResult<T>> getHandler() {
        return null;
    }

    @Override
    public T result() {
        return null;
    }

    @Override
    public Throwable cause() {
        return this.cause;
    }

    @Override
    public boolean succeeded() {
        return false;
    }

    @Override
    public boolean failed() {
        return true;
    }

    public String toString() {
        return "Future{cause=" + this.cause.getMessage() + "}";
    }
}

