/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.json.jackson.JacksonFactory;
import io.vertx.core.spi.json.JsonCodec;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JacksonCodec
implements JsonCodec {
    private static final JsonFactory factory = new JsonFactory();

    @Override
    public <T> T fromString(String json, Class<T> clazz) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(json), clazz);
    }

    public <T> T fromString(String str, TypeReference<T> typeRef) throws DecodeException {
        return this.fromString(str, JacksonCodec.classTypeOf(typeRef));
    }

    @Override
    public <T> T fromBuffer(Buffer json, Class<T> clazz) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(json), clazz);
    }

    public <T> T fromBuffer(Buffer buf, TypeReference<T> typeRef) throws DecodeException {
        return this.fromBuffer(buf, JacksonCodec.classTypeOf(typeRef));
    }

    @Override
    public <T> T fromValue(Object json, Class<T> toValueType) {
        throw new UnsupportedOperationException("Mapping is not available without Jackson Databind on the classpath");
    }

    public <T> T fromValue(Object json, TypeReference<T> type) {
        throw new UnsupportedOperationException("Mapping is not available without Jackson Databind on the classpath");
    }

    @Override
    public String toString(Object object, boolean pretty) throws EncodeException {
        StringWriter sw = new StringWriter();
        JsonGenerator generator = JacksonCodec.createGenerator(sw, pretty);
        try {
            JacksonCodec.encodeJson(object, generator);
            generator.flush();
            String string = sw.toString();
            return string;
        }
        catch (IOException e) {
            throw new EncodeException(e.getMessage(), e);
        }
        finally {
            JacksonCodec.close((Closeable)generator);
        }
    }

    @Override
    public Buffer toBuffer(Object object, boolean pretty) throws EncodeException {
        ByteBuf buf = Unpooled.buffer();
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        JsonGenerator generator = JacksonCodec.createGenerator((OutputStream)out, pretty);
        try {
            JacksonCodec.encodeJson(object, generator);
            generator.flush();
            Buffer buffer = Buffer.buffer(buf);
            return buffer;
        }
        catch (IOException e) {
            throw new EncodeException(e.getMessage(), e);
        }
        finally {
            JacksonCodec.close((Closeable)generator);
        }
    }

    public static JsonParser createParser(String str) {
        try {
            return factory.createParser(str);
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    public static JsonParser createParser(Buffer buf) {
        try {
            return factory.createParser((InputStream)new ByteBufInputStream(buf.getByteBuf()));
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    private static JsonGenerator createGenerator(Writer out, boolean pretty) {
        try {
            JsonGenerator generator = factory.createGenerator(out);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            return generator;
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    private static JsonGenerator createGenerator(OutputStream out, boolean pretty) {
        try {
            JsonGenerator generator = factory.createGenerator(out);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            return generator;
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    public Object fromString(String str) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(str), Object.class);
    }

    public Object fromBuffer(Buffer buf) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(buf), Object.class);
    }

    public static <T> T fromParser(JsonParser parser, Class<T> type) throws DecodeException {
        try {
            parser.nextToken();
            Object res = JacksonCodec.parseAny(parser);
            T t = JacksonCodec.cast(res, type);
            return t;
        }
        catch (IOException e) {
            throw new DecodeException(e.getMessage(), e);
        }
        finally {
            JacksonCodec.close((Closeable)parser);
        }
    }

    private static Object parseAny(JsonParser parser) throws IOException, DecodeException {
        switch (parser.getCurrentTokenId()) {
            case 1: {
                return JacksonCodec.parseObject(parser);
            }
            case 3: {
                return JacksonCodec.parseArray(parser);
            }
            case 6: {
                return parser.getText();
            }
            case 7: 
            case 8: {
                return parser.getNumberValue();
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
        }
        throw new DecodeException("Unexpected token");
    }

    private static Map<String, Object> parseObject(JsonParser parser) throws IOException {
        String key1 = parser.nextFieldName();
        if (key1 == null) {
            return new LinkedHashMap<String, Object>(2);
        }
        parser.nextToken();
        Object value1 = JacksonCodec.parseAny(parser);
        String key2 = parser.nextFieldName();
        if (key2 == null) {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>(2);
            obj.put(key1, value1);
            return obj;
        }
        parser.nextToken();
        Object value2 = JacksonCodec.parseAny(parser);
        String key = parser.nextFieldName();
        if (key == null) {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>(2);
            obj.put(key1, value1);
            obj.put(key2, value2);
            return obj;
        }
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put(key1, value1);
        obj.put(key2, value2);
        do {
            parser.nextToken();
            Object value = JacksonCodec.parseAny(parser);
            obj.put(key, value);
        } while ((key = parser.nextFieldName()) != null);
        return obj;
    }

    private static List<Object> parseArray(JsonParser parser) throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        while (true) {
            parser.nextToken();
            int tokenId = parser.getCurrentTokenId();
            if (tokenId == 5) {
                throw new UnsupportedOperationException();
            }
            if (tokenId == 4) {
                return array;
            }
            Object value = JacksonCodec.parseAny(parser);
            array.add(value);
        }
    }

    static void close(Closeable parser) {
        try {
            parser.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void encodeJson(Object json, JsonGenerator generator) throws EncodeException {
        block20: {
            try {
                if (json instanceof JsonObject) {
                    json = ((JsonObject)json).getMap();
                } else if (json instanceof JsonArray) {
                    json = ((JsonArray)json).getList();
                }
                if (json instanceof Map) {
                    generator.writeStartObject();
                    for (Map.Entry e : ((Map)json).entrySet()) {
                        generator.writeFieldName((String)e.getKey());
                        JacksonCodec.encodeJson(e.getValue(), generator);
                    }
                    generator.writeEndObject();
                    break block20;
                }
                if (json instanceof List) {
                    generator.writeStartArray();
                    for (Object item : (List)json) {
                        JacksonCodec.encodeJson(item, generator);
                    }
                    generator.writeEndArray();
                    break block20;
                }
                if (json instanceof CharSequence) {
                    generator.writeString(((CharSequence)json).toString());
                    break block20;
                }
                if (json instanceof Number) {
                    if (json instanceof Short) {
                        generator.writeNumber(((Short)json).shortValue());
                        break block20;
                    }
                    if (json instanceof Integer) {
                        generator.writeNumber(((Integer)json).intValue());
                        break block20;
                    }
                    if (json instanceof Long) {
                        generator.writeNumber(((Long)json).longValue());
                        break block20;
                    }
                    if (json instanceof Float) {
                        generator.writeNumber(((Float)json).floatValue());
                        break block20;
                    }
                    if (json instanceof Double) {
                        generator.writeNumber(((Double)json).doubleValue());
                        break block20;
                    }
                    throw new UnsupportedOperationException();
                }
                if (json instanceof Boolean) {
                    generator.writeBoolean(((Boolean)json).booleanValue());
                    break block20;
                }
                if (json instanceof Instant) {
                    generator.writeString(DateTimeFormatter.ISO_INSTANT.format((Instant)json));
                    break block20;
                }
                if (json instanceof byte[]) {
                    generator.writeString(JsonUtil.BASE64_ENCODER.encodeToString((byte[])json));
                    break block20;
                }
                if (json == null) {
                    generator.writeNull();
                    break block20;
                }
                throw new UnsupportedOperationException();
            }
            catch (IOException e) {
                throw new EncodeException(e.getMessage(), e);
            }
        }
    }

    private static <T> Class<T> classTypeOf(TypeReference<T> typeRef) {
        Type type = typeRef.getType();
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        throw new DecodeException();
    }

    private static <T> T cast(Object o, Class<T> clazz) {
        if (o instanceof Map) {
            if (!clazz.isAssignableFrom(Map.class)) {
                throw new DecodeException("Failed to decode");
            }
            if (clazz == Object.class) {
                o = new JsonObject((Map)o);
            }
            return clazz.cast(o);
        }
        if (o instanceof List) {
            if (!clazz.isAssignableFrom(List.class)) {
                throw new DecodeException("Failed to decode");
            }
            if (clazz == Object.class) {
                o = new JsonArray((List)o);
            }
            return clazz.cast(o);
        }
        if (o instanceof String) {
            if (!clazz.isAssignableFrom(String.class)) {
                throw new DecodeException("Failed to decode");
            }
            return clazz.cast(o);
        }
        if (o instanceof Boolean) {
            if (!clazz.isAssignableFrom(Boolean.class)) {
                throw new DecodeException("Failed to decode");
            }
            return clazz.cast(o);
        }
        if (o == null) {
            return null;
        }
        Number number = (Number)o;
        if (clazz == Integer.class) {
            o = number.intValue();
        } else if (clazz == Long.class) {
            o = number.longValue();
        } else if (clazz == Float.class) {
            o = Float.valueOf(number.floatValue());
        } else if (clazz == Double.class) {
            o = number.doubleValue();
        } else if (clazz == Byte.class) {
            o = number.byteValue();
        } else if (clazz == Short.class) {
            o = number.shortValue();
        } else if (clazz != Object.class && !clazz.isAssignableFrom(Number.class)) {
            throw new DecodeException("Failed to decode");
        }
        return clazz.cast(o);
    }

    public static <T> T decodeValue(String str, TypeReference<T> type) throws DecodeException {
        return JacksonFactory.CODEC.fromString(str, type);
    }

    public static <T> T decodeValue(Buffer buf, TypeReference<T> type) throws DecodeException {
        return JacksonFactory.CODEC.fromBuffer(buf, type);
    }

    static {
        factory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }
}

