/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.PromiseInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ChannelProvider;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import java.io.FileNotFoundException;
import java.net.ConnectException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class NetClientImpl
implements MetricsProvider,
NetClient {
    private static final Logger log = LoggerFactory.getLogger(NetClientImpl.class);
    protected final int idleTimeout;
    private final TimeUnit idleTimeoutUnit;
    protected final boolean logEnabled;
    private final VertxInternal vertx;
    private final NetClientOptions options;
    protected final SSLHelper sslHelper;
    private final Map<Channel, NetSocketImpl> socketMap = new ConcurrentHashMap<Channel, NetSocketImpl>();
    private final Closeable closeHook;
    private final ContextInternal creatingContext;
    private final TCPMetrics metrics;
    private volatile boolean closed;

    public NetClientImpl(VertxInternal vertx, NetClientOptions options) {
        this(vertx, options, true);
    }

    public NetClientImpl(VertxInternal vertx, NetClientOptions options, boolean useCreatingContext) {
        VertxMetrics metrics;
        this.vertx = vertx;
        this.options = new NetClientOptions(options);
        this.sslHelper = new SSLHelper(options, options.getKeyCertOptions(), options.getTrustOptions());
        this.closeHook = completionHandler -> {
            this.close();
            completionHandler.handle(Future.succeededFuture());
        };
        if (useCreatingContext) {
            this.creatingContext = vertx.getContext();
            if (this.creatingContext != null) {
                this.creatingContext.addCloseHook(this.closeHook);
            }
        } else {
            this.creatingContext = null;
        }
        this.metrics = (metrics = vertx.metricsSPI()) != null ? metrics.createNetClientMetrics(options) : null;
        this.logEnabled = options.getLogActivity();
        this.idleTimeout = options.getIdleTimeout();
        this.idleTimeoutUnit = options.getIdleTimeoutUnit();
    }

    protected void initChannel(ChannelPipeline pipeline) {
        if (this.logEnabled) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        if (this.sslHelper.isSSL()) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (this.idleTimeout > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0L, 0L, (long)this.idleTimeout, this.idleTimeoutUnit));
        }
    }

    @Override
    public Future<NetSocket> connect(int port, String host) {
        return this.connect(port, host, (String)null);
    }

    @Override
    public Future<NetSocket> connect(int port, String host, String serverName) {
        return this.connect(SocketAddress.inetSocketAddress(port, host), serverName);
    }

    @Override
    public Future<NetSocket> connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, (String)null);
    }

    @Override
    public Future<NetSocket> connect(SocketAddress remoteAddress, String serverName) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        PromiseInternal<NetSocket> promise = ctx.promise();
        this.doConnect(remoteAddress, serverName, promise, ctx);
        return promise.future();
    }

    @Override
    public NetClient connect(int port, String host, Handler<AsyncResult<NetSocket>> connectHandler) {
        return this.connect(port, host, null, connectHandler);
    }

    @Override
    public NetClient connect(int port, String host, String serverName, Handler<AsyncResult<NetSocket>> connectHandler) {
        return this.connect(SocketAddress.inetSocketAddress(port, host), serverName, connectHandler);
    }

    @Override
    public void close() {
        if (!this.closed) {
            for (NetSocketImpl sock : this.socketMap.values()) {
                sock.close();
            }
            if (this.creatingContext != null) {
                this.creatingContext.removeCloseHook(this.closeHook);
            }
            this.closed = true;
            if (this.metrics != null) {
                this.metrics.close();
            }
        }
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Client is closed");
        }
    }

    private void applyConnectionOptions(boolean domainSocket, Bootstrap bootstrap) {
        this.vertx.transport().configure(this.options, domainSocket, bootstrap);
    }

    @Override
    public NetClient connect(SocketAddress remoteAddress, String serverName, Handler<AsyncResult<NetSocket>> connectHandler) {
        Objects.requireNonNull(connectHandler, "No null connectHandler accepted");
        ContextInternal ctx = this.vertx.getOrCreateContext();
        PromiseInternal<NetSocket> promise = ctx.promise();
        promise.future().setHandler(connectHandler);
        this.doConnect(remoteAddress, serverName, promise, ctx);
        return this;
    }

    @Override
    public NetClient connect(SocketAddress remoteAddress, Handler<AsyncResult<NetSocket>> connectHandler) {
        return this.connect(remoteAddress, null, connectHandler);
    }

    private void doConnect(SocketAddress remoteAddress, String serverName, Promise<NetSocket> connectHandler, ContextInternal ctx) {
        this.doConnect(remoteAddress, serverName, connectHandler, ctx, this.options.getReconnectAttempts());
    }

    private void doConnect(SocketAddress remoteAddress, String serverName, Promise<NetSocket> connectHandler, ContextInternal context, int remainingAttempts) {
        this.checkClosed();
        Objects.requireNonNull(connectHandler, "No null connectHandler accepted");
        this.sslHelper.validate(this.vertx);
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)context.nettyEventLoop());
        this.applyConnectionOptions(remoteAddress.path() != null, bootstrap);
        ChannelProvider channelProvider = new ChannelProvider(bootstrap, this.sslHelper, context, this.options.getProxyOptions());
        SocketAddress peerAddress = remoteAddress;
        String peerHost = peerAddress.host();
        if (peerHost != null && peerHost.endsWith(".")) {
            peerAddress = SocketAddress.inetSocketAddress(peerAddress.port(), peerHost.substring(0, peerHost.length() - 1));
        }
        io.netty.util.concurrent.Future<Channel> fut = channelProvider.connect(remoteAddress, peerAddress, serverName, this.sslHelper.isSSL());
        fut.addListener(future -> {
            if (future.isSuccess()) {
                Channel ch = (Channel)future.getNow();
                this.connected(context, ch, connectHandler, remoteAddress);
            } else {
                boolean connectError;
                Throwable cause = future.cause();
                boolean bl = connectError = cause instanceof ConnectException || cause instanceof FileNotFoundException;
                if (connectError && (remainingAttempts > 0 || remainingAttempts == -1)) {
                    context.dispatchFromIO(v -> {
                        log.debug("Failed to create connection. Will retry in " + this.options.getReconnectInterval() + " milliseconds");
                        this.vertx.setTimer(this.options.getReconnectInterval(), tid -> this.doConnect(remoteAddress, serverName, connectHandler, context, remainingAttempts == -1 ? remainingAttempts : remainingAttempts - 1));
                    });
                } else {
                    this.failed(context, null, cause, connectHandler);
                }
            }
        });
    }

    private void connected(ContextInternal context, Channel ch, Promise<NetSocket> connectHandler, SocketAddress remoteAddress) {
        this.initChannel(ch.pipeline());
        VertxHandler<NetSocketImpl> handler = VertxHandler.create(ctx -> new NetSocketImpl(this.vertx, (ChannelHandlerContext)ctx, remoteAddress, context, this.sslHelper, this.metrics));
        handler.addHandler(sock -> {
            this.socketMap.put(ch, (NetSocketImpl)sock);
            if (this.metrics != null) {
                sock.metric(this.metrics.connected(sock.remoteAddress(), sock.remoteName()));
            }
            sock.registerEventBusHandler();
            context.dispatchFromIO(sock, connectHandler::complete);
        });
        handler.removeHandler(conn -> this.socketMap.remove(ch));
        ch.pipeline().addLast("handler", handler);
    }

    private void failed(ContextInternal context, Channel ch, Throwable th, Promise<NetSocket> connectHandler) {
        if (ch != null) {
            ch.close();
        }
        context.dispatchFromIO(th, connectHandler::tryFail);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

