/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.VertxHttp2Stream;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.PromiseInternal;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import java.nio.charset.Charset;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

class VertxHttp2NetSocket<C extends Http2ConnectionBase>
extends VertxHttp2Stream<C>
implements NetSocket {
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private Handler<Void> endHandler;
    private Handler<Buffer> dataHandler;
    private Handler<Void> drainHandler;

    public VertxHttp2NetSocket(C conn, ContextInternal context) {
        super(conn, context);
    }

    @Override
    void handleEnd(MultiMap trailers) {
        try {
            Handler<Void> handler = this.endHandler();
            if (handler != null) {
                handler.handle(null);
            }
        }
        finally {
            this.end();
        }
    }

    @Override
    void handleData(Buffer buf) {
        Handler<Buffer> handler = this.handler();
        if (handler != null) {
            handler.handle(buf);
        }
    }

    @Override
    void handleReset(long errorCode) {
        this.handleException(new StreamResetException(errorCode));
    }

    @Override
    void handleException(Throwable cause) {
        Handler<Throwable> handler = this.exceptionHandler();
        if (handler != null) {
            handler.handle(cause);
        }
    }

    @Override
    void handleClose() {
        super.handleClose();
        Handler<Void> handler = this.closeHandler();
        if (handler != null) {
            handler.handle(null);
        }
    }

    @Override
    void handleWritabilityChanged(boolean writable) {
        Handler<Void> handler = this.drainHandler();
        if (handler != null && writable) {
            handler.handle(null);
        }
    }

    @Override
    void handlePriorityChange(StreamPriority newPriority) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket exceptionHandler(Handler<Throwable> handler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.exceptionHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Handler<Throwable> exceptionHandler() {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            return this.exceptionHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket handler(Handler<Buffer> handler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.dataHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Handler<Buffer> handler() {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            return this.dataHandler;
        }
    }

    @Override
    public NetSocket fetch(long amount) {
        this.doFetch(amount);
        return this;
    }

    @Override
    public NetSocket pause() {
        this.doPause();
        return this;
    }

    @Override
    public NetSocket resume() {
        return this.fetch(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket endHandler(Handler<Void> handler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.endHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Handler<Void> endHandler() {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            return this.endHandler;
        }
    }

    @Override
    public NetSocket setWriteQueueMaxSize(int maxSize) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket drainHandler(Handler<Void> handler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.drainHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Handler<Void> drainHandler() {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            return this.drainHandler;
        }
    }

    @Override
    public boolean writeQueueFull() {
        return this.isNotWritable();
    }

    @Override
    public String writeHandlerID() {
        return null;
    }

    private Future<Void> write(ByteBuf data, boolean end) {
        PromiseInternal<Void> promise = this.context.promise();
        this.writeData(data, end, promise);
        return promise.future();
    }

    @Override
    public Future<Void> write(Buffer data) {
        return this.write(data.getByteBuf(), false);
    }

    @Override
    public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.write(data);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    @Override
    public Future<Void> write(String str, String enc) {
        Charset cs = enc != null ? Charset.forName(enc) : CharsetUtil.UTF_8;
        return this.write(Unpooled.copiedBuffer((CharSequence)str, (Charset)cs), false);
    }

    @Override
    public void write(String str, String enc, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.write(str, enc);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    @Override
    public Future<Void> write(String str) {
        return this.write(str, (String)null);
    }

    @Override
    public void write(String str, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.write(str);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    @Override
    public Future<Void> end(Buffer data) {
        return this.write(data.getByteBuf(), true);
    }

    @Override
    public void end(Buffer buffer, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.end(buffer);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    @Override
    public Future<Void> end() {
        return this.write(Unpooled.EMPTY_BUFFER, true);
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.end();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    @Override
    public Future<Void> sendFile(String filename, long offset, long length) {
        PromiseInternal<Void> promise = this.context.promise();
        this.sendFile(filename, offset, length, promise);
        return promise.future();
    }

    @Override
    public NetSocket sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        Handler<AsyncResult> h;
        if (resultHandler != null) {
            ContextInternal resultCtx = this.vertx.getOrCreateContext();
            h = ar -> resultCtx.runOnContext(v -> resultHandler.handle((AsyncResult<Void>)ar));
        } else {
            h = ar -> {};
        }
        this.resolveFile(filename, offset, length, ar -> {
            if (ar.succeeded()) {
                AsyncFile file = (AsyncFile)ar.result();
                file.pipeTo(this, ar1 -> file.close(ar2 -> {
                    Throwable failure;
                    Throwable throwable = ar1.failed() ? ar1.cause() : (failure = ar2.failed() ? ar2.cause() : null);
                    if (failure == null) {
                        h.handle((AsyncResult)ar1);
                    } else {
                        h.handle(Future.failedFuture(failure));
                    }
                }));
            } else {
                h.handle(ar.mapEmpty());
            }
        });
        return this;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.conn.remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.conn.localAddress();
    }

    @Override
    public Future<Void> close() {
        return this.end();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.end(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetSocket closeHandler(@Nullable Handler<Void> handler) {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            this.closeHandler = handler;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Handler<Void> closeHandler() {
        Http2ConnectionBase http2ConnectionBase = this.conn;
        synchronized (http2ConnectionBase) {
            return this.closeHandler;
        }
    }

    @Override
    public NetSocket upgradeToSsl(Handler<AsyncResult<Void>> handler) {
        throw new UnsupportedOperationException("Cannot upgrade HTTP/2 stream to SSL");
    }

    @Override
    public NetSocket upgradeToSsl(String serverName, Handler<AsyncResult<Void>> handler) {
        throw new UnsupportedOperationException("Cannot upgrade HTTP/2 stream to SSL");
    }

    @Override
    public Future<Void> upgradeToSsl() {
        return Future.failedFuture("Cannot upgrade HTTP/2 stream to SSL");
    }

    @Override
    public Future<Void> upgradeToSsl(String serverName) {
        return Future.failedFuture("Cannot upgrade HTTP/2 stream to SSL");
    }

    @Override
    public boolean isSsl() {
        return this.conn.isSsl();
    }

    @Override
    public SSLSession sslSession() {
        return this.conn.sslSession();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.conn.peerCertificateChain();
    }

    @Override
    public String indicatedServerName() {
        return this.conn.indicatedServerName();
    }
}

