/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.JsonSchemaValidationException;
import io.vertx.json.schema.OutputUnitConverter;
import io.vertx.json.schema.ValidationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@DataObject
@JsonGen(publicConverter=false)
public class OutputUnit {
    private Boolean valid;
    private String absoluteKeywordLocation;
    private String keywordLocation;
    private String instanceLocation;
    private String error;
    private List<OutputUnit> errors;
    private List<OutputUnit> annotations;

    public OutputUnit() {
    }

    public OutputUnit(JsonObject json) {
        OutputUnitConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public OutputUnit(boolean valid) {
        this.valid = valid;
    }

    public OutputUnit(String instanceLocation, String absoluteKeywordLocation, String keywordLocation, String error) {
        this.instanceLocation = instanceLocation;
        this.absoluteKeywordLocation = absoluteKeywordLocation;
        this.keywordLocation = keywordLocation;
        this.error = error;
    }

    public Boolean getValid() {
        return this.valid;
    }

    public OutputUnit setValid(Boolean valid) {
        this.valid = valid;
        return this;
    }

    public String getAbsoluteKeywordLocation() {
        return this.absoluteKeywordLocation;
    }

    public OutputUnit setAbsoluteKeywordLocation(String absoluteKeywordLocation) {
        this.absoluteKeywordLocation = absoluteKeywordLocation;
        return this;
    }

    public String getKeywordLocation() {
        return this.keywordLocation;
    }

    public OutputUnit setKeywordLocation(String keywordLocation) {
        this.keywordLocation = keywordLocation;
        return this;
    }

    public String getInstanceLocation() {
        return this.instanceLocation;
    }

    public OutputUnit setInstanceLocation(String instanceLocation) {
        this.instanceLocation = instanceLocation;
        return this;
    }

    public String getError() {
        return this.error;
    }

    public OutputUnit setError(String error) {
        this.error = error;
        return this;
    }

    public List<OutputUnit> getErrors() {
        return this.errors;
    }

    public OutputUnit setErrors(List<OutputUnit> errors) {
        this.errors = errors;
        return this;
    }

    public OutputUnit addError(OutputUnit error) {
        if (this.errors == null) {
            this.errors = new ArrayList<OutputUnit>();
            this.valid = false;
        }
        this.errors.add(error);
        return this;
    }

    @GenIgnore
    public OutputUnit addErrors(List<OutputUnit> errors) {
        if (this.errors == null) {
            this.errors = new ArrayList<OutputUnit>();
            this.valid = false;
        }
        return this;
    }

    public List<OutputUnit> getAnnotations() {
        return this.annotations;
    }

    public OutputUnit setAnnotations(List<OutputUnit> annotations) {
        this.annotations = annotations;
        return this;
    }

    public OutputUnit addAnnotation(OutputUnit annotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<OutputUnit>();
        }
        this.annotations.add(annotation);
        return this;
    }

    @GenIgnore
    public OutputUnit addAnnotations(List<OutputUnit> annotations) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<OutputUnit>();
        }
        this.annotations.addAll(annotations);
        return this;
    }

    public void checkValidity() throws JsonSchemaValidationException {
        String msg = this.getError();
        if (this.valid == null) {
            String location = this.getAbsoluteKeywordLocation();
            throw new JsonSchemaValidationException(msg == null ? "JsonSchema Validation error" : msg, location, this.createStackTraceElement());
        }
        if (!this.valid.booleanValue()) {
            if (this.errors == null || this.errors.isEmpty()) {
                String location = this.getAbsoluteKeywordLocation();
                throw new JsonSchemaValidationException(msg == null ? "JsonSchema Validation error" : msg, location, this.createStackTraceElement());
            }
            JsonSchemaValidationException lastException = null;
            for (OutputUnit error : this.errors) {
                JsonSchemaValidationException cause;
                String location = error.getAbsoluteKeywordLocation();
                lastException = cause = new JsonSchemaValidationException(error.getError(), lastException, location, error.createStackTraceElement());
            }
            if (msg == null) {
                throw lastException;
            }
            throw new JsonSchemaValidationException(msg, lastException, this.getAbsoluteKeywordLocation());
        }
    }

    private StackTraceElement createStackTraceElement() {
        if (this.instanceLocation == null && this.keywordLocation == null) {
            return null;
        }
        return new StackTraceElement("[" + this.keywordLocation + "]", "<" + this.instanceLocation + ">", this.absoluteKeywordLocation, -1);
    }

    @GenIgnore
    public ValidationException toException(Object input) {
        return new ValidationException(this.error + ": { errors: " + this.formatExceptions(this.errors) + ", annotations: " + this.formatExceptions(this.annotations) + "}", this.absoluteKeywordLocation, input, true){};
    }

    private String formatExceptions(List<OutputUnit> units) {
        if (units == null) {
            return "[]";
        }
        return "[" + units.stream().filter(Objects::nonNull).map(OutputUnit::toString).collect(Collectors.joining(", ")) + "]";
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        OutputUnitConverter.toJson(this, json);
        return json;
    }

    public String toString() {
        return this.toJson().encode();
    }
}

