/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.common;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.client.common.Node;
import io.vertx.kafka.client.common.PartitionInfo;
import java.util.ArrayList;

public class PartitionInfoConverter {
    public static void fromJson(JsonObject json, PartitionInfo obj) {
        ArrayList<Node> list;
        if (json.getValue("inSyncReplicas") instanceof JsonArray) {
            list = new ArrayList<Node>();
            json.getJsonArray("inSyncReplicas").forEach(item -> {
                if (item instanceof JsonObject) {
                    list.add(new Node((JsonObject)item));
                }
            });
            obj.setInSyncReplicas(list);
        }
        if (json.getValue("leader") instanceof JsonObject) {
            obj.setLeader(new Node((JsonObject)json.getValue("leader")));
        }
        if (json.getValue("partition") instanceof Number) {
            obj.setPartition(((Number)json.getValue("partition")).intValue());
        }
        if (json.getValue("replicas") instanceof JsonArray) {
            list = new ArrayList();
            json.getJsonArray("replicas").forEach(item -> {
                if (item instanceof JsonObject) {
                    list.add(new Node((JsonObject)item));
                }
            });
            obj.setReplicas(list);
        }
        if (json.getValue("topic") instanceof String) {
            obj.setTopic((String)json.getValue("topic"));
        }
    }

    public static void toJson(PartitionInfo obj, JsonObject json) {
        JsonArray array;
        if (obj.getInSyncReplicas() != null) {
            array = new JsonArray();
            obj.getInSyncReplicas().forEach(item -> array.add(item.toJson()));
            json.put("inSyncReplicas", array);
        }
        if (obj.getLeader() != null) {
            json.put("leader", obj.getLeader().toJson());
        }
        json.put("partition", Integer.valueOf(obj.getPartition()));
        if (obj.getReplicas() != null) {
            array = new JsonArray();
            obj.getReplicas().forEach(item -> array.add(item.toJson()));
            json.put("replicas", array);
        }
        if (obj.getTopic() != null) {
            json.put("topic", obj.getTopic());
        }
    }
}

