/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@DataObject
public class MailAttachment {
    private Buffer data;
    private String name;
    private String contentType;
    private String disposition;
    private String description;

    public MailAttachment() {
    }

    public MailAttachment(MailAttachment other) {
        Objects.requireNonNull(other);
        this.data = other.data == null ? null : other.data.copy();
        this.name = other.name;
        this.contentType = other.contentType;
        this.disposition = other.disposition;
        this.description = other.description;
    }

    public MailAttachment(JsonObject json) {
        Objects.requireNonNull(json);
        this.data = json.getBinary("data") == null ? null : Buffer.buffer((byte[])json.getBinary("data"));
        this.name = json.getString("name");
        this.contentType = json.getString("contentType");
        this.disposition = json.getString("disposition");
        this.description = json.getString("description");
    }

    public Buffer getData() {
        return this.data;
    }

    public MailAttachment setData(Buffer data) {
        this.data = data;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public MailAttachment setName(String name) {
        this.name = name;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public MailAttachment setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public MailAttachment setDisposition(String disposition) {
        this.disposition = disposition;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public MailAttachment setDescription(String description) {
        this.description = description;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.data != null) {
            this.putIfNotNull(json, "data", this.data.getBytes());
        }
        this.putIfNotNull(json, "name", this.name);
        this.putIfNotNull(json, "contentType", this.contentType);
        this.putIfNotNull(json, "disposition", this.disposition);
        this.putIfNotNull(json, "description", this.description);
        return json;
    }

    private List<Object> getList() {
        return Arrays.asList(this.data, this.name, this.disposition, this.description);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MailAttachment)) {
            return false;
        }
        MailAttachment attachment = (MailAttachment)o;
        return this.getList().equals(attachment.getList());
    }

    public int hashCode() {
        return this.getList().hashCode();
    }

    private void putIfNotNull(JsonObject json, String key, Object value) {
        if (value != null) {
            json.put(key, value);
        }
    }
}

