/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.MultiMap;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mail.MailAttachment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@DataObject
public class MailMessage {
    private String bounceAddress;
    private String from;
    private List<String> to = null;
    private List<String> cc = null;
    private List<String> bcc = null;
    private String subject;
    private String text;
    private String html;
    private List<MailAttachment> attachment;
    private MultiMap headers = null;
    private boolean fixedHeaders = false;

    public MailMessage() {
    }

    public MailMessage(MailMessage other) {
        Objects.requireNonNull(other);
        this.bounceAddress = other.bounceAddress;
        this.from = other.from;
        this.to = this.copyList(other.to);
        this.cc = this.copyList(other.cc);
        this.bcc = this.copyList(other.bcc);
        this.subject = other.subject;
        this.text = other.text;
        this.html = other.html;
        if (other.attachment != null) {
            ArrayList<MailAttachment> newList = new ArrayList<MailAttachment>(other.attachment.size());
            for (MailAttachment a : other.attachment) {
                newList.add(new MailAttachment(a));
            }
            this.attachment = newList;
        }
        if (other.headers != null) {
            this.headers = new CaseInsensitiveHeaders().addAll(other.headers);
        }
    }

    public MailMessage(JsonObject json) {
        Objects.requireNonNull(json);
        this.bounceAddress = json.getString("bounceAddress");
        this.from = json.getString("from");
        this.to = this.getKeyAsStringOrList(json, "to");
        this.cc = this.getKeyAsStringOrList(json, "cc");
        this.bcc = this.getKeyAsStringOrList(json, "bcc");
        this.subject = json.getString("subject");
        this.text = json.getString("text");
        this.html = json.getString("html");
        if (json.containsKey("attachment")) {
            List<MailAttachment> list;
            Object object = json.getValue("attachment");
            if (object instanceof JsonObject) {
                list = Collections.singletonList(new MailAttachment((JsonObject)object));
            } else if (object instanceof JsonArray) {
                list = new ArrayList<MailAttachment>();
                for (Object attach : (JsonArray)object) {
                    list.add(new MailAttachment((JsonObject)attach));
                }
            } else {
                throw new IllegalArgumentException("invalid attachment type");
            }
            this.attachment = list;
        }
        if (json.containsKey("headers")) {
            this.headers = this.jsonToMultiMap(json);
        }
    }

    private MultiMap jsonToMultiMap(JsonObject json) {
        JsonObject jsonHeaders = json.getJsonObject("headers");
        CaseInsensitiveHeaders headers = new CaseInsensitiveHeaders();
        for (String key : jsonHeaders.getMap().keySet()) {
            headers.add(key, this.getKeyAsStringOrList(jsonHeaders, key));
        }
        return headers;
    }

    private List<String> getKeyAsStringOrList(JsonObject json, String key) {
        Object value = json.getValue(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.asList((String)value);
        }
        if (value instanceof JsonArray) {
            return ((JsonArray)value).getList();
        }
        throw new IllegalArgumentException("invalid attachment type");
    }

    public MailMessage(String from, String to, String subject, String text) {
        this.from = from;
        this.to = this.asList(to);
        this.subject = subject;
        this.text = text;
    }

    public String getBounceAddress() {
        return this.bounceAddress;
    }

    public MailMessage setBounceAddress(String bounceAddress) {
        this.bounceAddress = bounceAddress;
        return this;
    }

    public String getFrom() {
        return this.from;
    }

    public MailMessage setFrom(String from) {
        this.from = from;
        return this;
    }

    public List<String> getTo() {
        return this.to;
    }

    public MailMessage setTo(List<String> to) {
        this.to = to;
        return this;
    }

    @GenIgnore
    public MailMessage setTo(String to) {
        ArrayList<String> toList = new ArrayList<String>();
        toList.add(to);
        this.to = toList;
        return this;
    }

    public List<String> getCc() {
        return this.cc;
    }

    public MailMessage setCc(List<String> cc) {
        this.cc = cc;
        return this;
    }

    @GenIgnore
    public MailMessage setCc(String cc) {
        ArrayList<String> ccList = new ArrayList<String>();
        ccList.add(cc);
        this.cc = ccList;
        return this;
    }

    public List<String> getBcc() {
        return this.bcc;
    }

    public MailMessage setBcc(List<String> bcc) {
        this.bcc = bcc;
        return this;
    }

    @GenIgnore
    public MailMessage setBcc(String bcc) {
        ArrayList<String> bccList = new ArrayList<String>();
        bccList.add(bcc);
        this.bcc = bccList;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public MailMessage setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public MailMessage setText(String text) {
        this.text = text;
        return this;
    }

    public String getHtml() {
        return this.html;
    }

    public MailMessage setHtml(String html) {
        this.html = html;
        return this;
    }

    public List<MailAttachment> getAttachment() {
        return this.attachment;
    }

    public MailMessage setAttachment(List<MailAttachment> attachment) {
        this.attachment = attachment;
        return this;
    }

    @GenIgnore
    public MailMessage setAttachment(MailAttachment attachment) {
        ArrayList<MailAttachment> attachmentList = new ArrayList<MailAttachment>();
        attachmentList.add(attachment);
        this.attachment = attachmentList;
        return this;
    }

    public MultiMap getHeaders() {
        return this.headers;
    }

    public MailMessage setHeaders(MultiMap headers) {
        this.headers = headers;
        return this;
    }

    public boolean isFixedHeaders() {
        return this.fixedHeaders;
    }

    public MailMessage setFixedHeaders(boolean fixedHeaders) {
        this.fixedHeaders = fixedHeaders;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        this.putIfNotNull(json, "bounceAddress", this.bounceAddress);
        this.putIfNotNull(json, "from", this.from);
        this.putIfNotNull(json, "to", this.to);
        this.putIfNotNull(json, "cc", this.cc);
        this.putIfNotNull(json, "bcc", this.bcc);
        this.putIfNotNull(json, "subject", this.subject);
        this.putIfNotNull(json, "text", this.text);
        this.putIfNotNull(json, "html", this.html);
        if (this.attachment != null) {
            JsonArray array = new JsonArray();
            for (MailAttachment a : this.attachment) {
                array.add(a.toJson());
            }
            json.put("attachment", array);
        }
        if (this.headers != null) {
            json.put("headers", this.multiMapJson(this.headers));
        }
        if (this.fixedHeaders) {
            json.put("fixedheaders", Boolean.valueOf(true));
        }
        return json;
    }

    private JsonObject multiMapJson(MultiMap headers) {
        JsonObject json = new JsonObject();
        for (String key : headers.names()) {
            json.put(key, (Object)headers.getAll(key));
        }
        return json;
    }

    private List<Object> getList() {
        return Arrays.asList(this.bounceAddress, this.from, this.to, this.cc, this.bcc, this.subject, this.text, this.html, this.attachment, this.headers, this.fixedHeaders);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MailMessage)) {
            return false;
        }
        MailMessage message = (MailMessage)o;
        return this.getList().equals(message.getList());
    }

    public int hashCode() {
        return this.getList().hashCode();
    }

    private void putIfNotNull(JsonObject json, String key, Object value) {
        if (value != null) {
            json.put(key, value);
        }
    }

    private List<String> copyList(List<String> list) {
        if (list == null) {
            return null;
        }
        return new ArrayList<String>(list);
    }

    private List<String> asList(String to) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(to);
        return list;
    }
}

