/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.impl.Capabilities;
import io.vertx.ext.mail.impl.ConnectionLifeCycleListener;
import io.vertx.ext.mail.impl.MultilineParser;
import io.vertx.ext.mail.impl.SMTPQuit;
import java.net.InetSocketAddress;

class SMTPConnection {
    private static final Logger log = LoggerFactory.getLogger(SMTPConnection.class);
    private final Vertx vertx;
    private NetSocket ns;
    private boolean socketClosed = false;
    private boolean socketShutDown = false;
    private Handler<String> commandReplyHandler;
    private Handler<Throwable> errorHandler;
    private boolean broken = true;
    private boolean idle = false;
    private boolean doShutdown = false;
    private final NetClient client;
    private Capabilities capa = new Capabilities();
    private final ConnectionLifeCycleListener listener;
    private Context context;
    private Handler<Throwable> prevErrorHandler = null;

    SMTPConnection(Vertx vertx, NetClient client, ConnectionLifeCycleListener listener) {
        this.client = client;
        this.listener = listener;
        this.vertx = vertx;
    }

    Capabilities getCapa() {
        return this.capa;
    }

    void parseCapabilities(String message) {
        this.capa = new Capabilities();
        this.capa.parseCapabilities(message);
    }

    void shutdown() {
        this.broken = true;
        this.commandReplyHandler = null;
        this.socketShutDown = true;
        if (this.ns != null) {
            this.ns.close();
            this.ns = null;
        }
    }

    void write(String str, Handler<String> commandResultHandler) {
        this.write(str, -1, commandResultHandler);
    }

    void write(String str, int blank, Handler<String> commandResultHandler) {
        this.commandReplyHandler = commandResultHandler;
        if (this.socketClosed) {
            log.debug((Object)"connection was closed by server");
            this.handleError("connection was closed by server");
        } else if (this.ns != null) {
            if (log.isDebugEnabled()) {
                String logStr;
                if (blank >= 0) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = blank; i < str.length(); ++i) {
                        sb.append('*');
                    }
                    logStr = str.substring(0, blank) + sb;
                } else {
                    logStr = str;
                }
                if (logStr.length() < 1000) {
                    log.debug((Object)("command: " + logStr));
                } else {
                    log.debug((Object)("command: " + logStr.substring(0, 1000) + "..."));
                }
            }
            this.ns.write(str + "\r\n");
        } else {
            log.debug((Object)("not sending command " + str + " since the netsocket is null"));
        }
    }

    void writeLine(String str, boolean mayLog) {
        if (mayLog) {
            log.debug((Object)str);
        }
        this.ns.write(str + "\r\n");
    }

    void writeLineWithDrainHandler(String str, boolean mayLog, Handler<Void> handler) {
        if (mayLog) {
            log.debug((Object)str);
        }
        if (this.ns.writeQueueFull()) {
            this.ns.drainHandler(v -> {
                this.ns.drainHandler(null);
                this.ns.write(str + "\r\n");
                handler.handle(null);
            });
        } else {
            this.ns.write(str + "\r\n");
            handler.handle(null);
        }
    }

    boolean writeQueueFull() {
        return this.ns.writeQueueFull();
    }

    private void handleError(String message) {
        this.handleError((Throwable)new NoStackTraceThrowable(message));
    }

    private void handleError(Throwable throwable) {
        this.errorHandler.handle((Object)throwable);
    }

    public void openConnection(MailConfig config, Handler<String> initialReplyHandler, Handler<Throwable> errorHandler) {
        this.errorHandler = errorHandler;
        this.broken = false;
        this.idle = false;
        this.vertx.executeBlocking(fut -> {
            InetSocketAddress address = new InetSocketAddress(config.getHostname(), config.getPort());
            if (address.isUnresolved()) {
                fut.fail("Cannot resolve " + config.getHostname());
            } else {
                fut.complete((Object)address.getAddress().getHostAddress());
            }
        }, ip -> {
            if (ip.failed()) {
                errorHandler.handle((Object)ip.cause());
                return;
            }
            this.connect(config, initialReplyHandler, (String)ip.result());
        });
    }

    private void connect(MailConfig config, Handler<String> initialReplyHandler, String host) {
        this.client.connect(config.getPort(), host, asyncResult -> {
            if (asyncResult.succeeded()) {
                this.context = Vertx.currentContext();
                this.ns = (NetSocket)asyncResult.result();
                this.socketClosed = false;
                this.ns.exceptionHandler(e -> {
                    log.debug((Object)"exceptionHandler called");
                    if (!(this.socketClosed || this.socketShutDown || this.idle || this.broken)) {
                        this.setBroken();
                        log.debug((Object)"got an exception on the netsocket", e);
                        this.handleError((Throwable)e);
                    } else {
                        log.debug((Object)"not returning follow-up exception", e);
                    }
                });
                this.ns.closeHandler(v -> {
                    log.debug((Object)"socket has been closed");
                    this.listener.connectionClosed(this);
                    this.socketClosed = true;
                    if (!(this.socketShutDown || this.idle || this.broken)) {
                        this.setBroken();
                        log.debug((Object)"throwing: connection has been closed by the server");
                        this.handleError("connection has been closed by the server");
                    } else {
                        if (this.socketShutDown || this.broken) {
                            log.debug((Object)"close has been expected");
                        } else {
                            log.debug((Object)"closed while connection has been idle (timeout on server?)");
                        }
                        if (!this.broken) {
                            this.setBroken();
                        }
                        if (!this.socketShutDown) {
                            this.shutdown();
                            this.listener.dataEnded(this);
                        }
                    }
                });
                this.commandReplyHandler = initialReplyHandler;
                MultilineParser mlp = new MultilineParser((Handler<Buffer>)((Handler)buffer -> {
                    if (this.commandReplyHandler == null) {
                        log.debug((Object)("dropping reply arriving after we stopped processing \"" + buffer.toString() + "\""));
                    } else {
                        Handler<String> currentHandler = this.commandReplyHandler;
                        this.commandReplyHandler = null;
                        currentHandler.handle((Object)buffer.toString());
                    }
                }));
                this.ns.handler((Handler)mlp);
            } else {
                log.error((Object)"exception on connect", asyncResult.cause());
                this.handleError(asyncResult.cause());
            }
        });
    }

    boolean isSsl() {
        return this.ns.isSsl();
    }

    void upgradeToSsl(Handler<Void> handler) {
        this.ns.upgradeToSsl(handler);
    }

    public boolean isBroken() {
        return this.broken;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public void returnToPool() {
        if (this.isIdle()) {
            log.info((Object)"state error: idle connection returned to pool");
            this.handleError("state error: idle connection returned to pool");
        } else if (this.doShutdown) {
            log.debug((Object)"shutting connection down");
            this.quitCloseConnection();
        } else {
            log.debug((Object)"returning connection to pool");
            this.commandReplyHandler = null;
            this.listener.dataEnded(this);
            log.debug((Object)"setting error handler to null");
            this.errorHandler = null;
        }
    }

    void quitCloseConnection() {
        if (!this.socketShutDown) {
            this.context.runOnContext(v1 -> {
                log.debug((Object)"shutting down connection");
                if (this.socketClosed) {
                    log.debug((Object)"connection is already closed, only doing shutdown()");
                    this.shutdown();
                } else {
                    this.useConnection();
                    new SMTPQuit(this, (Handler<Void>)((Handler)v -> {
                        this.shutdown();
                        log.debug((Object)"connection is shut down");
                    })).start();
                }
            });
        }
    }

    void useConnection() {
        this.idle = false;
    }

    void setIdle() {
        this.idle = true;
    }

    public void setErrorHandler(Handler<Throwable> newHandler) {
        if (this.prevErrorHandler == null) {
            this.prevErrorHandler = this.errorHandler;
        }
        this.errorHandler = newHandler;
    }

    public void resetErrorHandler() {
        this.errorHandler = this.prevErrorHandler;
    }

    public void setBroken() {
        if (!this.broken) {
            log.debug((Object)"setting connection to broken");
            this.broken = true;
            this.commandReplyHandler = null;
            log.debug((Object)"closing connection");
            this.shutdown();
            this.listener.dataEnded(this);
        } else {
            log.debug((Object)"connection is already set to broken");
        }
    }

    public void setDoShutdown() {
        log.debug((Object)"will shut down connection after send operation finishes");
        this.doShutdown = true;
    }

    public void close() {
        this.quitCloseConnection();
    }

    boolean isClosed() {
        return this.socketClosed;
    }

    Context getContext() {
        return this.context;
    }
}

