/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static Set<String> parseCapaAuth(String auths) {
        HashSet<String> authSet = new HashSet<String>();
        for (String a : Utils.splitByChar(auths, ' ')) {
            authSet.add(a);
        }
        return authSet;
    }

    static List<String> splitByChar(String message, char ch) {
        int nextIndex;
        ArrayList<String> lines = new ArrayList<String>();
        int index = 0;
        while ((nextIndex = message.indexOf(ch, index)) != -1) {
            lines.add(message.substring(index, nextIndex));
            index = nextIndex + 1;
        }
        lines.add(message.substring(index));
        return lines;
    }

    static boolean isEsmtpSupported(String message) {
        boolean esmtpSupported = message.toUpperCase(Locale.ENGLISH).contains("ESMTP");
        log.debug((Object)("isEsmtpSupported:" + esmtpSupported));
        return esmtpSupported;
    }

    public static String getHostname() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            return ip.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }
}

