/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.mailencoder;

import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.ext.mail.mailencoder.EncodedPart;
import io.vertx.ext.mail.mailencoder.Utils;
import java.util.List;

class MultiPart
extends EncodedPart {
    public MultiPart(List<EncodedPart> parts, String mode) {
        String boundary = Utils.generateBoundary();
        this.headers = new CaseInsensitiveHeaders();
        this.headers.set("Content-Type", "multipart/" + mode + "; boundary=\"" + boundary + "\"");
        StringBuilder sb = new StringBuilder();
        for (EncodedPart part : parts) {
            sb.append("--");
            sb.append(boundary);
            sb.append('\n');
            sb.append(part.asString());
            sb.append('\n');
        }
        sb.append("--");
        sb.append(boundary);
        sb.append("--\n");
        this.part = sb.toString();
    }
}

