/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.MailResult;
import io.vertx.ext.mail.MailService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MailServiceVertxEBProxy
implements MailService {
    private Vertx _vertx;
    private String _address;
    private DeliveryOptions _options;
    private boolean closed;

    public MailServiceVertxEBProxy(Vertx vertx, String address) {
        this(vertx, address, null);
    }

    public MailServiceVertxEBProxy(Vertx vertx, String address, DeliveryOptions options) {
        this._vertx = vertx;
        this._address = address;
        this._options = options;
    }

    @Override
    public MailService sendMail(MailMessage email, Handler<AsyncResult<MailResult>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("email", email == null ? null : email.toJson());
        DeliveryOptions _deliveryOptions = this._options != null ? new DeliveryOptions(this._options) : new DeliveryOptions();
        _deliveryOptions.addHeader("action", "sendMail");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)(((Message)res.result()).body() == null ? null : new MailResult((JsonObject)((Message)res.result()).body()))));
            }
        });
        return this;
    }

    @Override
    public void close() {
    }

    private List<Character> convertToListChar(JsonArray arr) {
        ArrayList<Character> list = new ArrayList<Character>();
        for (Object obj : arr) {
            Integer jobj = (Integer)obj;
            list.add(Character.valueOf((char)jobj.intValue()));
        }
        return list;
    }

    private Set<Character> convertToSetChar(JsonArray arr) {
        HashSet<Character> set = new HashSet<Character>();
        for (Object obj : arr) {
            Integer jobj = (Integer)obj;
            set.add(Character.valueOf((char)jobj.intValue()));
        }
        return set;
    }

    private <T> Map<String, T> convertMap(Map map) {
        if (map.isEmpty()) {
            return map;
        }
        Object elem = map.values().stream().findFirst().get();
        if (!(elem instanceof Map) && !(elem instanceof List)) {
            return map;
        }
        Function<Object, Object> converter = elem instanceof List ? object -> new JsonArray((List)object) : object -> new JsonObject((Map)object);
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, converter::apply));
    }

    private <T> List<T> convertList(List list) {
        if (list.isEmpty()) {
            return list;
        }
        Object elem = list.get(0);
        if (!(elem instanceof Map) && !(elem instanceof List)) {
            return list;
        }
        Function<Object, Object> converter = elem instanceof List ? object -> new JsonArray((List)object) : object -> new JsonObject((Map)object);
        return list.stream().map(converter).collect(Collectors.toList());
    }

    private <T> Set<T> convertSet(List list) {
        return new HashSet<T>(this.convertList(list));
    }
}

