/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core;

import java.util.Map;
import io.vertx.lang.rxjava.InternalHelper;
import rx.Observable;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * The composite future wraps a list of {@link io.vertx.rxjava.core.Future futures}, it is useful when several futures
 * needs to be coordinated.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.CompositeFuture original} non RX-ified interface using Vert.x codegen.
 */

public class CompositeFuture extends Future<CompositeFuture> {

  final io.vertx.core.CompositeFuture delegate;

  public CompositeFuture(io.vertx.core.CompositeFuture delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public Object getDelegate() {
    return delegate;
  }

  /**
   * Return a composite future, succeeded when all futures are succeeded, failed when any future is failed.
   * @param f1 future
   * @param f2 future
   * @return the composite future
   */
  public static <T1, T2> CompositeFuture all(Future<T1> f1, Future<T2> f2) { 
    CompositeFuture ret= CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all((io.vertx.core.Future<T1>) f1.getDelegate(), (io.vertx.core.Future<T2>) f2.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#all} but with 3 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @return 
   */
  public static <T1, T2, T3> CompositeFuture all(Future<T1> f1, Future<T2> f2, Future<T3> f3) { 
    CompositeFuture ret= CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all((io.vertx.core.Future<T1>) f1.getDelegate(), (io.vertx.core.Future<T2>) f2.getDelegate(), (io.vertx.core.Future<T3>) f3.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#all} but with 4 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @return 
   */
  public static <T1, T2, T3, T4> CompositeFuture all(Future<T1> f1, Future<T2> f2, Future<T3> f3, Future<T4> f4) { 
    CompositeFuture ret= CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all((io.vertx.core.Future<T1>) f1.getDelegate(), (io.vertx.core.Future<T2>) f2.getDelegate(), (io.vertx.core.Future<T3>) f3.getDelegate(), (io.vertx.core.Future<T4>) f4.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#all} but with 5 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @return 
   */
  public static <T1, T2, T3, T4, T5> CompositeFuture all(Future<T1> f1, Future<T2> f2, Future<T3> f3, Future<T4> f4, Future<T5> f5) { 
    CompositeFuture ret= CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all((io.vertx.core.Future<T1>) f1.getDelegate(), (io.vertx.core.Future<T2>) f2.getDelegate(), (io.vertx.core.Future<T3>) f3.getDelegate(), (io.vertx.core.Future<T4>) f4.getDelegate(), (io.vertx.core.Future<T5>) f5.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#all} but with 6 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @param f6 
   * @return 
   */
  public static <T1, T2, T3, T4, T5, T6> CompositeFuture all(Future<T1> f1, Future<T2> f2, Future<T3> f3, Future<T4> f4, Future<T5> f5, Future<T6> f6) { 
    CompositeFuture ret= CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all((io.vertx.core.Future<T1>) f1.getDelegate(), (io.vertx.core.Future<T2>) f2.getDelegate(), (io.vertx.core.Future<T3>) f3.getDelegate(), (io.vertx.core.Future<T4>) f4.getDelegate(), (io.vertx.core.Future<T5>) f5.getDelegate(), (io.vertx.core.Future<T6>) f6.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#all} but with a list of futures.
   * @param futures 
   * @return 
   */
  public static CompositeFuture all(List<Future> futures) { 
    CompositeFuture ret= CompositeFuture.newInstance(io.vertx.core.CompositeFuture.all(futures.stream().map(element -> (io.vertx.core.Future)element.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  /**
   * Return a composite future, succeeded when any futures is succeeded, failed when all futures are failed.
   * @param f1 future
   * @param f2 future
   * @return the composite future
   */
  public static <T1, T2> CompositeFuture any(Future<T1> f1, Future<T2> f2) { 
    CompositeFuture ret= CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any((io.vertx.core.Future<T1>) f1.getDelegate(), (io.vertx.core.Future<T2>) f2.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#any} but with 3 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @return 
   */
  public static <T1, T2, T3> CompositeFuture any(Future<T1> f1, Future<T2> f2, Future<T3> f3) { 
    CompositeFuture ret= CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any((io.vertx.core.Future<T1>) f1.getDelegate(), (io.vertx.core.Future<T2>) f2.getDelegate(), (io.vertx.core.Future<T3>) f3.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#any} but with 4 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @return 
   */
  public static <T1, T2, T3, T4> CompositeFuture any(Future<T1> f1, Future<T2> f2, Future<T3> f3, Future<T4> f4) { 
    CompositeFuture ret= CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any((io.vertx.core.Future<T1>) f1.getDelegate(), (io.vertx.core.Future<T2>) f2.getDelegate(), (io.vertx.core.Future<T3>) f3.getDelegate(), (io.vertx.core.Future<T4>) f4.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#any} but with 5 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @return 
   */
  public static <T1, T2, T3, T4, T5> CompositeFuture any(Future<T1> f1, Future<T2> f2, Future<T3> f3, Future<T4> f4, Future<T5> f5) { 
    CompositeFuture ret= CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any((io.vertx.core.Future<T1>) f1.getDelegate(), (io.vertx.core.Future<T2>) f2.getDelegate(), (io.vertx.core.Future<T3>) f3.getDelegate(), (io.vertx.core.Future<T4>) f4.getDelegate(), (io.vertx.core.Future<T5>) f5.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#any} but with 6 futures.
   * @param f1 
   * @param f2 
   * @param f3 
   * @param f4 
   * @param f5 
   * @param f6 
   * @return 
   */
  public static <T1, T2, T3, T4, T5, T6> CompositeFuture any(Future<T1> f1, Future<T2> f2, Future<T3> f3, Future<T4> f4, Future<T5> f5, Future<T6> f6) { 
    CompositeFuture ret= CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any((io.vertx.core.Future<T1>) f1.getDelegate(), (io.vertx.core.Future<T2>) f2.getDelegate(), (io.vertx.core.Future<T3>) f3.getDelegate(), (io.vertx.core.Future<T4>) f4.getDelegate(), (io.vertx.core.Future<T5>) f5.getDelegate(), (io.vertx.core.Future<T6>) f6.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.CompositeFuture#any} but with a list of futures.
   * @param futures 
   * @return 
   */
  public static CompositeFuture any(List<Future> futures) { 
    CompositeFuture ret= CompositeFuture.newInstance(io.vertx.core.CompositeFuture.any(futures.stream().map(element -> (io.vertx.core.Future)element.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  public CompositeFuture setHandler(Handler<AsyncResult<CompositeFuture>> handler) { 
    ( /* Work around for https://jira.codehaus.org/browse/GROOVY-6970 */ (io.vertx.core.CompositeFuture) delegate).setHandler(new Handler<AsyncResult<io.vertx.core.CompositeFuture>>() {
      public void handle(AsyncResult<io.vertx.core.CompositeFuture> event) {
        AsyncResult<CompositeFuture> f;
        if (event.succeeded()) {
          f = InternalHelper.<CompositeFuture>result(new CompositeFuture(event.result()));
        } else {
          f = InternalHelper.<CompositeFuture>failure(event.cause());
        }
        handler.handle(f);
      }
    });
    return this;
  }

  public Observable<CompositeFuture> setHandlerObservable() { 
    io.vertx.rx.java.ObservableFuture<CompositeFuture> handler = io.vertx.rx.java.RxHelper.observableFuture();
    setHandler(handler.toHandler());
    return handler;
  }

  /**
   * Returns a cause of a wrapped future
   * @param index the wrapped future index
   * @return 
   */
  public Throwable cause(int index) { 
    Throwable ret = this.delegate.cause(index);
    return ret;
  }

  /**
   * Returns true if a wrapped future is succeeded
   * @param index the wrapped future index
   * @return 
   */
  public boolean succeeded(int index) { 
    boolean ret = this.delegate.succeeded(index);
    return ret;
  }

  /**
   * Returns true if a wrapped future is failed
   * @param index the wrapped future index
   * @return 
   */
  public boolean failed(int index) { 
    boolean ret = this.delegate.failed(index);
    return ret;
  }

  /**
   * Returns true if a wrapped future is completed
   * @param index the wrapped future index
   * @return 
   */
  public boolean isComplete(int index) { 
    boolean ret = this.delegate.isComplete(index);
    return ret;
  }

  /**
   * Returns the result of a wrapped future
   * @param index the wrapped future index
   * @return 
   */
  public <T> T result(int index) { 
    T ret = (T) this.delegate.result(index);
    return ret;
  }

  /**
   * @return the number of wrapped future
   * @return 
   */
  public int size() { 
    int ret = this.delegate.size();
    return ret;
  }


  public static CompositeFuture newInstance(io.vertx.core.CompositeFuture arg) {
    return arg != null ? new CompositeFuture(arg) : null;
  }
}
