/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core;

import java.util.Map;
import io.vertx.lang.rxjava.InternalHelper;
import rx.Observable;
import io.vertx.rxjava.core.datagram.DatagramSocket;
import io.vertx.rxjava.core.http.HttpServer;
import io.vertx.rxjava.core.shareddata.SharedData;
import io.vertx.rxjava.core.eventbus.EventBus;
import io.vertx.core.AsyncResult;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.rxjava.core.net.NetClient;
import io.vertx.core.VertxOptions;
import java.util.Set;
import io.vertx.core.net.NetClientOptions;
import io.vertx.rxjava.core.dns.DnsClient;
import io.vertx.core.net.NetServerOptions;
import io.vertx.rxjava.core.metrics.Measured;
import io.vertx.rxjava.core.net.NetServer;
import io.vertx.core.DeploymentOptions;
import io.vertx.rxjava.core.file.FileSystem;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.Handler;
import io.vertx.rxjava.core.http.HttpClient;

/**
 * The entry point into the Vert.x Core API.
 * <p>
 * You use an instance of this class for functionality including:
 * <ul>
 *   <li>Creating TCP clients and servers</li>
 *   <li>Creating HTTP clients and servers</li>
 *   <li>Creating DNS clients</li>
 *   <li>Creating Datagram sockets</li>
 *   <li>Setting and cancelling periodic and one-shot timers</li>
 *   <li>Getting a reference to the event bus API</li>
 *   <li>Getting a reference to the file system API</li>
 *   <li>Getting a reference to the shared data API</li>
 *   <li>Deploying and undeploying verticles</li>
 * </ul>
 * <p>
 * Most functionality in Vert.x core is fairly low level.
 * <p>
 * To create an instance of this class you can use the static factory methods: {@link io.vertx.rxjava.core.Vertx#vertx},
 * {@link io.vertx.rxjava.core.Vertx#vertx} and {@link io.vertx.rxjava.core.Vertx#clusteredVertx}.
 * <p>
 * Please see the user manual for more detailed usage information.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.Vertx original} non RX-ified interface using Vert.x codegen.
 */

public class Vertx implements Measured {

  final io.vertx.core.Vertx delegate;

  public Vertx(io.vertx.core.Vertx delegate) {
    this.delegate = delegate;
  }

  public Object getDelegate() {
    return delegate;
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return true if the metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = this.delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Creates a non clustered instance using default options.
   * @return the instance
   */
  public static Vertx vertx() { 
    Vertx ret= Vertx.newInstance(io.vertx.core.Vertx.vertx());
    return ret;
  }

  /**
   * Creates a non clustered instance using the specified options
   * @param options the options to use
   * @return the instance
   */
  public static Vertx vertx(VertxOptions options) { 
    Vertx ret= Vertx.newInstance(io.vertx.core.Vertx.vertx(options));
    return ret;
  }

  /**
   * Creates a clustered instance using the specified options.
   * <p>
   * The instance is created asynchronously and the resultHandler is called with the result when it is ready.
   * @param options the options to use
   * @param resultHandler the result handler that will receive the result
   */
  public static void clusteredVertx(VertxOptions options, Handler<AsyncResult<Vertx>> resultHandler) { 
    io.vertx.core.Vertx.clusteredVertx(options, new Handler<AsyncResult<io.vertx.core.Vertx>>() {
      public void handle(AsyncResult<io.vertx.core.Vertx> event) {
        AsyncResult<Vertx> f;
        if (event.succeeded()) {
          f = InternalHelper.<Vertx>result(new Vertx(event.result()));
        } else {
          f = InternalHelper.<Vertx>failure(event.cause());
        }
        resultHandler.handle(f);
      }
    });
  }

  /**
   * Creates a clustered instance using the specified options.
   * <p>
   * The instance is created asynchronously and the resultHandler is called with the result when it is ready.
   * @param options the options to use
   * @return 
   */
  public static Observable<Vertx> clusteredVertxObservable(VertxOptions options) { 
    io.vertx.rx.java.ObservableFuture<Vertx> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    clusteredVertx(options, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Gets the current context
   * @return The current context or null if no current context
   */
  public static Context currentContext() { 
    Context ret= Context.newInstance(io.vertx.core.Vertx.currentContext());
    return ret;
  }

  /**
   * Gets the current context, or creates one if there isn't one
   * @return The current context (created if didn't exist)
   */
  public Context getOrCreateContext() { 
    Context ret= Context.newInstance(this.delegate.getOrCreateContext());
    return ret;
  }

  /**
   * Create a TCP/SSL server using the specified options
   * @param options the options to use
   * @return the server
   */
  public NetServer createNetServer(NetServerOptions options) { 
    NetServer ret= NetServer.newInstance(this.delegate.createNetServer(options));
    return ret;
  }

  /**
   * Create a TCP/SSL server using default options
   * @return the server
   */
  public NetServer createNetServer() { 
    NetServer ret= NetServer.newInstance(this.delegate.createNetServer());
    return ret;
  }

  /**
   * Create a TCP/SSL client using the specified options
   * @param options the options to use
   * @return the client
   */
  public NetClient createNetClient(NetClientOptions options) { 
    NetClient ret= NetClient.newInstance(this.delegate.createNetClient(options));
    return ret;
  }

  /**
   * Create a TCP/SSL client using default options
   * @return the client
   */
  public NetClient createNetClient() { 
    NetClient ret= NetClient.newInstance(this.delegate.createNetClient());
    return ret;
  }

  /**
   * Create an HTTP/HTTPS server using the specified options
   * @param options the options to use
   * @return the server
   */
  public HttpServer createHttpServer(HttpServerOptions options) { 
    HttpServer ret= HttpServer.newInstance(this.delegate.createHttpServer(options));
    return ret;
  }

  /**
   * Create an HTTP/HTTPS server using default options
   * @return the server
   */
  public HttpServer createHttpServer() { 
    HttpServer ret= HttpServer.newInstance(this.delegate.createHttpServer());
    return ret;
  }

  /**
   * Create a HTTP/HTTPS client using the specified options
   * @param options the options to use
   * @return the client
   */
  public HttpClient createHttpClient(HttpClientOptions options) { 
    HttpClient ret= HttpClient.newInstance(this.delegate.createHttpClient(options));
    return ret;
  }

  /**
   * Create a HTTP/HTTPS client using default options
   * @return the client
   */
  public HttpClient createHttpClient() { 
    HttpClient ret= HttpClient.newInstance(this.delegate.createHttpClient());
    return ret;
  }

  /**
   * Create a datagram socket using the specified options
   * @param options the options to use
   * @return the socket
   */
  public DatagramSocket createDatagramSocket(DatagramSocketOptions options) { 
    DatagramSocket ret= DatagramSocket.newInstance(this.delegate.createDatagramSocket(options));
    return ret;
  }

  /**
   * Create a datagram socket using default options
   * @return the socket
   */
  public DatagramSocket createDatagramSocket() { 
    DatagramSocket ret= DatagramSocket.newInstance(this.delegate.createDatagramSocket());
    return ret;
  }

  /**
   * Get the filesystem object. There is a single instance of FileSystem per Vertx instance.
   * @return the filesystem object
   */
  public FileSystem fileSystem() { 
    if (cached_0 != null) {
      return cached_0;
    }
    FileSystem ret= FileSystem.newInstance(this.delegate.fileSystem());
    cached_0 = ret;
    return ret;
  }

  /**
   * Get the event bus object. There is a single instance of EventBus per Vertx instance.
   * @return the event bus object
   */
  public EventBus eventBus() { 
    if (cached_1 != null) {
      return cached_1;
    }
    EventBus ret= EventBus.newInstance(this.delegate.eventBus());
    cached_1 = ret;
    return ret;
  }

  /**
   * Create a DNS client to connect to a DNS server at the specified host and port
   * @param port the port
   * @param host the host
   * @return the DNS client
   */
  public DnsClient createDnsClient(int port, String host) { 
    DnsClient ret= DnsClient.newInstance(this.delegate.createDnsClient(port, host));
    return ret;
  }

  /**
   * Get the shared data object. There is a single instance of SharedData per Vertx instance.
   * @return the shared data object
   */
  public SharedData sharedData() { 
    if (cached_2 != null) {
      return cached_2;
    }
    SharedData ret= SharedData.newInstance(this.delegate.sharedData());
    cached_2 = ret;
    return ret;
  }

  /**
   * Set a one-shot timer to fire after <code>delay</code> milliseconds, at which point <code>handler</code> will be called with
   * the id of the timer.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  public long setTimer(long delay, Handler<Long> handler) { 
    long ret = this.delegate.setTimer(delay, handler);
    return ret;
  }

  /**
   * Returns a one-shot timer as a read stream. The timer will be fired after <code>delay</code> milliseconds after
   * the  has been called.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @return the timer stream
   */
  public TimeoutStream timerStream(long delay) { 
    TimeoutStream ret= TimeoutStream.newInstance(this.delegate.timerStream(delay));
    return ret;
  }

  /**
   * Set a periodic timer to fire every <code>delay</code> milliseconds, at which point <code>handler</code> will be called with
   * the id of the timer.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  public long setPeriodic(long delay, Handler<Long> handler) { 
    long ret = this.delegate.setPeriodic(delay, handler);
    return ret;
  }

  /**
   * Returns a periodic timer as a read stream. The timer will be fired every <code>delay</code> milliseconds after
   * the  has been called.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @return the periodic stream
   */
  public TimeoutStream periodicStream(long delay) { 
    TimeoutStream ret= TimeoutStream.newInstance(this.delegate.periodicStream(delay));
    return ret;
  }

  /**
   * Cancels the timer with the specified <code>id</code>.
   * @param id The id of the timer to cancel
   * @return true if the timer was successfully cancelled, or false if the timer does not exist.
   */
  public boolean cancelTimer(long id) { 
    boolean ret = this.delegate.cancelTimer(id);
    return ret;
  }

  /**
   * Puts the handler on the event queue for the current context so it will be run asynchronously ASAP after all
   * preceeding events have been handled.
   * @param action - a handler representing the action to execute
   */
  public void runOnContext(Handler<Void> action) { 
    this.delegate.runOnContext(action);
  }

  /**
   * Stop the the Vertx instance and release any resources held by it.
   * <p>
   * The instance cannot be used after it has been closed.
   * <p>
   * The actual close is asynchronous and may not complete until after the call has returned.
   */
  public void close() { 
    this.delegate.close();
  }

  /**
   * Like {@link io.vertx.core.Vertx} but the completionHandler will be called when the close is complete
   * @param completionHandler The handler will be notified when the close is complete.
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    this.delegate.close(completionHandler);
  }

  /**
   * Like {@link io.vertx.core.Vertx} but the completionHandler will be called when the close is complete
   * @return 
   */
  public Observable<Void> closeObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
    close(completionHandler.toHandler());
    return completionHandler;
  }

  /**
   * Deploy a verticle instance given a name.
   * <p>
   * Given the name, Vert.x selects a  instance to use to instantiate the verticle.
   * <p>
   * For the rules on how factories are selected please consult the user manual.
   * @param name the name.
   */
  public void deployVerticle(String name) { 
    this.delegate.deployVerticle(name);
  }

  /**
   * Like {@link io.vertx.core.Vertx} but the completionHandler will be notified when the deployment is complete.
   * <p>
   * If the deployment is successful the result will contain a String representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * @param name The identifier
   * @param completionHandler a handler which will be notified when the deployment is complete
   */
  public void deployVerticle(String name, Handler<AsyncResult<String>> completionHandler) { 
    this.delegate.deployVerticle(name, completionHandler);
  }

  /**
   * Like {@link io.vertx.core.Vertx} but the completionHandler will be notified when the deployment is complete.
   * <p>
   * If the deployment is successful the result will contain a String representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * @param name The identifier
   * @return 
   */
  public Observable<String> deployVerticleObservable(String name) { 
    io.vertx.rx.java.ObservableFuture<String> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
    deployVerticle(name, completionHandler.toHandler());
    return completionHandler;
  }

  /**
   * Like {@link io.vertx.core.Vertx} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param name the name
   * @param options the deployment options.
   */
  public void deployVerticle(String name, DeploymentOptions options) { 
    this.delegate.deployVerticle(name, options);
  }

  /**
   * Like {@link io.vertx.core.Vertx} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param name the name
   * @param options the deployment options.
   * @param completionHandler a handler which will be notified when the deployment is complete
   */
  public void deployVerticle(String name, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) { 
    this.delegate.deployVerticle(name, options, completionHandler);
  }

  /**
   * Like {@link io.vertx.core.Vertx} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param name the name
   * @param options the deployment options.
   * @return 
   */
  public Observable<String> deployVerticleObservable(String name, DeploymentOptions options) { 
    io.vertx.rx.java.ObservableFuture<String> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
    deployVerticle(name, options, completionHandler.toHandler());
    return completionHandler;
  }

  /**
   * Undeploy a verticle deployment.
   * <p>
   * The actual undeployment happens asynchronously and may not complete until after the method has returned.
   * @param deploymentID the deployment ID
   */
  public void undeploy(String deploymentID) { 
    this.delegate.undeploy(deploymentID);
  }

  /**
   * Like {@link io.vertx.core.Vertx} but the completionHandler will be notified when the undeployment is complete.
   * @param deploymentID the deployment ID
   * @param completionHandler a handler which will be notified when the undeployment is complete
   */
  public void undeploy(String deploymentID, Handler<AsyncResult<Void>> completionHandler) { 
    this.delegate.undeploy(deploymentID, completionHandler);
  }

  /**
   * Like {@link io.vertx.core.Vertx} but the completionHandler will be notified when the undeployment is complete.
   * @param deploymentID the deployment ID
   * @return 
   */
  public Observable<Void> undeployObservable(String deploymentID) { 
    io.vertx.rx.java.ObservableFuture<Void> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
    undeploy(deploymentID, completionHandler.toHandler());
    return completionHandler;
  }

  /**
   * Return a Set of deployment IDs for the currently deployed deploymentIDs.
   * @return Set of deployment IDs
   */
  public Set<String> deploymentIDs() { 
    Set<String> ret = this.delegate.deploymentIDs();
;
    return ret;
  }

  /**
   * Is this Vert.x instance clustered?
   * @return true if clustered
   */
  public boolean isClustered() { 
    boolean ret = this.delegate.isClustered();
    return ret;
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (e.g. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.core.Future} or {@link io.vertx.core.Future} method, or the {@link io.vertx.core.Future}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @param resultHandler handler that will be called when the blocking code is complete
   */
  public <T> void executeBlocking(Handler<Future<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) { 
    this.delegate.executeBlocking(new Handler<io.vertx.core.Future<T>>() {
      public void handle(io.vertx.core.Future<T> event) {
        blockingCodeHandler.handle(new Future<T>(event));
      }
    }, ordered, resultHandler);
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (e.g. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.core.Future} or {@link io.vertx.core.Future} method, or the {@link io.vertx.core.Future}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return 
   */
  public <T> Observable<T> executeBlockingObservable(Handler<Future<T>> blockingCodeHandler, boolean ordered) { 
    io.vertx.rx.java.ObservableFuture<T> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    executeBlocking(blockingCodeHandler, ordered, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Like {@link io.vertx.core.Vertx} called with ordered = true.
   * @param blockingCodeHandler 
   * @param resultHandler 
   */
  public <T> void executeBlocking(Handler<Future<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) { 
    this.delegate.executeBlocking(new Handler<io.vertx.core.Future<T>>() {
      public void handle(io.vertx.core.Future<T> event) {
        blockingCodeHandler.handle(new Future<T>(event));
      }
    }, resultHandler);
  }

  /**
   * Like {@link io.vertx.core.Vertx} called with ordered = true.
   * @param blockingCodeHandler 
   * @return 
   */
  public <T> Observable<T> executeBlockingObservable(Handler<Future<T>> blockingCodeHandler) { 
    io.vertx.rx.java.ObservableFuture<T> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    executeBlocking(blockingCodeHandler, resultHandler.toHandler());
    return resultHandler;
  }

  private FileSystem cached_0;
  private EventBus cached_1;
  private SharedData cached_2;

  public static Vertx newInstance(io.vertx.core.Vertx arg) {
    return arg != null ? new Vertx(arg) : null;
  }
}
