/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.eventbus;

import java.util.Map;
import io.vertx.lang.rxjava.InternalHelper;
import rx.Observable;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.rxjava.core.streams.WriteStream;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a stream of message that can be written to.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.MessageProducer original} non RX-ified interface using Vert.x codegen.
 */

public class MessageProducer<T> implements WriteStream<T> {

  final io.vertx.core.eventbus.MessageProducer delegate;

  public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate) {
    this.delegate = delegate;
  }

  public Object getDelegate() {
    return delegate;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.eventbus.MessageProducer#end} but writes some data to the stream before ending.
   * @param t 
   */
  public void end(T t) { 
    this.delegate.end(t);
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.core.eventbus.MessageProducer}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = this.delegate.writeQueueFull();
    return ret;
  }

  /**
   * Synonym for {@link io.vertx.core.eventbus.MessageProducer}.
   * @param message the message to send
   * @return reference to this for fluency
   */
  public MessageProducer<T> send(T message) { 
    MessageProducer<T> ret= MessageProducer.newInstance(this.delegate.send(message));
    return ret;
  }

  public <R> MessageProducer<T> send(T message, Handler<AsyncResult<Message<R>>> replyHandler) { 
    MessageProducer<T> ret= MessageProducer.newInstance(this.delegate.send(message, new Handler<AsyncResult<io.vertx.core.eventbus.Message<R>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<R>> event) {
        AsyncResult<Message<R>> f;
        if (event.succeeded()) {
          f = InternalHelper.<Message<R>>result(new Message<R>(event.result()));
        } else {
          f = InternalHelper.<Message<R>>failure(event.cause());
        }
        replyHandler.handle(f);
      }
    }));
    return ret;
  }

  public MessageProducer<T> exceptionHandler(Handler<Throwable> handler) { 
    ( /* Work around for https://jira.codehaus.org/browse/GROOVY-6970 */ (io.vertx.core.streams.WriteStream) delegate).exceptionHandler(handler);
    return this;
  }

  public MessageProducer<T> write(T data) { 
    ( /* Work around for https://jira.codehaus.org/browse/GROOVY-6970 */ (io.vertx.core.streams.WriteStream) delegate).write(data);
    return this;
  }

  public MessageProducer<T> setWriteQueueMaxSize(int maxSize) { 
    ( /* Work around for https://jira.codehaus.org/browse/GROOVY-6970 */ (io.vertx.core.streams.WriteStream) delegate).setWriteQueueMaxSize(maxSize);
    return this;
  }

  public MessageProducer<T> drainHandler(Handler<Void> handler) { 
    ( /* Work around for https://jira.codehaus.org/browse/GROOVY-6970 */ (io.vertx.core.streams.WriteStream) delegate).drainHandler(handler);
    return this;
  }

  /**
   * Update the delivery options of this producer.
   * @param options the new options
   * @return this producer object
   */
  public MessageProducer<T> deliveryOptions(DeliveryOptions options) { 
    this.delegate.deliveryOptions(options);
    return this;
  }

  /**
   * @return The address to which the producer produces messages.
   * @return 
   */
  public String address() { 
    String ret = this.delegate.address();
    return ret;
  }

  /**
   * Closes the producer, calls {@link io.vertx.core.eventbus.MessageProducer}
   */
  public void end() { 
    ( /* Work around for https://jira.codehaus.org/browse/GROOVY-6970 */ (io.vertx.core.streams.WriteStream) delegate).end();
  }

  /**
   * Closes the producer, this method should be called when the message producer is not used anymore.
   */
  public void close() { 
    this.delegate.close();
  }


  public static <T> MessageProducer newInstance(io.vertx.core.eventbus.MessageProducer arg) {
    return arg != null ? new MessageProducer<T> (arg) : null;
  }
}
