/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.eventbus;

import java.util.Map;
import io.vertx.lang.rxjava.InternalHelper;
import rx.Observable;

/**
 *
 * Encapsulates a message being sent from Vert.x. Used with event bus interceptors
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.SendContext original} non RX-ified interface using Vert.x codegen.
 */

public class SendContext<T> {

  final io.vertx.core.eventbus.SendContext delegate;

  public SendContext(io.vertx.core.eventbus.SendContext delegate) {
    this.delegate = delegate;
  }

  public Object getDelegate() {
    return delegate;
  }

  /**
   * @return  The message being sent
   * @return 
   */
  public Message<T> message() { 
    Message<T> ret= Message.newInstance(this.delegate.message());
    return ret;
  }

  /**
   * Call the next interceptor
   */
  public void next() { 
    this.delegate.next();
  }

  /**
   * @return true if the message is being sent (point to point) or False if the message is being published
   */
  public boolean send() { 
    boolean ret = this.delegate.send();
    return ret;
  }


  public static <T> SendContext newInstance(io.vertx.core.eventbus.SendContext arg) {
    return arg != null ? new SendContext<T> (arg) : null;
  }
}
