/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.net;

import java.util.Map;
import io.vertx.lang.rxjava.InternalHelper;
import rx.Observable;

/**
 * The address of a socket
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.SocketAddress original} non RX-ified interface using Vert.x codegen.
 */

public class SocketAddress {

  final io.vertx.core.net.SocketAddress delegate;

  public SocketAddress(io.vertx.core.net.SocketAddress delegate) {
    this.delegate = delegate;
  }

  public Object getDelegate() {
    return delegate;
  }

  public String host() { 
    String ret = this.delegate.host();
    return ret;
  }

  public int port() { 
    int ret = this.delegate.port();
    return ret;
  }


  public static SocketAddress newInstance(io.vertx.core.net.SocketAddress arg) {
    return arg != null ? new SocketAddress(arg) : null;
  }
}
