/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.eventbus;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.lang.rxjava.InternalHelper;
import io.vertx.rxjava.core.eventbus.Message;
import io.vertx.rxjava.core.streams.WriteStream;

public class MessageProducer<T>
implements WriteStream<T> {
    final io.vertx.core.eventbus.MessageProducer delegate;

    public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public void end(T t) {
        this.delegate.end(t);
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    public MessageProducer<T> send(T message) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.send(message));
        return ret;
    }

    public <R> MessageProducer<T> send(T message, final Handler<AsyncResult<Message<R>>> replyHandler) {
        MessageProducer ret = MessageProducer.newInstance(this.delegate.send(message, new Handler<AsyncResult<io.vertx.core.eventbus.Message<R>>>(){

            public void handle(AsyncResult<io.vertx.core.eventbus.Message<R>> event) {
                Object f = event.succeeded() ? InternalHelper.result(new Message((io.vertx.core.eventbus.Message)event.result())) : InternalHelper.failure(event.cause());
                replyHandler.handle(f);
            }
        }));
        return ret;
    }

    @Override
    public MessageProducer<T> exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public MessageProducer<T> write(T data) {
        this.delegate.write(data);
        return this;
    }

    @Override
    public MessageProducer<T> setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public MessageProducer<T> drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public MessageProducer<T> deliveryOptions(DeliveryOptions options) {
        this.delegate.deliveryOptions(options);
        return this;
    }

    public String address() {
        String ret = this.delegate.address();
        return ret;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    public void close() {
        this.delegate.close();
    }

    public static <T> MessageProducer newInstance(io.vertx.core.eventbus.MessageProducer arg) {
        return arg != null ? new MessageProducer<T>(arg) : null;
    }
}

