/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.net;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.rxjava.InternalHelper;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.core.metrics.Measured;
import io.vertx.rxjava.core.net.NetSocket;
import io.vertx.rxjava.core.net.NetSocketStream;
import rx.Observable;

public class NetServer
implements Measured {
    final io.vertx.core.net.NetServer delegate;

    public NetServer(io.vertx.core.net.NetServer delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public NetSocketStream connectStream() {
        NetSocketStream ret = NetSocketStream.newInstance(this.delegate.connectStream());
        return ret;
    }

    public NetServer connectHandler(final Handler<NetSocket> handler) {
        NetServer ret = NetServer.newInstance(this.delegate.connectHandler((Handler)new Handler<io.vertx.core.net.NetSocket>(){

            public void handle(io.vertx.core.net.NetSocket event) {
                handler.handle((Object)new NetSocket(event));
            }
        }));
        return ret;
    }

    public NetServer listen() {
        this.delegate.listen();
        return this;
    }

    public NetServer listen(final Handler<AsyncResult<NetServer>> listenHandler) {
        this.delegate.listen((Handler)new Handler<AsyncResult<io.vertx.core.net.NetServer>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetServer> event) {
                Object f = event.succeeded() ? InternalHelper.result(new NetServer((io.vertx.core.net.NetServer)event.result())) : InternalHelper.failure(event.cause());
                listenHandler.handle(f);
            }
        });
        return this;
    }

    public Observable<NetServer> listenObservable() {
        ObservableFuture<NetServer> listenHandler = RxHelper.observableFuture();
        this.listen(listenHandler.toHandler());
        return listenHandler;
    }

    public NetServer listen(int port, String host) {
        this.delegate.listen(port, host);
        return this;
    }

    public NetServer listen(int port, String host, final Handler<AsyncResult<NetServer>> listenHandler) {
        this.delegate.listen(port, host, (Handler)new Handler<AsyncResult<io.vertx.core.net.NetServer>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetServer> event) {
                Object f = event.succeeded() ? InternalHelper.result(new NetServer((io.vertx.core.net.NetServer)event.result())) : InternalHelper.failure(event.cause());
                listenHandler.handle(f);
            }
        });
        return this;
    }

    public Observable<NetServer> listenObservable(int port, String host) {
        ObservableFuture<NetServer> listenHandler = RxHelper.observableFuture();
        this.listen(port, host, listenHandler.toHandler());
        return listenHandler;
    }

    public NetServer listen(int port) {
        this.delegate.listen(port);
        return this;
    }

    public NetServer listen(int port, final Handler<AsyncResult<NetServer>> listenHandler) {
        this.delegate.listen(port, (Handler)new Handler<AsyncResult<io.vertx.core.net.NetServer>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetServer> event) {
                Object f = event.succeeded() ? InternalHelper.result(new NetServer((io.vertx.core.net.NetServer)event.result())) : InternalHelper.failure(event.cause());
                listenHandler.handle(f);
            }
        });
        return this;
    }

    public Observable<NetServer> listenObservable(int port) {
        ObservableFuture<NetServer> listenHandler = RxHelper.observableFuture();
        this.listen(port, listenHandler.toHandler());
        return listenHandler;
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.close(completionHandler);
    }

    public Observable<Void> closeObservable() {
        ObservableFuture<Void> completionHandler = RxHelper.observableFuture();
        this.close(completionHandler.toHandler());
        return completionHandler;
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    public static NetServer newInstance(io.vertx.core.net.NetServer arg) {
        return arg != null ? new NetServer(arg) : null;
    }
}

