/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.impl.WorkerExecutorInternal;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.plugins.RxJavaPlugins;
import rx.plugins.RxJavaSchedulersHook;

public class ContextScheduler
extends Scheduler {
    private final RxJavaSchedulersHook schedulersHook = RxJavaPlugins.getInstance().getSchedulersHook();
    private final Vertx vertx;
    private final Context context;
    private final WorkerExecutor workerExecutor;
    private final boolean blocking;
    private final boolean ordered;
    private static final Object DUMB = new JsonObject();

    public ContextScheduler(Context context, boolean blocking) {
        this(context, blocking, true);
    }

    public ContextScheduler(Context context, boolean blocking, boolean ordered) {
        Objects.requireNonNull(context, "context is null");
        this.vertx = context.owner();
        this.context = context;
        this.workerExecutor = null;
        this.blocking = blocking;
        this.ordered = ordered;
    }

    public ContextScheduler(Vertx vertx, boolean blocking) {
        this(vertx, blocking, true);
    }

    public ContextScheduler(Vertx vertx, boolean blocking, boolean ordered) {
        Objects.requireNonNull(vertx, "vertx is null");
        this.vertx = vertx;
        this.context = null;
        this.workerExecutor = null;
        this.blocking = blocking;
        this.ordered = ordered;
    }

    public ContextScheduler(WorkerExecutor workerExecutor) {
        this(workerExecutor, true);
    }

    public ContextScheduler(WorkerExecutor workerExecutor, boolean ordered) {
        Objects.requireNonNull(workerExecutor, "workerExecutor is null");
        this.vertx = ((WorkerExecutorInternal)workerExecutor).vertx();
        this.context = null;
        this.workerExecutor = workerExecutor;
        this.blocking = true;
        this.ordered = ordered;
    }

    public ContextWorker createWorker() {
        return new ContextWorker();
    }

    public class ContextWorker
    extends Scheduler.Worker {
        private final ConcurrentHashMap<TimedAction, Object> actions = new ConcurrentHashMap();
        private final AtomicBoolean cancelled = new AtomicBoolean();

        public int countActions() {
            return this.actions.size();
        }

        public Subscription schedule(Action0 action) {
            return this.schedule(action, 0L, TimeUnit.MILLISECONDS);
        }

        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            action = ContextScheduler.this.schedulersHook.onSchedule(action);
            long delayMillis = unit.toMillis(delayTime);
            TimedAction timed = new TimedAction(action, 0L);
            this.actions.put(timed, DUMB);
            timed.schedule(delayMillis);
            return timed;
        }

        public Subscription schedulePeriodically(Action0 action, long initialDelay, long period, TimeUnit unit) {
            action = ContextScheduler.this.schedulersHook.onSchedule(action);
            long delayMillis = unit.toMillis(initialDelay);
            TimedAction timed = new TimedAction(action, unit.toMillis(period));
            this.actions.put(timed, DUMB);
            timed.schedule(delayMillis);
            return timed;
        }

        public void unsubscribe() {
            if (this.cancelled.compareAndSet(false, true)) {
                ((ConcurrentHashMap.KeySetView)this.actions.keySet()).forEach(TimedAction::unsubscribe);
            }
        }

        public boolean isUnsubscribed() {
            return this.cancelled.get();
        }

        class TimedAction
        implements Subscription {
            private long id;
            private final Action0 action;
            private final long periodMillis;
            private boolean disposed = false;

            TimedAction(Action0 action, long periodMillis) {
                this.action = action;
                this.periodMillis = periodMillis;
            }

            private synchronized void schedule(long delayMillis) {
                if (delayMillis > 0L) {
                    this.id = ContextScheduler.this.vertx.setTimer(delayMillis, this::execute);
                } else {
                    this.id = -1L;
                    this.execute(null);
                }
            }

            private void execute(Object arg) {
                if (ContextScheduler.this.workerExecutor != null) {
                    ContextScheduler.this.workerExecutor.executeBlocking(fut -> {
                        this.run(null);
                        fut.complete();
                    }, ContextScheduler.this.ordered, null);
                } else {
                    Context ctx;
                    Context context = ctx = ContextScheduler.this.context != null ? ContextScheduler.this.context : ContextScheduler.this.vertx.getOrCreateContext();
                    if (ContextScheduler.this.blocking) {
                        ctx.executeBlocking(fut -> {
                            this.run(null);
                            fut.complete();
                        }, ContextScheduler.this.ordered, null);
                    } else {
                        ctx.runOnContext(this::run);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void run(Object arg) {
                TimedAction timedAction = this;
                synchronized (timedAction) {
                    if (this.disposed) {
                        return;
                    }
                }
                this.action.call();
                timedAction = this;
                synchronized (timedAction) {
                    if (!this.disposed) {
                        if (this.periodMillis > 0L) {
                            this.schedule(this.periodMillis);
                        } else {
                            this.disposed = true;
                            ContextWorker.this.actions.remove(this);
                        }
                    }
                }
            }

            public synchronized void unsubscribe() {
                if (!this.disposed) {
                    ContextWorker.this.actions.remove(this);
                    if (this.id > 0L) {
                        ContextScheduler.this.vertx.cancelTimer(this.id);
                    }
                    this.disposed = true;
                }
            }

            public synchronized boolean isUnsubscribed() {
                return this.disposed;
            }
        }
    }
}

