/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.dns;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.dns.MxRecord;
import io.vertx.rxjava.core.dns.SrvRecord;
import java.util.List;
import java.util.stream.Collectors;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.dns.DnsClient.class)
public class DnsClient {
    public static final TypeArg<DnsClient> __TYPE_ARG = new TypeArg(obj -> new DnsClient((io.vertx.core.dns.DnsClient)obj), DnsClient::getDelegate);
    private final io.vertx.core.dns.DnsClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsClient that = (DnsClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public DnsClient(io.vertx.core.dns.DnsClient delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.dns.DnsClient getDelegate() {
        return this.delegate;
    }

    public DnsClient lookup(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup(name, handler);
        return this;
    }

    @Deprecated
    public Observable<String> lookupObservable(String name) {
        ObservableFuture<String> handler = RxHelper.observableFuture();
        this.lookup(name, handler.toHandler());
        return handler;
    }

    public Single<String> rxLookup(String name) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lookup(name, (Handler<AsyncResult<String>>)fut)));
    }

    public DnsClient lookup4(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup4(name, handler);
        return this;
    }

    @Deprecated
    public Observable<String> lookup4Observable(String name) {
        ObservableFuture<String> handler = RxHelper.observableFuture();
        this.lookup4(name, handler.toHandler());
        return handler;
    }

    public Single<String> rxLookup4(String name) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lookup4(name, (Handler<AsyncResult<String>>)fut)));
    }

    public DnsClient lookup6(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.lookup6(name, handler);
        return this;
    }

    @Deprecated
    public Observable<String> lookup6Observable(String name) {
        ObservableFuture<String> handler = RxHelper.observableFuture();
        this.lookup6(name, handler.toHandler());
        return handler;
    }

    public Single<String> rxLookup6(String name) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.lookup6(name, (Handler<AsyncResult<String>>)fut)));
    }

    public DnsClient resolveA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveA(name, handler);
        return this;
    }

    @Deprecated
    public Observable<List<String>> resolveAObservable(String name) {
        ObservableFuture<List<String>> handler = RxHelper.observableFuture();
        this.resolveA(name, handler.toHandler());
        return handler;
    }

    public Single<List<String>> rxResolveA(String name) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.resolveA(name, (Handler<AsyncResult<List<String>>>)fut)));
    }

    public DnsClient resolveAAAA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveAAAA(name, handler);
        return this;
    }

    @Deprecated
    public Observable<List<String>> resolveAAAAObservable(String name) {
        ObservableFuture<List<String>> handler = RxHelper.observableFuture();
        this.resolveAAAA(name, handler.toHandler());
        return handler;
    }

    public Single<List<String>> rxResolveAAAA(String name) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.resolveAAAA(name, (Handler<AsyncResult<List<String>>>)fut)));
    }

    public DnsClient resolveCNAME(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveCNAME(name, handler);
        return this;
    }

    @Deprecated
    public Observable<List<String>> resolveCNAMEObservable(String name) {
        ObservableFuture<List<String>> handler = RxHelper.observableFuture();
        this.resolveCNAME(name, handler.toHandler());
        return handler;
    }

    public Single<List<String>> rxResolveCNAME(String name) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.resolveCNAME(name, (Handler<AsyncResult<List<String>>>)fut)));
    }

    public DnsClient resolveMX(String name, final Handler<AsyncResult<List<MxRecord>>> handler) {
        this.delegate.resolveMX(name, (Handler)new Handler<AsyncResult<List<io.vertx.core.dns.MxRecord>>>(){

            public void handle(AsyncResult<List<io.vertx.core.dns.MxRecord>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(((List)ar.result()).stream().map(elt -> MxRecord.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<List<MxRecord>> resolveMXObservable(String name) {
        ObservableFuture<List<MxRecord>> handler = RxHelper.observableFuture();
        this.resolveMX(name, handler.toHandler());
        return handler;
    }

    public Single<List<MxRecord>> rxResolveMX(String name) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.resolveMX(name, (Handler<AsyncResult<List<MxRecord>>>)fut)));
    }

    public DnsClient resolveTXT(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveTXT(name, handler);
        return this;
    }

    @Deprecated
    public Observable<List<String>> resolveTXTObservable(String name) {
        ObservableFuture<List<String>> handler = RxHelper.observableFuture();
        this.resolveTXT(name, handler.toHandler());
        return handler;
    }

    public Single<List<String>> rxResolveTXT(String name) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.resolveTXT(name, (Handler<AsyncResult<List<String>>>)fut)));
    }

    public DnsClient resolvePTR(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.resolvePTR(name, handler);
        return this;
    }

    @Deprecated
    public Observable<String> resolvePTRObservable(String name) {
        ObservableFuture<String> handler = RxHelper.observableFuture();
        this.resolvePTR(name, handler.toHandler());
        return handler;
    }

    public Single<String> rxResolvePTR(String name) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.resolvePTR(name, (Handler<AsyncResult<String>>)fut)));
    }

    public DnsClient resolveNS(String name, Handler<AsyncResult<List<String>>> handler) {
        this.delegate.resolveNS(name, handler);
        return this;
    }

    @Deprecated
    public Observable<List<String>> resolveNSObservable(String name) {
        ObservableFuture<List<String>> handler = RxHelper.observableFuture();
        this.resolveNS(name, handler.toHandler());
        return handler;
    }

    public Single<List<String>> rxResolveNS(String name) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.resolveNS(name, (Handler<AsyncResult<List<String>>>)fut)));
    }

    public DnsClient resolveSRV(String name, final Handler<AsyncResult<List<SrvRecord>>> handler) {
        this.delegate.resolveSRV(name, (Handler)new Handler<AsyncResult<List<io.vertx.core.dns.SrvRecord>>>(){

            public void handle(AsyncResult<List<io.vertx.core.dns.SrvRecord>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(((List)ar.result()).stream().map(elt -> SrvRecord.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<List<SrvRecord>> resolveSRVObservable(String name) {
        ObservableFuture<List<SrvRecord>> handler = RxHelper.observableFuture();
        this.resolveSRV(name, handler.toHandler());
        return handler;
    }

    public Single<List<SrvRecord>> rxResolveSRV(String name) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.resolveSRV(name, (Handler<AsyncResult<List<SrvRecord>>>)fut)));
    }

    public DnsClient reverseLookup(String ipaddress, Handler<AsyncResult<String>> handler) {
        this.delegate.reverseLookup(ipaddress, handler);
        return this;
    }

    @Deprecated
    public Observable<String> reverseLookupObservable(String ipaddress) {
        ObservableFuture<String> handler = RxHelper.observableFuture();
        this.reverseLookup(ipaddress, handler.toHandler());
        return handler;
    }

    public Single<String> rxReverseLookup(String ipaddress) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.reverseLookup(ipaddress, (Handler<AsyncResult<String>>)fut)));
    }

    public static DnsClient newInstance(io.vertx.core.dns.DnsClient arg) {
        return arg != null ? new DnsClient(arg) : null;
    }
}

