/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.json;

import com.fasterxml.jackson.core.type.TypeReference;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Single;
import io.reactivex.annotations.NonNull;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;

public class ObservableUnmarshaller<T, B>
implements ObservableTransformer<B, T> {
    private final Function<B, Buffer> unwrap;
    private final Class<T> mappedType;
    private final TypeReference<T> mappedTypeRef;

    public ObservableUnmarshaller(Function<B, Buffer> unwrap, Class<T> mappedType) {
        this.unwrap = unwrap;
        this.mappedType = mappedType;
        this.mappedTypeRef = null;
    }

    public ObservableUnmarshaller(Function<B, Buffer> unwrap, TypeReference<T> mappedTypeRef) {
        this.unwrap = unwrap;
        this.mappedType = null;
        this.mappedTypeRef = mappedTypeRef;
    }

    public ObservableSource<T> apply(@NonNull Observable<B> upstream) {
        Observable unwrapped = upstream.map(this.unwrap::apply);
        Single aggregated = unwrapped.collect(Buffer::buffer, Buffer::appendBuffer);
        Maybe unmarshalled = aggregated.toMaybe().concatMap(buffer -> {
            if (buffer.length() > 0) {
                try {
                    Object obj = Objects.nonNull(this.mappedType) ? Json.mapper.readValue(buffer.getBytes(), this.mappedType) : Json.mapper.readValue(buffer.getBytes(), this.mappedTypeRef);
                    return Maybe.just((Object)obj);
                }
                catch (IOException e) {
                    return Maybe.error((Throwable)e);
                }
            }
            return Maybe.empty();
        });
        return unmarshalled.toObservable();
    }
}

