/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.api.RequestParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class RequestParameterImpl
implements RequestParameter {
    private String name;
    private Object value;

    public RequestParameterImpl(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public RequestParameter merge(RequestParameter mergingObj) {
        if (this.isArray() && mergingObj.isArray()) {
            mergingObj.getArray().addAll(this.getArray());
        } else if (this.isObject() && mergingObj.isObject()) {
            HashMap<String, RequestParameter> map = new HashMap<String, RequestParameter>();
            map.putAll((Map)this.value);
            for (String key : mergingObj.getObjectKeys()) {
                map.put(key, mergingObj.getObjectValue(key));
            }
            mergingObj.setValue(map);
        }
        return mergingObj;
    }

    public RequestParameterImpl(String name) {
        this(name, null);
    }

    public RequestParameterImpl() {
        this(null, null);
    }

    @Override
    public @Nullable String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public @Nullable List<String> getObjectKeys() {
        return this.isObject() ? new ArrayList(((Map)this.value).keySet()) : null;
    }

    @Override
    public RequestParameter getObjectValue(String key) {
        return this.isObject() ? (RequestParameter)((Map)this.value).get(key) : null;
    }

    @Override
    public boolean isObject() {
        return !this.isNull() && this.value instanceof Map;
    }

    @Override
    public @Nullable List<RequestParameter> getArray() {
        return this.isArray() ? (List)this.value : null;
    }

    @Override
    public boolean isArray() {
        return !this.isNull() && this.value instanceof List;
    }

    @Override
    public @Nullable String getString() {
        return this.isString() ? (String)this.value : null;
    }

    @Override
    public boolean isString() {
        return !this.isNull() && this.value instanceof String;
    }

    @Override
    public @Nullable Integer getInteger() {
        return this.isInteger() ? (Integer)this.value : null;
    }

    @Override
    public boolean isInteger() {
        return !this.isNull() && this.value instanceof Integer;
    }

    @Override
    public @Nullable Long getLong() {
        return this.isLong() ? (Long)this.value : null;
    }

    @Override
    public boolean isLong() {
        return !this.isNull() && this.value instanceof Long;
    }

    @Override
    public @Nullable Float getFloat() {
        return this.isFloat() ? (Float)this.value : null;
    }

    @Override
    public boolean isFloat() {
        return !this.isNull() && this.value instanceof Float;
    }

    @Override
    public @Nullable Double getDouble() {
        return this.isDouble() ? (Double)this.value : null;
    }

    @Override
    public boolean isDouble() {
        return !this.isNull() && this.value instanceof Double;
    }

    @Override
    public @Nullable Boolean getBoolean() {
        return this.isBoolean() ? (Boolean)this.value : null;
    }

    @Override
    public boolean isBoolean() {
        return !this.isNull() && this.value instanceof Boolean;
    }

    @Override
    public @Nullable JsonObject getJsonObject() {
        return this.isJsonObject() ? (JsonObject)this.value : null;
    }

    @Override
    public boolean isJsonObject() {
        return !this.isNull() && this.value instanceof JsonObject;
    }

    @Override
    public @Nullable JsonArray getJsonArray() {
        return this.isJsonArray() ? (JsonArray)this.value : null;
    }

    @Override
    public boolean isJsonArray() {
        return !this.isNull() && this.value instanceof JsonArray;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean isEmpty() {
        return this.isNull();
    }

    @Override
    public Object toJson() {
        if (this.isArray()) {
            return new JsonArray(this.getArray().stream().map(RequestParameter::toJson).collect(Collectors.toList()));
        }
        if (this.isObject()) {
            return ((Map)this.value).entrySet().stream().collect(Collector.of(JsonObject::new, (j, e) -> j.put((String)e.getKey(), ((RequestParameter)e.getValue()).toJson()), JsonObject::mergeIn, new Collector.Characteristics[0]));
        }
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestParameterImpl that = (RequestParameterImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }
}

