/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.RequestParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collector;

public class RequestParametersImpl
implements RequestParameters {
    private Map<String, RequestParameter> pathParameters = new HashMap<String, RequestParameter>();
    private Map<String, RequestParameter> queryParameters = new HashMap<String, RequestParameter>();
    private Map<String, RequestParameter> headerParameters = new HashMap<String, RequestParameter>();
    private Map<String, RequestParameter> cookieParameters = new HashMap<String, RequestParameter>();
    private Map<String, RequestParameter> formParameters = new HashMap<String, RequestParameter>();
    private RequestParameter body = null;

    public void setPathParameters(Map<String, RequestParameter> pathParameters) {
        if (pathParameters != null) {
            this.pathParameters = pathParameters;
        }
    }

    public void setQueryParameters(Map<String, RequestParameter> queryParameters) {
        if (queryParameters != null) {
            this.queryParameters = queryParameters;
        }
    }

    public void setHeaderParameters(Map<String, RequestParameter> headerParameters) {
        if (headerParameters != null) {
            this.headerParameters = headerParameters;
        }
    }

    public void setCookieParameters(Map<String, RequestParameter> cookieParameters) {
        if (cookieParameters != null) {
            this.cookieParameters = cookieParameters;
        }
    }

    public void setFormParameters(Map<String, RequestParameter> formParameters) {
        if (formParameters != null) {
            this.formParameters = formParameters;
        }
    }

    public void setBody(RequestParameter body) {
        if (body != null) {
            this.body = body;
        }
    }

    public void merge(RequestParametersImpl other) {
        if (other.pathParameters != null) {
            this.pathParameters.putAll(other.pathParameters);
        }
        if (other.queryParameters != null) {
            this.queryParameters.putAll(other.queryParameters);
        }
        if (other.headerParameters != null) {
            this.headerParameters.putAll(other.headerParameters);
        }
        if (other.cookieParameters != null) {
            this.cookieParameters.putAll(other.cookieParameters);
        }
        if (other.formParameters != null) {
            this.formParameters.putAll(other.formParameters);
        }
        this.body = other.body == null ? this.body : other.body;
    }

    @Override
    public List<String> pathParametersNames() {
        return new ArrayList<String>(this.pathParameters.keySet());
    }

    @Override
    public RequestParameter pathParameter(String name) {
        return this.pathParameters.get(name);
    }

    @Override
    public List<String> queryParametersNames() {
        return new ArrayList<String>(this.queryParameters.keySet());
    }

    @Override
    public RequestParameter queryParameter(String name) {
        return this.queryParameters.get(name);
    }

    @Override
    public List<String> headerParametersNames() {
        return new ArrayList<String>(this.headerParameters.keySet());
    }

    @Override
    public RequestParameter headerParameter(String name) {
        return this.headerParameters.get(name);
    }

    @Override
    public List<String> cookieParametersNames() {
        return new ArrayList<String>(this.cookieParameters.keySet());
    }

    @Override
    public RequestParameter cookieParameter(String name) {
        return this.cookieParameters.get(name);
    }

    @Override
    public List<String> formParametersNames() {
        return new ArrayList<String>(this.formParameters.keySet());
    }

    @Override
    public RequestParameter formParameter(String name) {
        return this.formParameters.get(name);
    }

    @Override
    public RequestParameter body() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestParametersImpl that = (RequestParametersImpl)o;
        return Objects.equals(this.pathParameters, that.pathParameters) && Objects.equals(this.queryParameters, that.queryParameters) && Objects.equals(this.headerParameters, that.headerParameters) && Objects.equals(this.cookieParameters, that.cookieParameters) && Objects.equals(this.formParameters, that.formParameters) && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.pathParameters, this.queryParameters, this.headerParameters, this.cookieParameters, this.formParameters, this.body);
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.put("path", this.mapToJsonObject(this.pathParameters));
        root.put("query", this.mapToJsonObject(this.queryParameters));
        root.put("header", this.mapToJsonObject(this.headerParameters));
        root.put("cookie", this.mapToJsonObject(this.cookieParameters));
        root.put("form", this.mapToJsonObject(this.formParameters));
        if (this.body != null) {
            root.put("body", this.body.toJson());
        }
        return root;
    }

    private JsonObject mapToJsonObject(Map<String, RequestParameter> params) {
        return params.entrySet().stream().collect(Collector.of(JsonObject::new, (j, e) -> j.put((String)e.getKey(), ((RequestParameter)e.getValue()).toJson()), JsonObject::mergeIn, new Collector.Characteristics[0]));
    }
}

