/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation.impl;

import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.validation.ContainerDeserializer;
import io.vertx.ext.web.api.validation.ContainerSerializationStyle;
import io.vertx.ext.web.api.validation.ParameterTypeValidator;
import io.vertx.ext.web.api.validation.ValidationException;
import io.vertx.ext.web.api.validation.impl.ContainerTypeValidator;
import java.util.ArrayList;
import java.util.List;

public class ArrayTypeValidator
extends ContainerTypeValidator<List<String>> {
    private ParameterTypeValidator validator;
    private Integer maxItems;
    private Integer minItems;

    public ArrayTypeValidator(ParameterTypeValidator validator, ContainerDeserializer collectionFormat, boolean exploded, Integer maxItems, Integer minItems) {
        super(collectionFormat, exploded);
        if (this.validator instanceof ContainerTypeValidator && exploded) {
            throw new RuntimeException("Illegal inner type validator");
        }
        this.validator = validator;
        this.maxItems = maxItems;
        this.minItems = minItems;
    }

    private boolean checkMinItems(int size) {
        if (this.minItems != null) {
            return size >= this.minItems;
        }
        return true;
    }

    private boolean checkMaxItems(int size) {
        if (this.maxItems != null) {
            return size <= this.maxItems;
        }
        return true;
    }

    @Override
    public RequestParameter isValid(String value) throws ValidationException {
        return this.validate((List<String>)this.deserialize(value));
    }

    @Override
    public RequestParameter isValidCollection(List<String> value) throws ValidationException {
        if (value.size() > 1 && this.isExploded()) {
            return this.validate(value);
        }
        return this.validate((List<String>)this.deserialize(value.get(0)));
    }

    @Override
    protected List<String> deserialize(String serialized) {
        return this.getContainerDeserializer().deserializeArray(serialized);
    }

    @Override
    protected RequestParameter validate(List<String> values) {
        if (values == null || !this.checkMaxItems(values.size()) || !this.checkMinItems(values.size())) {
            throw ValidationException.ValidationExceptionFactory.generateUnexpectedArraySizeValidationException(this.getMaxItems(), this.getMinItems(), values == null ? 0 : values.size());
        }
        ArrayList<RequestParameter> parsedParams = new ArrayList<RequestParameter>();
        for (String s : values) {
            RequestParameter parsed = this.validator.isValid(s);
            parsedParams.add(parsed);
        }
        return RequestParameter.create(parsedParams);
    }

    public ParameterTypeValidator getInnerValidator() {
        return this.validator;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public static class ArrayTypeValidatorFactory {
        public static ArrayTypeValidator createArrayTypeValidator(ParameterTypeValidator arrayMembersValidator) {
            return ArrayTypeValidatorFactory.createArrayTypeValidator(arrayMembersValidator, "csv", true);
        }

        public static ArrayTypeValidator createArrayTypeValidator(ParameterTypeValidator arrayMembersValidator, String collectionFormat, boolean exploded) {
            return ArrayTypeValidatorFactory.createArrayTypeValidator(arrayMembersValidator, collectionFormat, exploded, null, null);
        }

        public static ArrayTypeValidator createArrayTypeValidator(ParameterTypeValidator arrayMembersValidator, String collectionFormat, Integer maxItems, Integer minItems) {
            return ArrayTypeValidatorFactory.createArrayTypeValidator(arrayMembersValidator, collectionFormat, true, maxItems, minItems);
        }

        public static ArrayTypeValidator createArrayTypeValidator(ParameterTypeValidator arrayMembersValidator, String collectionFormat, boolean exploded, Integer maxItems, Integer minItems) {
            return new ArrayTypeValidator(arrayMembersValidator, ContainerSerializationStyle.getContainerStyle(collectionFormat).deserializer(), exploded, maxItems, minItems);
        }
    }
}

