/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation.impl;

import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.validation.ParameterTypeValidator;
import io.vertx.ext.web.api.validation.ValidationException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XMLTypeValidator
implements ParameterTypeValidator {
    private Validator schemaValidator;

    private XMLTypeValidator(Validator schemaValidator) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.schemaValidator = schemaValidator;
        this.schemaValidator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        this.schemaValidator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
    }

    @Override
    public RequestParameter isValid(String value) throws ValidationException {
        try {
            DocumentBuilder parser = XMLTypeValidator.createDocumentBuilderFactoryInstance().newDocumentBuilder();
            Document document = parser.parse(value);
            this.schemaValidator.validate(new DOMSource(document));
            return RequestParameter.create(document);
        }
        catch (Exception e) {
            throw ValidationException.ValidationExceptionFactory.generateInvalidXMLBodyException(e.getMessage());
        }
    }

    private static DocumentBuilderFactory createDocumentBuilderFactoryInstance() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        String FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
        dbf.setFeature(FEATURE, true);
        FEATURE = "http://xml.org/sax/features/external-general-entities";
        dbf.setFeature(FEATURE, false);
        FEATURE = "http://xml.org/sax/features/external-parameter-entities";
        dbf.setFeature(FEATURE, false);
        FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        dbf.setFeature(FEATURE, false);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        return dbf;
    }

    private static SchemaFactory createSchemaFactoryInstance() throws SAXNotRecognizedException, SAXNotSupportedException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return factory;
    }

    public static class XMLTypeValidatorFactory {
        public static XMLTypeValidator createXMLTypeValidator(String xmlSchema) {
            try {
                SchemaFactory factory = XMLTypeValidator.createSchemaFactoryInstance();
                StreamSource xmlSchemaSource = new StreamSource(new StringReader(xmlSchema));
                return new XMLTypeValidator(factory.newSchema(xmlSchemaSource).newValidator());
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

