/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.zookeeper.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.spi.cluster.zookeeper.impl.AsyncMapTTLMonitor;
import io.vertx.spi.cluster.zookeeper.impl.ZKMap;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.zookeeper.data.Stat;

public class ZKAsyncMap<K, V>
extends ZKMap<K, V>
implements AsyncMap<K, V> {
    private final PathChildrenCache curatorCache;
    private AsyncMapTTLMonitor<K, V> asyncMapTTLMonitor;

    public ZKAsyncMap(Vertx vertx, CuratorFramework curator, AsyncMapTTLMonitor<K, V> asyncMapTTLMonitor, String mapName) {
        super(curator, vertx, "asyncMap", mapName);
        this.curatorCache = new PathChildrenCache(curator, this.mapPath, true);
        try {
            this.asyncMapTTLMonitor = asyncMapTTLMonitor;
            this.curatorCache.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    public void get(K k, Handler<AsyncResult<V>> asyncResultHandler) {
        this.assertKeyIsNotNull(k).compose(aVoid -> this.checkExists(k)).compose(checkResult -> {
            Future future = Future.future();
            if (checkResult.booleanValue()) {
                ChildData childData = this.curatorCache.getCurrentData(this.keyPath(k));
                if (childData != null && childData.getData() != null) {
                    try {
                        Object value = this.asObject(childData.getData());
                        future.complete(value);
                    }
                    catch (Exception e) {
                        future.fail((Throwable)e);
                    }
                } else {
                    future.complete();
                }
            } else {
                future.complete();
            }
            return future;
        }).setHandler(asyncResultHandler);
    }

    public void put(K k, V v, Handler<AsyncResult<Void>> completionHandler) {
        this.put(k, v, Optional.empty(), completionHandler);
    }

    public void put(K k, V v, long timeout, Handler<AsyncResult<Void>> completionHandler) {
        this.put(k, v, Optional.of(timeout), completionHandler);
    }

    private void put(K k, V v, Optional<Long> timeoutOptional, Handler<AsyncResult<Void>> completionHandler) {
        this.assertKeyAndValueAreNotNull(k, v).compose(aVoid -> this.checkExists(k)).compose(checkResult -> checkResult != false ? this.setData(k, v) : this.create(k, v)).compose(aVoid -> {
            JsonObject body = new JsonObject().put("keyPath", this.keyPath(k));
            if (timeoutOptional.isPresent()) {
                this.asyncMapTTLMonitor.addAsyncMapWithPath(this.keyPath(k), this);
                body.put("timeout", (Long)timeoutOptional.get());
            } else {
                body.put("isCancel", Boolean.valueOf(true));
            }
            this.vertx.eventBus().publish("__VERTX_ZK_TTL_HANDLER_ADDRESS", (Object)body);
            Future future = Future.future();
            future.complete();
            return future;
        }).setHandler(completionHandler);
    }

    public void putIfAbsent(K k, V v, Handler<AsyncResult<V>> completionHandler) {
        this.putIfAbsent(k, v, Optional.empty(), completionHandler);
    }

    public void putIfAbsent(K k, V v, long timeout, Handler<AsyncResult<V>> completionHandler) {
        this.putIfAbsent(k, v, Optional.of(timeout), completionHandler);
    }

    private void putIfAbsent(K k, V v, Optional<Long> timeoutOptional, Handler<AsyncResult<V>> completionHandler) {
        this.assertKeyAndValueAreNotNull(k, v).compose(aVoid -> {
            Future innerFuture = Future.future();
            this.vertx.executeBlocking(future -> {
                long startTime = Instant.now().toEpochMilli();
                int retries = 0;
                try {
                    Object currentValue;
                    String path;
                    Stat stat;
                    while (!this.compareAndSet(startTime, retries++, stat = new Stat(), path = this.keyPath(k), currentValue = this.getData(stat, path), v)) {
                    }
                    future.complete(currentValue);
                    return;
                }
                catch (Exception e) {
                    future.fail((Throwable)e);
                    return;
                }
            }, false, innerFuture.completer());
            return innerFuture;
        }).compose(value -> {
            JsonObject body = new JsonObject().put("keyPath", this.keyPath(k));
            if (timeoutOptional.isPresent()) {
                this.asyncMapTTLMonitor.addAsyncMapWithPath(this.keyPath(k), this);
                body.put("timeout", (Long)timeoutOptional.get());
            } else {
                body.put("isCancel", Boolean.valueOf(true));
            }
            this.vertx.eventBus().publish("__VERTX_ZK_TTL_HANDLER_ADDRESS", (Object)body);
            return Future.succeededFuture((Object)value);
        }).setHandler(completionHandler);
    }

    public void remove(K k, Handler<AsyncResult<V>> asyncResultHandler) {
        this.assertKeyIsNotNull(k).compose(aVoid -> {
            Future future = Future.future();
            this.get(k, future.completer());
            return future;
        }).compose(value -> {
            Future future = Future.future();
            if (value != null) {
                return this.delete(k, value);
            }
            future.complete();
            return future;
        }).setHandler(asyncResultHandler);
    }

    public void removeIfPresent(K k, V v, Handler<AsyncResult<Boolean>> resultHandler) {
        this.assertKeyAndValueAreNotNull(k, v).compose(aVoid -> {
            Future future = Future.future();
            this.get(k, future.completer());
            return future;
        }).compose(value -> {
            Future future = Future.future();
            if (value.equals(v)) {
                this.delete(k, v).setHandler(deleteResult -> {
                    if (deleteResult.succeeded()) {
                        future.complete((Object)true);
                    } else {
                        future.fail(deleteResult.cause());
                    }
                });
            } else {
                future.complete((Object)false);
            }
            return future;
        }).setHandler(resultHandler);
    }

    public void replace(K k, V v, Handler<AsyncResult<V>> asyncResultHandler) {
        this.assertKeyAndValueAreNotNull(k, v).compose(aVoid -> {
            Future innerFuture = Future.future();
            this.vertx.executeBlocking(future -> {
                long startTime = Instant.now().toEpochMilli();
                int retries = 0;
                try {
                    Object currentValue;
                    String path;
                    Stat stat;
                    do {
                        if ((currentValue = this.getData(stat = new Stat(), path = this.keyPath(k))) != null) continue;
                        future.complete(null);
                        return;
                    } while (!this.compareAndSet(startTime, retries++, stat, path, currentValue, v));
                    future.complete(currentValue);
                    return;
                }
                catch (Exception e) {
                    future.fail((Throwable)e);
                    return;
                }
            }, false, innerFuture.completer());
            return innerFuture;
        }).setHandler(asyncResultHandler);
    }

    public void replaceIfPresent(K k, V oldValue, V newValue, Handler<AsyncResult<Boolean>> resultHandler) {
        this.assertKeyIsNotNull(k).compose(aVoid -> this.assertValueIsNotNull(oldValue)).compose(aVoid -> this.assertValueIsNotNull(newValue)).compose(aVoid -> {
            Future innerFuture = Future.future();
            this.vertx.executeBlocking(future -> {
                long startTime = Instant.now().toEpochMilli();
                int retries = 0;
                try {
                    String path;
                    Stat stat;
                    do {
                        Object currentValue;
                        if ((currentValue = this.getData(stat = new Stat(), path = this.keyPath(k))).equals(oldValue)) continue;
                        future.complete((Object)false);
                        return;
                    } while (!this.compareAndSet(startTime, retries++, stat, path, oldValue, newValue));
                    future.complete((Object)true);
                    return;
                }
                catch (Exception e) {
                    future.fail((Throwable)e);
                    return;
                }
            }, false, innerFuture.completer());
            return innerFuture;
        }).setHandler(resultHandler);
    }

    public void clear(Handler<AsyncResult<Void>> resultHandler) {
        this.delete(this.mapPath, null).setHandler(result -> {
            if (result.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture());
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)result.cause()));
            }
        });
    }

    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        try {
            ((ErrorListenerPathable)this.curator.getChildren().inBackground((client, event) -> this.vertx.runOnContext(aVoid -> resultHandler.handle((Object)Future.succeededFuture((Object)event.getChildren().size()))))).forPath(this.mapPath);
        }
        catch (Exception e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public void keys(Handler<AsyncResult<Set<K>>> resultHandler) {
        Context context = this.vertx.getOrCreateContext();
        try {
            ((ErrorListenerPathable)this.curator.getChildren().inBackground((client, event) -> {
                HashSet keys = new HashSet();
                for (String base64Key : event.getChildren()) {
                    Object key;
                    byte[] binaryKey = Base64.getUrlDecoder().decode(base64Key);
                    try {
                        key = this.asObject(binaryKey);
                    }
                    catch (Exception e) {
                        context.runOnContext(v -> resultHandler.handle((Object)Future.failedFuture((Throwable)e)));
                        return;
                    }
                    keys.add(key);
                }
                context.runOnContext(v -> resultHandler.handle((Object)Future.succeededFuture((Object)keys)));
            })).forPath(this.mapPath);
        }
        catch (Exception e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public void values(Handler<AsyncResult<List<V>>> resultHandler) {
        Future keysFuture = Future.future();
        this.keys((Handler<AsyncResult<Set<K>>>)keysFuture);
        keysFuture.compose(keys -> {
            ArrayList<Future> futures = new ArrayList<Future>(keys.size());
            for (Object k : keys) {
                Future valueFuture = Future.future();
                this.get((K)k, (Handler<AsyncResult<V>>)valueFuture);
                futures.add(valueFuture);
            }
            return CompositeFuture.all(futures).map(compositeFuture -> {
                ArrayList<Object> values = new ArrayList<Object>(compositeFuture.size());
                for (int i = 0; i < compositeFuture.size(); ++i) {
                    values.add(compositeFuture.resultAt(i));
                }
                return values;
            });
        }).setHandler(resultHandler);
    }

    public void entries(Handler<AsyncResult<Map<K, V>>> resultHandler) {
        Future keysFuture = Future.future();
        this.keys((Handler<AsyncResult<Set<K>>>)keysFuture);
        keysFuture.map(ArrayList::new).compose(keys -> {
            ArrayList<Future> futures = new ArrayList<Future>(keys.size());
            for (Object k : keys) {
                Future valueFuture = Future.future();
                this.get((K)k, (Handler<AsyncResult<V>>)valueFuture);
                futures.add(valueFuture);
            }
            return CompositeFuture.all(futures).map(compositeFuture -> {
                HashMap map = new HashMap();
                for (int i = 0; i < compositeFuture.size(); ++i) {
                    map.put(keys.get(i), compositeFuture.resultAt(i));
                }
                return map;
            });
        }).setHandler(resultHandler);
    }

    @Override
    String keyPath(K k) {
        try {
            return this.keyPathPrefix() + Base64.getUrlEncoder().encodeToString(this.asByte(k));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String keyPathPrefix() {
        return this.mapPath + "/";
    }
}

