/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers;

import io.camunda.zeebe.client.ZeebeClient;
import org.apiguardian.api.API;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.TestcontainersConfiguration;

@API(status=API.Status.STABLE)
public final class ZeebeDefaults {
    private static final String ZEEBE_CONTAINER_IMAGE_PROPERTY = "zeebe.container.image";
    private static final String DEFAULT_ZEEBE_CONTAINER_IMAGE = "camunda/zeebe";
    private static final String ZEEBE_CONTAINER_VERSION_PROPERTY = "zeebe.container.version";
    private static final String DEFAULT_ZEEBE_VERSION = ZeebeClient.class.getPackage().getImplementationVersion();
    private static final String DEFAULT_ZEEBE_DATA_PATH = "/usr/local/zeebe/data";
    private static final String DEFAULT_ZEEBE_LOGS_PATH = "/usr/local/zeebe/logs";
    private static final String DEFAULT_ZEEBE_TMP_PATH = "/tmp";

    private ZeebeDefaults() {
    }

    public static ZeebeDefaults getInstance() {
        return Singleton.INSTANCE;
    }

    public String getDefaultImage() {
        return TestcontainersConfiguration.getInstance().getEnvVarOrProperty(ZEEBE_CONTAINER_IMAGE_PROPERTY, DEFAULT_ZEEBE_CONTAINER_IMAGE);
    }

    public String getDefaultVersion() {
        return TestcontainersConfiguration.getInstance().getEnvVarOrProperty(ZEEBE_CONTAINER_VERSION_PROPERTY, DEFAULT_ZEEBE_VERSION);
    }

    public DockerImageName getDefaultDockerImage() {
        return DockerImageName.parse((String)this.getDefaultImage()).withTag(this.getDefaultVersion());
    }

    public String getDefaultDataPath() {
        return DEFAULT_ZEEBE_DATA_PATH;
    }

    public String getDefaultLogsPath() {
        return DEFAULT_ZEEBE_LOGS_PATH;
    }

    public String getDefaultTmpPath() {
        return DEFAULT_ZEEBE_TMP_PATH;
    }

    private static final class Singleton {
        private static final ZeebeDefaults INSTANCE = new ZeebeDefaults();

        private Singleton() {
        }
    }
}

