/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers;

import io.zeebe.containers.ZeebePort;
import java.time.Duration;
import java.util.List;
import org.apiguardian.api.API;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.lifecycle.Startable;

public interface ZeebeNode<T extends GenericContainer<T>>
extends Container<T>,
WaitStrategyTarget,
Startable {
    default public String getInternalAddress(int port) {
        return this.getInternalHost() + ":" + port;
    }

    default public String getExternalAddress(int port) {
        return this.getExternalHost() + ":" + this.getMappedPort(port);
    }

    default public String getInternalClusterAddress() {
        return this.getInternalAddress(ZeebePort.INTERNAL.getPort());
    }

    default public String getExternalClusterAddress() {
        return this.getExternalAddress(ZeebePort.INTERNAL.getPort());
    }

    default public String getInternalMonitoringAddress() {
        return this.getInternalAddress(ZeebePort.MONITORING.getPort());
    }

    default public String getExternalMonitoringAddress() {
        return this.getExternalAddress(ZeebePort.MONITORING.getPort());
    }

    default public String getExternalHost() {
        return ((GenericContainer)this.self()).getHost();
    }

    @API(status=API.Status.EXPERIMENTAL)
    default public String getInternalHost() {
        GenericContainer container = (GenericContainer)this.self();
        List aliases = container.getNetworkAliases();
        if (aliases.isEmpty()) {
            return container.getContainerInfo().getName();
        }
        return (String)aliases.get(aliases.size() - 1);
    }

    @API(status=API.Status.EXPERIMENTAL)
    default public void shutdownGracefully(Duration timeout) {
        String containerId = this.getContainerId();
        if (containerId == null) {
            return;
        }
        this.getDockerClient().stopContainerCmd(containerId).withTimeout(Integer.valueOf((int)timeout.getSeconds())).exec();
    }

    @API(status=API.Status.EXPERIMENTAL)
    default public boolean isStarted() {
        return this.getContainerId() != null;
    }

    @API(status=API.Status.EXPERIMENTAL)
    default public T withAdditionalExposedPort(int port) {
        ((GenericContainer)this.self()).addExposedPorts(new int[]{port});
        return (T)((GenericContainer)this.self());
    }
}

