/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateVolumeCmd;
import com.github.dockerjava.api.command.CreateVolumeResponse;
import com.github.dockerjava.api.command.RemoveVolumeCmd;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.SELContext;
import com.github.dockerjava.api.model.Volume;
import io.zeebe.containers.ZeebeData;
import io.zeebe.containers.ZeebeDefaults;
import io.zeebe.containers.archive.ContainerArchive;
import io.zeebe.containers.archive.ContainerArchiveBuilder;
import io.zeebe.containers.util.TinyContainer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.apiguardian.api.API;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.ResourceReaper;

@API(status=API.Status.EXPERIMENTAL)
public class ZeebeVolume
implements AutoCloseable,
ZeebeData {
    private final String name;
    private final DockerClient client;

    protected ZeebeVolume(String name, DockerClient client) {
        this.name = name;
        this.client = client;
    }

    public String getName() {
        return this.name;
    }

    public Bind asBind(String mountPath) {
        return new Bind(this.name, new Volume(mountPath), AccessMode.rw, SELContext.none);
    }

    public Bind asZeebeBind() {
        return this.asBind(ZeebeDefaults.getInstance().getDefaultDataPath());
    }

    public void attachVolumeToContainer(CreateContainerCmd command) {
        HostConfig hostConfig = Objects.requireNonNull(command.getHostConfig()).withBinds(new Bind[]{this.asZeebeBind()});
        command.withHostConfig(hostConfig);
    }

    @Override
    public void close() {
        try (RemoveVolumeCmd command = this.client.removeVolumeCmd(this.name);){
            command.exec();
        }
    }

    public void extract(Path destination) throws IOException {
        this.extract(destination, UnaryOperator.identity());
    }

    public void extract(Path destination, UnaryOperator<ContainerArchiveBuilder> modifier) throws IOException {
        try (TinyContainer container = new TinyContainer();){
            container.withCreateContainerCmdModifier(this::attachVolumeToContainer);
            container.start();
            ContainerArchiveBuilder builder = ContainerArchive.builder().withContainer(container);
            ContainerArchive archive = ((ContainerArchiveBuilder)modifier.apply(builder)).build();
            archive.extract(destination);
        }
    }

    public static ZeebeVolume newVolume() {
        return ZeebeVolume.newVolume(UnaryOperator.identity());
    }

    public static ZeebeVolume newVolume(UnaryOperator<CreateVolumeCmd> configurator) {
        DockerClient client = DockerClientFactory.instance().client();
        HashMap labels = new HashMap();
        labels.putAll(DockerClientFactory.DEFAULT_LABELS);
        labels.putAll(ResourceReaper.instance().getLabels());
        try (CreateVolumeCmd command = client.createVolumeCmd().withLabels(labels);){
            CreateVolumeResponse response = (CreateVolumeResponse)((CreateVolumeCmd)configurator.apply(command)).exec();
            ZeebeVolume zeebeVolume = new ZeebeVolume(response.getName(), client);
            return zeebeVolume;
        }
    }

    @Override
    public <T extends GenericContainer<T>> void attach(T container) {
        container.withCreateContainerCmdModifier(this::attachVolumeToContainer);
    }
}

